/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.celleditor.popups;

import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Stack;
import oracle.dbtools.raptor.controls.celleditor.popups.LongCharEditPanel;
import oracle.dbtools.raptor.controls.celleditor.popups.PopupCellEditor;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.javatools.util.ModelUtil;

public class PopupCellEditorFactory {
    private int registrationSeq = 0;
    private static final String ORACLE_DRIVER = "oracle.jdbc.OracleDriver";
    private static HashMap<String, HashMap<Integer, Stack<LazyPopupCellEditorFactory>>> connectionToEditorsMap = new HashMap();

    public static void registerPopupEditor(int n, LazyPopupCellEditorFactory lazyPopupCellEditorFactory, String string) {
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, n, lazyPopupCellEditorFactory, string);
    }

    public static void registerPopupEditor(String string, int n, LazyPopupCellEditorFactory lazyPopupCellEditorFactory, String string2) {
        if (ModelUtil.hasLength((String)string)) {
            Integer n2;
            HashMap<Integer, Stack<LazyPopupCellEditorFactory>> hashMap;
            Stack<LazyPopupCellEditorFactory> stack;
            if (connectionToEditorsMap.get(string) == null) {
                connectionToEditorsMap.put(string, new HashMap());
            }
            if ((stack = (hashMap = connectionToEditorsMap.get(string)).get(n2 = Integer.valueOf(n))) == null) {
                stack = new Stack();
                hashMap.put(n2, stack);
            }
            stack.push(lazyPopupCellEditorFactory);
        }
    }

    public static void unRegisterPopupEditor(String string, int n, LazyPopupCellEditorFactory lazyPopupCellEditorFactory) {
        HashMap<Integer, Stack<LazyPopupCellEditorFactory>> hashMap;
        Stack<LazyPopupCellEditorFactory> stack;
        if (connectionToEditorsMap.get(string) != null && (stack = (hashMap = connectionToEditorsMap.get(string)).get(n)) != null) {
            stack.remove(lazyPopupCellEditorFactory);
        }
    }

    public static PopupCellEditor getPopupCellEditor(String string, int n, String string2) {
        PopupCellEditor popupCellEditor = null;
        String string3 = null;
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        if (properties != null) {
            string3 = properties.getProperty("driver");
        }
        if (ModelUtil.hasLength(string3)) {
            popupCellEditor = PopupCellEditorFactory.getPopupCellEditorForDriver(string3, n, string2);
        }
        return popupCellEditor;
    }

    public static PopupCellEditor getPopupCellEditor(String string, int n) {
        PopupCellEditor popupCellEditor = null;
        String string2 = null;
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        if (properties != null) {
            string2 = properties.getProperty("driver");
        }
        if (ModelUtil.hasLength(string2)) {
            popupCellEditor = PopupCellEditorFactory.getPopupCellEditorForDriver(string2, n);
        }
        return popupCellEditor;
    }

    public static PopupCellEditor getPopupCellEditorForDriver(String string, int n, String string2) {
        if (string.equals(ORACLE_DRIVER) && string2 != null && string2.equals("TIMESTAMP")) {
            return PopupCellEditorFactory.getPopupCellEditorForDriver(string, 93);
        }
        return PopupCellEditorFactory.getPopupCellEditorForDriver(string, n);
    }

    private static PopupCellEditor getPopupCellEditorForDriver(String string, int n) {
        Stack<LazyPopupCellEditorFactory> stack;
        LazyPopupCellEditorFactory lazyPopupCellEditorFactory = null;
        HashMap<Integer, Stack<LazyPopupCellEditorFactory>> hashMap = connectionToEditorsMap.get(string);
        if (hashMap != null && (stack = hashMap.get(n)) != null) {
            try {
                lazyPopupCellEditorFactory = stack.pop();
                if (lazyPopupCellEditorFactory != null) {
                    stack.push(lazyPopupCellEditorFactory);
                }
            }
            catch (EmptyStackException emptyStackException) {
                // empty catch block
            }
        }
        if (lazyPopupCellEditorFactory == null && !string.equals(ORACLE_DRIVER)) {
            return PopupCellEditorFactory.getPopupCellEditorForDriver(ORACLE_DRIVER, n);
        }
        return lazyPopupCellEditorFactory == null ? null : lazyPopupCellEditorFactory.getCellEditorInstance();
    }

    public static PopupCellEditor getPopupCellEditor(int n) {
        return PopupCellEditorFactory.getPopupCellEditor(ORACLE_DRIVER, n);
    }

    static {
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, 12, new DynamicPopupCellEditorFactory("oracle.dbtools.raptor.controls.celleditor.popups.LongCharEditPanel"), "VARCHAR");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, 1, new DynamicPopupCellEditorFactory(new LongCharEditPanel()), "CHAR");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, -9, new DynamicPopupCellEditorFactory("oracle.dbtools.raptor.controls.celleditor.popups.LongCharEditPanel"), "NVARCHAR");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, -15, new DynamicPopupCellEditorFactory("oracle.dbtools.raptor.controls.celleditor.popups.LongCharEditPanel"), "NCHAR");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, 91, new DynamicPopupCellEditorFactory("oracle.dbtools.raptor.controls.celleditor.popups.OracleDateTimeEditPanel"), "DATE");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, 92, new DynamicPopupCellEditorFactory("oracle.dbtools.raptor.controls.celleditor.popups.OracleDateTimeEditPanel"), "TIME");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, 93, new DynamicPopupCellEditorFactory("oracle.dbtools.raptor.controls.celleditor.popups.OracleTimestampEditPanel"), "TIMESTAMP");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, -102, new DynamicPopupCellEditorFactory("oracle.dbtools.raptor.controls.celleditor.popups.OracleTIMESTAMPLTZEditPanel"), "TIMESTAMPLTZ");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, -101, new DynamicPopupCellEditorFactory("oracle.dbtools.raptor.controls.celleditor.popups.OracleTIMESTAMPTZEditPanel"), "TIMESTAMPTZ");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, -13, new DynamicPopupCellEditorFactory("oracle.dbtools.raptor.controls.celleditor.popups.BFileEditPanel"), "BFILE");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, 2007, new DynamicPopupCellEditorFactory("oracle.dbtools.raptor.controls.celleditor.popups.XMLTypeEditPanel"), "OPAQUE");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, 2009, new DynamicPopupCellEditorFactory("oracle.dbtools.raptor.controls.celleditor.popups.XMLTypeEditPanel"), "XMLTYPE");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, 2003, new DynamicPopupCellEditorFactory("oracle.dbtools.raptor.controls.celleditor.popups.NestedTableEditPanel"), "ARRAY");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, -10, new DynamicPopupCellEditorFactory("oracle.dbtools.raptor.controls.celleditor.popups.NestedTableEditPanel"), "CURSOR");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, 2005, new DynamicPopupCellEditorFactory("oracle.dbtools.raptor.controls.celleditor.popups.LongCharEditPanel"), "CLOB");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, 2011, new DynamicPopupCellEditorFactory("oracle.dbtools.raptor.controls.celleditor.popups.LongCharEditPanel"), "NCLOB");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, -1, new DynamicPopupCellEditorFactory("oracle.dbtools.raptor.controls.celleditor.popups.LongCharEditPanel"), "LONG");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, 2004, new DynamicPopupCellEditorFactory("oracle.dbtools.raptor.controls.celleditor.popups.BLOBEditPanel"), "BLOB");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, 2002, new DynamicPopupCellEditorFactory("oracle.dbtools.raptor.controls.celleditor.popups.LongCharEditPanel"), "STRUCT");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, -104, new DynamicPopupCellEditorFactory("oracle.dbtools.raptor.controls.celleditor.popups.OracleINTERVALDSEditPanel"), "INTERVALDS");
        PopupCellEditorFactory.registerPopupEditor(ORACLE_DRIVER, -103, new DynamicPopupCellEditorFactory("oracle.dbtools.raptor.controls.celleditor.popups.OracleINTERVALYMEditPanel"), "INTERVALYM");
    }

    public static interface LazyPopupCellEditorFactory {
        public PopupCellEditor getCellEditorInstance();
    }

    protected static class DynamicPopupCellEditorFactory
    implements LazyPopupCellEditorFactory {
        protected final String className;
        protected final ClassLoader classLoader;
        protected PopupCellEditor cellEditor;

        public DynamicPopupCellEditorFactory(String string, ClassLoader classLoader) {
            this.className = string;
            this.classLoader = classLoader;
            this.cellEditor = null;
        }

        public DynamicPopupCellEditorFactory(String string) {
            this(string, LazyPopupCellEditorFactory.class.getClassLoader());
        }

        public DynamicPopupCellEditorFactory(PopupCellEditor popupCellEditor) {
            this(popupCellEditor, null);
        }

        public DynamicPopupCellEditorFactory(PopupCellEditor popupCellEditor, ClassLoader classLoader) {
            this.className = null;
            this.classLoader = classLoader;
            this.cellEditor = popupCellEditor;
        }

        @Override
        public PopupCellEditor getCellEditorInstance() {
            if (this.cellEditor == null) {
                try {
                    Class<?> clazz = this.classLoader.loadClass(this.className);
                    this.cellEditor = (PopupCellEditor)clazz.newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.cellEditor;
        }
    }

    public static final class RegistrationIdImpl
    implements RegistrationId,
    Cloneable,
    Comparable<RegistrationIdImpl> {
        private Integer typeId;
        private String typeName;

        protected RegistrationIdImpl(Integer n, String string) {
            this.typeId = n;
            this.typeName = string;
        }

        protected RegistrationIdImpl(Integer n) {
            this(n, null);
        }

        protected Integer getTypeId() {
            return this.typeId;
        }

        protected String getTypeName() {
            return this.typeName;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            RegistrationIdImpl registrationIdImpl = (RegistrationIdImpl)object;
            return DataTypesUtil.areEqual((Object)this.typeId, (Object)registrationIdImpl.typeId);
        }

        public int hashCode() {
            int n = 7;
            n = n * 31 + (this.typeId != null ? this.typeId.hashCode() : 0);
            return n;
        }

        @Override
        public int compareTo(RegistrationIdImpl registrationIdImpl) {
            int n = 0;
            if (this != registrationIdImpl) {
                n = this.typeId == null && registrationIdImpl.typeId != null ? -1 : (this.typeId != null && registrationIdImpl.typeId == null ? 1 : this.typeId.compareTo(registrationIdImpl.typeId));
            }
            return n;
        }

        public Object clone() {
            try {
                RegistrationIdImpl registrationIdImpl = (RegistrationIdImpl)super.clone();
                registrationIdImpl.typeId = this.typeId;
                return registrationIdImpl;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }
    }

    public static interface RegistrationId {
    }
}

