/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.celleditor.popups;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.celleditor.popups.AbstractPopupCellEditor;
import oracle.dbtools.raptor.controls.grid.ColumnAutoSizer;
import oracle.dbtools.raptor.extendedtype.ExtendedType;
import oracle.dbtools.raptor.extendedtype.GenericBlobType;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.net.URLFactory;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.HyperlinkButton;
import oracle.javatools.ui.Header;
import oracle.javatools.ui.HeaderPanel;

public abstract class ExtendedTypeEditPanel
extends AbstractPopupCellEditor {
    protected ExtendedType extendedType;
    protected URL saveToURL = null;
    protected static URL _lastSaveUrl;
    protected HeaderPanel<JPanel> savedInfoHeaderPanel;
    protected HeaderPanel<JPanel> localInfoHeaderPanel;
    protected JTable savedDataTable;
    protected JTable localDataTable;
    protected String[] columnNames = new String[]{Messages.getString("ExtendedTypeEditPanel.0"), Messages.getString("ExtendedTypeEditPanel.1")};
    protected HyperlinkButton loadButton = new HyperlinkButton();
    protected HyperlinkButton saveButton = new HyperlinkButton();
    protected HyperlinkButton setNullButton = new HyperlinkButton();
    protected HyperlinkButton extEditorButton = new HyperlinkButton();
    protected HyperlinkButton editorButton = new HyperlinkButton();
    protected JPanel buttonPanel = new JPanel(new GridBagLayout());
    protected JLabel savedDataImageLabel = new JLabel();
    protected JTextArea savedDataTextArea = new JTextArea();
    protected JLabel localDataImageLabel = new JLabel();
    protected JTextArea localDataTextArea = new JTextArea();
    protected JCheckBox savedViewAsImageBtn = new JCheckBox();
    protected JCheckBox savedViewAsTextBtn = new JCheckBox();
    protected JCheckBox localViewAsImageBtn = new JCheckBox();
    protected JCheckBox localViewAsTextBtn = new JCheckBox();
    protected JScrollPane savedImageScrollPane = new JScrollPane(this.savedDataImageLabel);
    protected JScrollPane savedTextScrollPane = new JScrollPane(this.savedDataTextArea);
    protected JScrollPane localImageScrollPane = new JScrollPane(this.localDataImageLabel);
    protected JScrollPane localTextScrollPane = new JScrollPane(this.localDataTextArea);
    protected JTabbedPane tabbedPane;
    protected JPanel infoPanel;
    protected boolean savedShowImage = false;
    protected boolean savedShowText = false;
    protected boolean localShowImage = false;
    protected boolean localShowText = false;
    protected WeakReference<RaptorTask> savedShowImageTask = new WeakReference<Object>(null);
    protected WeakReference<RaptorTask> savedShowTextTask = new WeakReference<Object>(null);
    protected WeakReference<RaptorTask> localShowImageTask = new WeakReference<Object>(null);
    protected WeakReference<RaptorTask> localShowTextTask = new WeakReference<Object>(null);
    protected WeakReference<RaptorTask> saveToDiskTask = new WeakReference<Object>(null);
    protected Connection conn = null;
    protected boolean editable = false;
    protected JEWTDialog _dialog = null;
    private boolean _isEdited;

    public ExtendedTypeEditPanel(ExtendedType extendedType) {
        this.extendedType = extendedType;
        this.createGUI();
    }

    protected abstract void createGUI();

    protected void createDefaultGUI() {
        this.setLayout(new GridBagLayout());
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.infoPanel = new JPanel(new GridBagLayout());
        this.infoPanel.setPreferredSize(new Dimension(400, 300));
        this.infoPanel.add((Component)this.getSavedInfoPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.infoPanel.add((Component)this.getLocalInfoPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.tabbedPane.addTab(Messages.getString("ExtendedTypeEditPanel.4"), this.infoPanel);
        this.setupImageLabel(this.savedDataImageLabel, this.savedImageScrollPane);
        this.setupImageLabel(this.localDataImageLabel, this.localImageScrollPane);
        this.setupTextArea(this.localDataTextArea, this.localTextScrollPane);
        this.setupTextArea(this.savedDataTextArea, this.savedTextScrollPane);
        this.add((Component)this.tabbedPane, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected void setupImageLabel(JLabel jLabel, JScrollPane jScrollPane) {
        jLabel.setVerticalAlignment(1);
        jScrollPane.setPreferredSize(new Dimension(400, 300));
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setViewportBorder(null);
        jScrollPane.getViewport().setBackground(Color.white);
    }

    protected void setupTextArea(JTextArea jTextArea, JScrollPane jScrollPane) {
        jTextArea.setEditable(false);
        jScrollPane.setPreferredSize(new Dimension(400, 300));
        jScrollPane.setHorizontalScrollBarPolicy(32);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setViewportBorder(null);
        jScrollPane.getViewport().setBackground(Color.white);
    }

    protected JPanel getSavedInfoPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.savedInfoHeaderPanel = new HeaderPanel((JComponent)jPanel);
        this.savedViewAsImageBtn = new JCheckBox();
        this.savedViewAsTextBtn = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.savedViewAsImageBtn, (String)Messages.getString("ExtendedTypeEditPanel.2"));
        ResourceUtils.resButton((AbstractButton)this.savedViewAsTextBtn, (String)Messages.getString("ExtendedTypeEditPanel.3"));
        this.savedViewAsImageBtn.setSelected(this.localShowImage);
        this.savedViewAsImageBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (ExtendedTypeEditPanel.this.savedViewAsImageBtn.isSelected()) {
                        ExtendedTypeEditPanel.this.tabbedPane.addTab(Messages.getString("ExtendedTypeEditPanel.7"), ExtendedTypeEditPanel.this.savedImageScrollPane);
                        ExtendedTypeEditPanel.this.showAsImage(ExtendedTypeEditPanel.this.extendedType, true);
                        ExtendedTypeEditPanel.this.savedShowImage = true;
                        ExtendedTypeEditPanel.this.tabbedPane.setSelectedComponent(ExtendedTypeEditPanel.this.savedImageScrollPane);
                    } else {
                        ExtendedTypeEditPanel.this.tabbedPane.remove(ExtendedTypeEditPanel.this.savedImageScrollPane);
                        ExtendedTypeEditPanel.this.showAsImage(null, true);
                        ExtendedTypeEditPanel.this.savedShowImage = false;
                    }
                }
                catch (Exception exception) {
                    ExtendedTypeEditPanel.this.showAsImage(null, true);
                }
            }
        });
        this.savedViewAsTextBtn.setSelected(this.savedShowText);
        this.savedViewAsTextBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (ExtendedTypeEditPanel.this.savedViewAsTextBtn.isSelected()) {
                        ExtendedTypeEditPanel.this.tabbedPane.addTab(Messages.getString("ExtendedTypeEditPanel.9"), ExtendedTypeEditPanel.this.savedTextScrollPane);
                        ExtendedTypeEditPanel.this.showAsText(ExtendedTypeEditPanel.this.extendedType, true);
                        ExtendedTypeEditPanel.this.savedShowText = true;
                        ExtendedTypeEditPanel.this.tabbedPane.setSelectedComponent(ExtendedTypeEditPanel.this.savedTextScrollPane);
                    } else {
                        ExtendedTypeEditPanel.this.tabbedPane.remove(ExtendedTypeEditPanel.this.savedTextScrollPane);
                        ExtendedTypeEditPanel.this.showAsText(null, true);
                        ExtendedTypeEditPanel.this.savedShowText = false;
                    }
                }
                catch (Exception exception) {
                    ExtendedTypeEditPanel.this.showAsText(null, true);
                }
            }
        });
        Header header = this.savedInfoHeaderPanel.getHeader();
        header.setText(Messages.getString("ExtendedTypeEditPanel.25"));
        header.setLevel(Header.Level.SUB);
        header.setExpanded(true);
        this.addSavedInfoHeaderComps();
        jPanel.add((Component)this.createTable(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        return this.savedInfoHeaderPanel;
    }

    protected void addSavedInfoHeaderComps() {
        Header header = this.savedInfoHeaderPanel.getHeader();
        header.addActionControl((Component)this.getSaveButton());
        header.addActionControl((Component)new JLabel(Messages.getString("ExtendedTypeEditPanel.8")));
        header.addActionControl((Component)this.savedViewAsImageBtn);
        header.addActionControl((Component)this.savedViewAsTextBtn);
    }

    protected JPanel getLocalInfoPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.localInfoHeaderPanel = new HeaderPanel((JComponent)jPanel, true);
        this.localDataTable = new JTable(this.getLocalDataTableData(), this.columnNames){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        ColumnAutoSizer.autoResizeTable((JTable)this.localDataTable, (String)ColumnAutoSizer.AUTO_FIT_ON_DATA);
        this.localDataTable.setCellSelectionEnabled(true);
        this.localDataTable.setBackground(this.getBackground());
        this.localDataTable.setTableHeader(new JTableHeader());
        this.localViewAsImageBtn = new JCheckBox();
        this.localViewAsTextBtn = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.localViewAsImageBtn, (String)Messages.getString("ExtendedTypeEditPanel.2"));
        ResourceUtils.resButton((AbstractButton)this.localViewAsTextBtn, (String)Messages.getString("ExtendedTypeEditPanel.3"));
        this.localViewAsImageBtn.setSelected(this.localShowImage);
        this.localViewAsImageBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (ExtendedTypeEditPanel.this.localViewAsImageBtn.isSelected()) {
                        ExtendedTypeEditPanel.this.tabbedPane.addTab(Messages.getString("ExtendedTypeEditPanel.28"), ExtendedTypeEditPanel.this.localImageScrollPane);
                        ExtendedTypeEditPanel.this.showAsImage(ExtendedTypeEditPanel.this.extendedType, false);
                        ExtendedTypeEditPanel.this.localShowImage = true;
                        ExtendedTypeEditPanel.this.tabbedPane.setSelectedComponent(ExtendedTypeEditPanel.this.localImageScrollPane);
                    } else {
                        ExtendedTypeEditPanel.this.tabbedPane.remove(ExtendedTypeEditPanel.this.localImageScrollPane);
                        ExtendedTypeEditPanel.this.showAsImage(null, false);
                        ExtendedTypeEditPanel.this.localShowImage = false;
                    }
                }
                catch (Exception exception) {
                    ExtendedTypeEditPanel.this.showAsImage(null, false);
                }
            }
        });
        this.localViewAsTextBtn.setSelected(this.localShowText);
        this.localViewAsTextBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (ExtendedTypeEditPanel.this.localViewAsTextBtn.isSelected()) {
                        ExtendedTypeEditPanel.this.tabbedPane.addTab(Messages.getString("ExtendedTypeEditPanel.29"), ExtendedTypeEditPanel.this.localTextScrollPane);
                        ExtendedTypeEditPanel.this.showAsText(ExtendedTypeEditPanel.this.extendedType, false);
                        ExtendedTypeEditPanel.this.localShowText = true;
                        ExtendedTypeEditPanel.this.tabbedPane.setSelectedComponent(ExtendedTypeEditPanel.this.localTextScrollPane);
                    } else {
                        ExtendedTypeEditPanel.this.tabbedPane.remove(ExtendedTypeEditPanel.this.localTextScrollPane);
                        ExtendedTypeEditPanel.this.showAsText(null, false);
                        ExtendedTypeEditPanel.this.localShowText = false;
                    }
                }
                catch (Exception exception) {
                    ExtendedTypeEditPanel.this.showAsText(null, false);
                }
            }
        });
        Header header = this.localInfoHeaderPanel.getHeader();
        header.setText(Messages.getString("ExtendedTypeEditPanel.30"));
        header.setLevel(Header.Level.SUB);
        header.setExpanded(true);
        this.addLocalInfoHeaderComps();
        jPanel.add((Component)this.localDataTable, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        return this.localInfoHeaderPanel;
    }

    protected void addLocalInfoHeaderComps() {
        Header header = this.localInfoHeaderPanel.getHeader();
        header.addActionControl((Component)this.getLoadButton());
        header.addActionControl((Component)this.getSetNullButton());
        header.addActionControl((Component)new JLabel(Messages.getString("ExtendedTypeEditPanel.8")));
        header.addActionControl((Component)this.localViewAsImageBtn);
        header.addActionControl((Component)this.localViewAsTextBtn);
    }

    protected String[][] getLocalDataTableData() {
        String string = "";
        Object object = "";
        if (this.extendedType != null && this.extendedType.getLoadFromURL() != null) {
            URL uRL = this.extendedType.getLoadFromURL();
            string = uRL.getPath();
            object = "" + new File(string).length();
        }
        return new String[][]{{Messages.getString("ExtendedTypeEditPanel.31"), string}, {Messages.getString("ExtendedTypeEditPanel.32"), object}};
    }

    protected JTable createTable() {
        Object[][] objectArray = this.getTableData();
        this.savedDataTable = new JTable(objectArray, this.columnNames){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.savedDataTable.setBackground(this.getBackground());
        this.savedDataTable.setRowHeight(20);
        this.savedDataTable.setCellSelectionEnabled(true);
        this.savedDataTable.setTableHeader(new JTableHeader());
        return this.savedDataTable;
    }

    public void setJTable(JTable jTable) {
        this.savedDataTable = jTable;
    }

    public JTable getJTable() {
        return this.savedDataTable;
    }

    protected abstract String[][] getTableData();

    public abstract boolean processExtendedType();

    protected abstract void load();

    protected HyperlinkButton getLoadButton() {
        ResourceUtils.resButton((AbstractButton)this.loadButton, (String)Messages.getString("ExtendedTypeEditPanel.10"));
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtendedTypeEditPanel.this.load();
            }
        });
        return this.loadButton;
    }

    protected HyperlinkButton resetSaveButton() {
        ResourceUtils.resButton((AbstractButton)this.saveButton, (String)Messages.getString("ExtendedTypeEditPanel.11"));
        this.saveButton.setCursor(Cursor.getPredefinedCursor(0));
        return this.saveButton;
    }

    protected HyperlinkButton getSaveButton() {
        ResourceUtils.resButton((AbstractButton)this.saveButton, (String)Messages.getString("ExtendedTypeEditPanel.11"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtendedTypeEditPanel.this.save();
            }
        });
        return this.saveButton;
    }

    protected HyperlinkButton getSetNullButton() {
        ResourceUtils.resButton((AbstractButton)this.setNullButton, (String)Messages.getString("ExtendedTypeEditPanel.24"));
        this.setNullButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtendedTypeEditPanel.this.setNull();
                ExtendedTypeEditPanel.this._dialog.closeDialog(false);
            }
        });
        return this.setNullButton;
    }

    protected void save() {
        if (this.saveToDiskTask.get() == null) {
            URLFileChooser uRLFileChooser = new URLFileChooser();
            uRLFileChooser.setDefaultTitle(Messages.getString("ExtendedTypeEditPanel.12"));
            uRLFileChooser.setSelectionMode(0);
            uRLFileChooser.setSelectionScope(0);
            uRLFileChooser.clearChooseableURLFilters();
            if (_lastSaveUrl == null) {
                String string = System.getProperty("user.home");
                File file = new File(string);
                uRLFileChooser.setSelectedURL(URLFactory.newFileURL((File)file));
            } else {
                uRLFileChooser.setSelectedURL(_lastSaveUrl);
            }
            if (uRLFileChooser.showSaveDialog(this) == 0) {
                this.saveToURL = uRLFileChooser.getSelectedURL();
                _lastSaveUrl = uRLFileChooser.getSelectedURL();
                this.saveToDiskRequest(this.getSaveToURL());
            }
        } else {
            this.saveToDiskRequest(null);
        }
    }

    public String getFileName() {
        String string = "";
        for (int i = 0; i < this.getJTable().getColumnCount(); ++i) {
            String string2 = this.getJTable().getColumnName(i);
            if (!string2.equalsIgnoreCase("file_name") && !string2.equalsIgnoreCase("file name")) continue;
            string = this.getJTable().getValueAt(this.getJTable().getSelectedRow(), i).toString();
        }
        return string;
    }

    public URL getSaveToURL() {
        return this.saveToURL;
    }

    protected void showAsImage(ExtendedType extendedType, boolean bl) {
        this.savedDataImageLabel.setIcon(null);
        this.savedDataImageLabel.setText(null);
        if (extendedType == null) {
            if (bl) {
                this.cancelReferencedTask(this.savedShowImageTask);
            } else {
                this.cancelReferencedTask(this.localShowImageTask);
            }
            return;
        }
        try {
            ShowImageTask showImageTask = new ShowImageTask(Messages.getString("ExtendedTypeEditPanel.22"), true, IRaptorTaskRunMode.TASKVIEWER, extendedType, bl);
            showImageTask.getDescriptor().addListener((IRaptorTaskListener)new ShowImageTaskListener(showImageTask));
            RaptorTaskManager.getInstance().addTask((RaptorTask)showImageTask);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
        }
    }

    protected boolean cancelReferencedTask(WeakReference<RaptorTask> weakReference) {
        return this.cancelReferencedTask(weakReference, true);
    }

    protected boolean cancelReferencedTask(WeakReference<RaptorTask> weakReference, boolean bl) {
        boolean bl2 = true;
        if (weakReference != null) {
            try {
                RaptorTask raptorTask = (RaptorTask)weakReference.get();
                if (raptorTask != null) {
                    if (bl) {
                        weakReference.clear();
                    }
                    bl2 = RaptorTaskManager.getInstance().cancelTask(raptorTask);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl2;
    }

    private boolean skipOLEHeader(InputStream inputStream) {
        String string = "Bitmap Image";
        String string2 = "Paint.Picture";
        byte[] byArray = new byte[512];
        try {
            int n;
            int n2 = inputStream.read(byArray);
            if (n2 == -1 || n2 < 46) {
                return false;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (n = 20; n < 20 + string.length(); ++n) {
                stringBuffer.append((char)byArray[n]);
            }
            if (!stringBuffer.toString().equals(string)) {
                return false;
            }
            stringBuffer = new StringBuffer();
            for (n = 33; n < 33 + string2.length(); ++n) {
                stringBuffer.append((char)byArray[n]);
            }
            if (!stringBuffer.toString().equals(string2)) {
                return false;
            }
            boolean bl = false;
            for (n = 33 + string2.length(); n < n2; ++n) {
                if (byArray[n] != 66 || byArray[n + 1] != 77) continue;
                bl = true;
                break;
            }
            if (bl) {
                inputStream.reset();
                inputStream.skip(n);
                return true;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            return false;
        }
        return false;
    }

    protected void showAsText(ExtendedType extendedType, boolean bl) {
        if (extendedType == null) {
            if (bl) {
                this.cancelReferencedTask(this.savedShowTextTask);
            } else {
                this.cancelReferencedTask(this.localShowTextTask);
            }
            return;
        }
        try {
            if (bl) {
                this.savedDataTextArea.setText("");
            } else {
                this.localDataTextArea.setText("");
            }
            ShowTextTask showTextTask = new ShowTextTask(Messages.getString("ExtendedTypeEditPanel.23"), true, IRaptorTaskRunMode.TASKVIEWER, extendedType, bl);
            showTextTask.getDescriptor().addListener((IRaptorTaskListener)new ShowTextTaskListener(showTextTask));
            RaptorTaskManager.getInstance().addTask((RaptorTask)showTextTask);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    protected void setNull() {
        this.extendedType.setNULL(true);
    }

    private void saveToDiskRequest(URL uRL) {
        if (uRL == null) {
            this.cancelReferencedTask(this.saveToDiskTask, false);
        } else {
            SaveToDiskTask saveToDiskTask = new SaveToDiskTask(MessageFormat.format(Messages.getString("ExtendedTypeEditPanel.35"), uRL.toExternalForm()), IRaptorTaskRunMode.TASKVIEWER, this.extendedType, uRL);
            saveToDiskTask.getDescriptor().addListener((IRaptorTaskListener)new SaveToDiskListener());
            this.saveToDiskTask = new WeakReference<SaveToDiskTask>(saveToDiskTask);
            RaptorTaskManager.getInstance().addTask((RaptorTask)saveToDiskTask);
            ResourceUtils.resButton((AbstractButton)this.saveButton, (String)Messages.getString("ExtendedTypeEditPanel.34"));
            this.saveButton.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean saveToDisk(URL uRL, RaptorTaskDescriptor raptorTaskDescriptor) {
        FileOutputStream fileOutputStream = null;
        if (uRL != null) {
            try {
                fileOutputStream = new FileOutputStream(uRL.getFile());
                this.extendedType.setToDiskStream((OutputStream)fileOutputStream);
                this.extendedType.setToDiskTaskDescriptor(raptorTaskDescriptor);
                boolean bl = this.extendedType.saveToDisk(null, null, null, null, false);
                return bl;
            }
            catch (Exception exception) {
                ExceptionHandler.handleException((Throwable)exception);
            }
            finally {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
                this.extendedType.setToDiskTaskDescriptor(null);
            }
        }
        return false;
    }

    protected void reload() {
        this.savedDataTable.setModel(new DefaultTableModel(this.getTableData(), this.columnNames));
        this.localDataTable.setModel(new DefaultTableModel(this.getLocalDataTableData(), this.columnNames));
        ColumnAutoSizer.autoResizeTable((JTable)this.savedDataTable, (String)ColumnAutoSizer.AUTO_FIT_ON_DATA);
        ColumnAutoSizer.autoResizeTable((JTable)this.localDataTable, (String)ColumnAutoSizer.AUTO_FIT_ON_DATA);
        this.tabbedPane.remove(this.localTextScrollPane);
        this.tabbedPane.remove(this.localImageScrollPane);
        this.tabbedPane.remove(this.savedTextScrollPane);
        this.tabbedPane.remove(this.savedImageScrollPane);
        this.savedViewAsImageBtn.setSelected(false);
        this.savedViewAsTextBtn.setSelected(false);
        this.localViewAsImageBtn.setSelected(false);
        this.localViewAsTextBtn.setSelected(false);
        this.repaint();
    }

    @Override
    public void dismissPopupEditor() {
        this.cancelReferencedTask(this.saveToDiskTask);
        this.cancelReferencedTask(this.savedShowImageTask);
        this.cancelReferencedTask(this.localShowImageTask);
        this.cancelReferencedTask(this.savedShowTextTask);
        this.cancelReferencedTask(this.localShowTextTask);
        this.savedDataTextArea.setText("");
        this.savedDataImageLabel.setIcon(null);
        this.localDataTextArea.setText("");
        this.localDataImageLabel.setIcon(null);
        this.resetSaveButton();
        super.dismissPopupEditor();
    }

    @Override
    public void setEditable(boolean bl) {
        this.editable = bl;
        this.loadButton.setEnabled(bl);
        this.setNullButton.setEnabled(bl);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public JComponent getDefaultComponent() {
        return this;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public boolean isNULL() {
        return false;
    }

    @Override
    public void setConnection(Connection connection) {
        this.conn = connection;
    }

    @Override
    public String validateValue() {
        return null;
    }

    protected boolean isFileEdited() {
        return this._isEdited;
    }

    protected void setFileEdited(boolean bl) {
        this._isEdited = bl;
    }

    @Override
    public void setPopupDialog(JEWTDialog jEWTDialog) {
        this._dialog = jEWTDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImageIcon readImage(ShowImageTask showImageTask) throws Exception {
        InputStream inputStream = showImageTask.getInputStream();
        BufferedImage bufferedImage = null;
        ImageIcon imageIcon = null;
        if (inputStream != null) {
            try {
                block23: {
                    inputStream.mark(Integer.MAX_VALUE);
                    bufferedImage = ImageIO.read(inputStream);
                    if (bufferedImage != null) {
                        ImageIcon imageIcon2 = new ImageIcon(bufferedImage);
                        return imageIcon2;
                    }
                    if (inputStream.markSupported()) break block23;
                    ImageIcon imageIcon3 = null;
                    return imageIcon3;
                }
                inputStream.reset();
                if (this.skipOLEHeader(inputStream)) {
                    bufferedImage = ImageIO.read(inputStream);
                }
                if (bufferedImage != null) {
                    ImageIcon imageIcon4 = new ImageIcon(bufferedImage);
                    return imageIcon4;
                }
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, iOException.getStackTrace()[0].toString(), iOException);
                }
            }
        }
        if (imageIcon == null) {
            throw new Exception(Messages.getString("ExtendedTypeEditPanel.20"));
        }
        return imageIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readText(ShowTextTask showTextTask) throws Exception {
        String string = null;
        Reader reader = showTextTask.getReader();
        if (reader != null) {
            StringBuilder stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            try {
                if (bufferedReader != null) {
                    String string2;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        stringBuilder.append(string2 + "\n");
                    }
                }
                string = stringBuilder.toString();
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, iOException.getStackTrace()[0].toString(), iOException);
                }
            }
        }
        return string;
    }

    protected boolean openResource(ShowTask showTask) throws Exception {
        return false;
    }

    protected void closeResource(ShowTask showTask) throws Exception {
    }

    private class ShowImageTask
    extends ShowTaskImpl<ImageIcon> {
        protected InputStream _in;

        public ShowImageTask(String string, boolean bl, IRaptorTaskRunMode iRaptorTaskRunMode, ExtendedType extendedType, boolean bl2) throws Exception {
            super(string, bl, iRaptorTaskRunMode, extendedType, bl2);
            this._in = this._exType.getBinaryStream(Boolean.valueOf(this._savedData));
        }

        public InputStream getInputStream() {
            return this._in;
        }

        protected ImageIcon doWork() throws TaskException {
            ImageIcon imageIcon = null;
            try {
                ExtendedTypeEditPanel.this.openResource(this);
                imageIcon = ExtendedTypeEditPanel.this.readImage(this);
            }
            catch (Exception exception) {
                if (exception instanceof TaskException) {
                    throw (TaskException)exception;
                }
                throw new TaskException((Throwable)exception);
            }
            finally {
                try {
                    ExtendedTypeEditPanel.this.closeResource(this);
                }
                catch (Exception exception) {}
            }
            return imageIcon;
        }

        public boolean cancel() {
            try {
                if (this._in != null) {
                    this._in.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ExtendedTypeEditPanel.this.closeResource(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return super.cancel();
        }
    }

    private class ShowImageTaskListener
    extends RaptorTaskAdapter {
        private ShowImageTask _task;

        ShowImageTaskListener(ShowImageTask showImageTask) {
            this._task = showImageTask;
        }

        /*
         * Loose catch block
         */
        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            try {
                final ImageIcon imageIcon = (ImageIcon)this._task.getResult();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ShowImageTaskListener.this._task.isSavedData()) {
                            ExtendedTypeEditPanel.this.savedDataImageLabel.setIcon(imageIcon);
                            ExtendedTypeEditPanel.this.savedDataImageLabel.setText(null);
                        } else {
                            ExtendedTypeEditPanel.this.localDataImageLabel.setIcon(imageIcon);
                            ExtendedTypeEditPanel.this.localDataImageLabel.setText(null);
                        }
                    }
                });
                this.cleanup();
            }
            catch (InterruptedException interruptedException) {
                this.showError(interruptedException);
                this.cleanup();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ShowImageTaskListener.this._task.isSavedData()) {
                            ExtendedTypeEditPanel.this.savedDataImageLabel.setCursor(Cursor.getDefaultCursor());
                        } else {
                            ExtendedTypeEditPanel.this.localDataImageLabel.setCursor(Cursor.getDefaultCursor());
                        }
                    }
                });
            }
            catch (ExecutionException executionException) {
                this.showError(executionException);
                this.cleanup();
                {
                    catch (Throwable throwable) {
                        this.cleanup();
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            this.showError(raptorTaskEvent);
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            this.showError(raptorTaskEvent);
        }

        private void showError(RaptorTaskEvent raptorTaskEvent) {
            this.showError(raptorTaskEvent.getThrowable());
        }

        private void showError(Throwable throwable) {
            this.showError(RaptorTaskUtils.getErrorMessage((Throwable)throwable));
        }

        private void showError(final String string) {
            this.cleanup();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ShowImageTaskListener.this._task.isSavedData()) {
                        ExtendedTypeEditPanel.this.savedDataImageLabel.setIcon(null);
                        ExtendedTypeEditPanel.this.savedDataImageLabel.setText(string);
                        ExtendedTypeEditPanel.this.savedDataImageLabel.setCursor(Cursor.getDefaultCursor());
                    } else {
                        ExtendedTypeEditPanel.this.localDataImageLabel.setIcon(null);
                        ExtendedTypeEditPanel.this.localDataImageLabel.setText(string);
                        ExtendedTypeEditPanel.this.localDataImageLabel.setCursor(Cursor.getDefaultCursor());
                    }
                }
            });
        }

        public void taskScheduled(RaptorTaskEvent raptorTaskEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ShowImageTaskListener.this._task.isSavedData()) {
                        ExtendedTypeEditPanel.this.savedShowImageTask = new WeakReference<ShowImageTask>(ShowImageTaskListener.this._task);
                        ExtendedTypeEditPanel.this.savedDataImageLabel.setCursor(Cursor.getPredefinedCursor(3));
                    } else {
                        ExtendedTypeEditPanel.this.localShowImageTask = new WeakReference<ShowImageTask>(ShowImageTaskListener.this._task);
                        ExtendedTypeEditPanel.this.localDataImageLabel.setCursor(Cursor.getPredefinedCursor(3));
                    }
                }
            });
        }

        protected void cleanup() {
            if (this._task.isSavedData()) {
                ExtendedTypeEditPanel.this.savedShowImageTask.clear();
            } else {
                ExtendedTypeEditPanel.this.localShowImageTask.clear();
            }
        }
    }

    private class ShowTextTask
    extends ShowTaskImpl<String> {
        protected Reader _reader;

        public ShowTextTask(String string, boolean bl, IRaptorTaskRunMode iRaptorTaskRunMode, ExtendedType extendedType, boolean bl2) throws Exception {
            super(string, bl, iRaptorTaskRunMode, extendedType, bl2);
            this._reader = this._exType.getReader(Boolean.valueOf(this._savedData), IdeUtil.getIdeEncoding());
        }

        public Reader getReader() {
            return this._reader;
        }

        protected String doWork() throws TaskException {
            String string = null;
            try {
                ExtendedTypeEditPanel.this.openResource(this);
                string = ExtendedTypeEditPanel.this.readText(this);
            }
            catch (Exception exception) {
                if (exception instanceof TaskException) {
                    throw (TaskException)exception;
                }
                throw new TaskException((Throwable)exception);
            }
            finally {
                try {
                    ExtendedTypeEditPanel.this.closeResource(this);
                }
                catch (Exception exception) {}
            }
            return string;
        }

        public boolean cancel() {
            try {
                if (this._reader != null) {
                    this._reader.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ExtendedTypeEditPanel.this.closeResource(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return super.cancel();
        }
    }

    private class ShowTextTaskListener
    extends RaptorTaskAdapter {
        private ShowTextTask _task;

        ShowTextTaskListener(ShowTextTask showTextTask) {
            this._task = showTextTask;
        }

        /*
         * Loose catch block
         */
        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            try {
                String string = (String)this._task.getResult();
                this.showText(string);
                this.cleanup();
            }
            catch (InterruptedException interruptedException) {
                this.showText(interruptedException);
                this.cleanup();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ShowTextTaskListener.this._task.isSavedData()) {
                            ExtendedTypeEditPanel.this.savedDataTextArea.setCursor(Cursor.getDefaultCursor());
                        } else {
                            ExtendedTypeEditPanel.this.localDataTextArea.setCursor(Cursor.getDefaultCursor());
                        }
                    }
                });
            }
            catch (ExecutionException executionException) {
                this.showText(executionException);
                this.cleanup();
                {
                    catch (Throwable throwable) {
                        this.cleanup();
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            this.showText(raptorTaskEvent.getThrowable());
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            this.showText(raptorTaskEvent.getThrowable());
        }

        private void showText(Throwable throwable) {
            this.showText(RaptorTaskUtils.getErrorMessage((Throwable)throwable));
        }

        private void showText(final String string) {
            this.cleanup();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ShowTextTaskListener.this._task.isSavedData()) {
                        ExtendedTypeEditPanel.this.savedDataTextArea.setText(string);
                        ExtendedTypeEditPanel.this.savedDataTextArea.setCursor(Cursor.getDefaultCursor());
                    } else {
                        ExtendedTypeEditPanel.this.localDataTextArea.setText(string);
                        ExtendedTypeEditPanel.this.localDataTextArea.setCursor(Cursor.getDefaultCursor());
                    }
                }
            });
        }

        public void taskScheduled(RaptorTaskEvent raptorTaskEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ShowTextTaskListener.this._task.isSavedData()) {
                        ExtendedTypeEditPanel.this.savedShowTextTask = new WeakReference<ShowTextTask>(ShowTextTaskListener.this._task);
                        ExtendedTypeEditPanel.this.savedDataTextArea.setCursor(Cursor.getPredefinedCursor(3));
                    } else {
                        ExtendedTypeEditPanel.this.localShowTextTask = new WeakReference<ShowTextTask>(ShowTextTaskListener.this._task);
                        ExtendedTypeEditPanel.this.localDataTextArea.setCursor(Cursor.getPredefinedCursor(3));
                    }
                }
            });
        }

        protected void cleanup() {
            if (this._task.isSavedData()) {
                ExtendedTypeEditPanel.this.savedShowTextTask.clear();
            } else {
                ExtendedTypeEditPanel.this.localShowTextTask.clear();
            }
        }
    }

    protected class SaveToDiskTask
    extends RaptorTask<Boolean> {
        final ExtendedType extendedType;
        final URL url;

        protected SaveToDiskTask(String string, IRaptorTaskRunMode iRaptorTaskRunMode, ExtendedType extendedType, URL uRL) {
            super(string, extendedType.isToDiskInDeterministic(), iRaptorTaskRunMode);
            this.extendedType = extendedType;
            this.url = uRL;
        }

        protected Boolean doWork() throws TaskException {
            return ExtendedTypeEditPanel.this.saveToDisk(this.url, this.getDescriptor());
        }

        public boolean cancel() {
            if (this.extendedType instanceof GenericBlobType) {
                this.extendedType.setToDiskStream(null);
            }
            return super.cancel();
        }
    }

    private class SaveToDiskListener
    extends RaptorTaskAdapter {
        private SaveToDiskListener() {
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            this.cleanup();
            super.taskCancelled(raptorTaskEvent);
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            this.cleanup();
            super.taskFailed(raptorTaskEvent);
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            this.cleanup();
            super.taskFinished(raptorTaskEvent);
        }

        public void taskRunning(RaptorTaskEvent raptorTaskEvent) {
            super.taskRunning(raptorTaskEvent);
        }

        public void taskScheduled(RaptorTaskEvent raptorTaskEvent) {
            super.taskScheduled(raptorTaskEvent);
        }

        protected void cleanup() {
            ExtendedTypeEditPanel.this.saveToDiskTask.clear();
            SwingUtilities.invokeLater(() -> ExtendedTypeEditPanel.this.resetSaveButton());
        }
    }

    private abstract class ShowTaskImpl<V>
    extends RaptorTask<V>
    implements ShowTask<V> {
        protected final ExtendedType _exType;
        protected final boolean _savedData;
        protected String _failureReason;

        public ShowTaskImpl(String string, boolean bl, IRaptorTaskRunMode iRaptorTaskRunMode, ExtendedType extendedType, boolean bl2) throws Exception {
            super(string, bl, iRaptorTaskRunMode);
            this._savedData = bl2;
            this._exType = extendedType;
            this._failureReason = null;
        }

        @Override
        public boolean isSavedData() {
            return this._savedData;
        }

        @Override
        public ExtendedType getExtendedType() {
            return this._exType;
        }

        @Override
        public String getFailureReason() {
            return this._failureReason;
        }
    }

    protected static interface ShowTask<V> {
        public boolean isSavedData();

        public ExtendedType getExtendedType();

        public String getFailureReason();
    }
}

