/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.raptor.config.CustomFormat;
import oracle.dbtools.raptor.controls.DatabaseElementTransferable;
import oracle.dbtools.raptor.controls.DefaultRaptorCodeEditorDnDHandler;
import oracle.dbtools.raptor.controls.RaptorCodeEditorDnDHandler;
import oracle.dbtools.raptor.controls.RaptorCodeEditorDnDProviderRegistry;
import oracle.dbtools.raptor.navigator.impl.ChildObjectElement;
import oracle.dbtools.raptor.navigator.impl.DatabaseElement;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.cmd.OpenCommand;
import oracle.ide.model.Displayable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.util.dnd.TransferableTreeNode;
import oracle.ide.util.dnd.TransferablesList;
import oracle.javatools.editor.plugins.DragDropPlugin;

public class RaptorDnDPlugin
extends DragDropPlugin {
    private DataFlavor[] _completeFlavors = null;
    private DataFlavor[] _supportedFlavors = new DataFlavor[]{TransferablesList.TRANSFERABLE_LIST_FLAVOR, TransferableTreeNode.TREE_NODE_FLAVOR, DataFlavor.javaFileListFlavor, DatabaseElementTransferable.FLAVOR};
    private JTextComponent _target;
    private String _worksheetConnectionName = null;

    public void setWorksheetConnection(String string) {
        this._worksheetConnectionName = string;
    }

    protected DataFlavor[] getSupportedFlavors() {
        if (this._completeFlavors == null) {
            int n;
            DataFlavor[] dataFlavorArray = super.getSupportedFlavors();
            ArrayList<DataFlavor> arrayList = new ArrayList<DataFlavor>();
            int n2 = dataFlavorArray.length;
            for (n = 0; n < n2; ++n) {
                arrayList.add(dataFlavorArray[n]);
            }
            n2 = this._supportedFlavors.length;
            for (n = 0; n < n2; ++n) {
                arrayList.add(this._supportedFlavors[n]);
            }
            this._completeFlavors = new DataFlavor[arrayList.size()];
            n = 0;
            for (DataFlavor dataFlavor : arrayList) {
                this._completeFlavors[n++] = dataFlavor;
            }
        }
        return this._completeFlavors;
    }

    protected void handleDragEvent(DropTargetDragEvent dropTargetDragEvent) {
        this.paintDropLocation(dropTargetDragEvent.getLocation());
        int n = dropTargetDragEvent.getDropAction();
        if (this.editor.isEditable() && this.isDropActionSupported(n) && this.isDataFlavorSupported(dropTargetDragEvent)) {
            dropTargetDragEvent.acceptDrag(n);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    private void fetchNodes(Transferable transferable, List<Displayable> list) throws IOException, UnsupportedFlavorException {
        if (transferable.isDataFlavorSupported(TransferablesList.TRANSFERABLE_LIST_FLAVOR)) {
            TransferablesList transferablesList = (TransferablesList)transferable.getTransferData(TransferablesList.TRANSFERABLE_LIST_FLAVOR);
            if (transferablesList != null) {
                for (Object e : transferablesList) {
                    this.fetchNodes((Transferable)e, list);
                }
            }
        } else if (transferable.isDataFlavorSupported(TransferableTreeNode.TREE_NODE_FLAVOR)) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)transferable.getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR);
            list.add((Displayable)defaultMutableTreeNode.getUserObject());
        } else if (transferable.isDataFlavorSupported(DatabaseElementTransferable.FLAVOR)) {
            DatabaseElement databaseElement = (DatabaseElement)transferable.getTransferData(DatabaseElementTransferable.FLAVOR);
            list.add((Displayable)databaseElement);
        }
    }

    protected void handleDropEvent(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        String string = null;
        if (!this.isDropActionSupported(dropTargetDropEvent.getDropAction())) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        this._target = (JTextComponent)dropTargetDropEvent.getDropTargetContext().getDropTarget().getComponent();
        Document document = null;
        int n = 0;
        if (this._target != null) {
            document = this._target.getDocument();
            n = this._target.viewToModel(dropTargetDropEvent.getLocation());
            this._target.setAutoscrolls(true);
        }
        try {
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                this.handleNativeFilesDrop(dropTargetDropEvent);
            } else {
                ArrayList<Displayable> arrayList = new ArrayList<Displayable>();
                this.fetchNodes(transferable, arrayList);
                if (arrayList.size() > 0) {
                    string = this.handleNodeDrop(dropTargetDropEvent, arrayList);
                    if (document != null && string != null) {
                        document.insertString(n, string, null);
                        this._target.setCaretPosition(n + string.length());
                    }
                } else {
                    super.handleDropEvent(dropTargetDropEvent);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void handleNativeFilesDrop(DropTargetDropEvent dropTargetDropEvent) throws Exception {
        dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
        Transferable transferable = dropTargetDropEvent.getTransferable();
        List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
        if (list != null) {
            for (File file : list) {
                this.openWorksheet(file);
            }
        }
    }

    private void openWorksheet(File file) throws Exception {
        URL uRL = URLFactory.newFileURL((File)file);
        Node node = NodeFactory.findOrCreate((URL)uRL);
        OpenCommand openCommand = new OpenCommand();
        openCommand.setContext(Context.newIdeContext((Node)node));
        openCommand.openURL(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String handleNodeDrop(DropTargetDropEvent dropTargetDropEvent, List<Displayable> list) {
        Displayable displayable = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        RaptorCodeEditorDnDHandler raptorCodeEditorDnDHandler = null;
        String string4 = null;
        if (list != null && list.size() > 0) {
            displayable = list.get(0);
            if (displayable instanceof DatabaseElement && !(displayable instanceof ObjectFolder)) {
                var9_9 = (DatabaseElement)displayable;
                string = (String)var9_9.getProperty("TYPE");
                string2 = (String)var9_9.getProperty("ConnectionType");
                string3 = (String)var9_9.getProperty("ConnectionName");
            } else if (displayable instanceof ChildObjectElement) {
                var9_9 = (ChildObjectElement)displayable;
                string = (String)var9_9.getProperty("TYPE");
                string2 = (String)var9_9.getProperty("ConnectionType");
                string3 = (String)var9_9.getProperty("ConnectionName");
                if (string3 == null) {
                    string3 = DBURLFormatHelper.getConnectionName(var9_9.getURL());
                }
            } else {
                string = "DEFAULT";
                string2 = "Oracle";
                string3 = this._worksheetConnectionName;
            }
            raptorCodeEditorDnDHandler = RaptorCodeEditorDnDProviderRegistry.getDnDProvider(string2, string);
            boolean bl = false;
            if (raptorCodeEditorDnDHandler != null) {
                raptorCodeEditorDnDHandler.setWorksheetConnectionName(this._worksheetConnectionName);
                try {
                    bl = Connections.getInstance().lock(string3, true);
                    if (bl) {
                        string4 = raptorCodeEditorDnDHandler.handleDrop(list);
                    }
                    if (!bl) {
                        String string5 = "";
                        return string5;
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                finally {
                    if (bl) {
                        Connections.getInstance().unlock(string3);
                    }
                }
            }
        }
        String string6 = string4;
        try {
            string6 = CustomFormat.getInstance().format(string4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string4 != null && !(raptorCodeEditorDnDHandler instanceof DefaultRaptorCodeEditorDnDHandler) ? string6 : string4;
    }
}

