/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.conntypes;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.List;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.utils.DatabaseJDBCRegistry;
import oracle.dbtools.raptor.utils.FileUtils;
import oracle.ide.Ide;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLPath;
import oracle.javatools.util.ModelUtil;

public class RaptorClassLoader
extends URLClassLoader {
    private static final String JAR_EXT = ".jar";
    public static final String DIRECTORY_DRIVERS = "drivers";
    private static RaptorClassLoader s_defaultLoader;
    private static RaptorClassLoader s_instance;
    private URLPath m_path = new URLPath();

    public static void registerClassPath(String string, URLPath uRLPath, URLPath uRLPath2) {
    }

    public static synchronized ClassLoader findClassLoader(String string) {
        ClassLoader classLoader = DatabaseJDBCRegistry.getInstance().getClassLoader(string);
        if (classLoader != null) {
            return classLoader;
        }
        DBConfig dBConfig = DBConfig.getInstance();
        URLPath uRLPath = dBConfig.getThirdPartyPath();
        if (s_instance == null || s_instance.getURLPath() != null && !s_instance.getURLPath().equals((Object)uRLPath)) {
            s_instance = RaptorClassLoader.createClassLoader(uRLPath);
        }
        return s_instance;
    }

    private static RaptorClassLoader getDefaultLoader() {
        if (s_defaultLoader == null) {
            URL uRL;
            URL uRL2;
            URLPath uRLPath = new URLPath();
            String string = Ide.getProductHomeDirectory();
            if (string != null && (uRL2 = URLFactory.newDirURL((String)string)) != null && (uRL = URLFactory.newDirURL((URL)uRL2, (String)DIRECTORY_DRIVERS)) != null) {
                uRLPath.add((Collection)FileUtils.getFilesInPath((URL[])new URL[]{uRL}, (String)JAR_EXT));
            }
            s_defaultLoader = new RaptorClassLoader(uRLPath);
        }
        return s_defaultLoader;
    }

    private static RaptorClassLoader createClassLoader(URLPath uRLPath) {
        return new RaptorClassLoader(uRLPath, (ClassLoader)RaptorClassLoader.getDefaultLoader());
    }

    private RaptorClassLoader(URLPath uRLPath) {
        this(uRLPath, RaptorClassLoader.class.getClassLoader());
    }

    private RaptorClassLoader(ClassLoader classLoader) {
        this(new URLPath(), classLoader);
    }

    private RaptorClassLoader(URLPath uRLPath, ClassLoader classLoader) {
        super(RaptorClassLoader.convertPath(uRLPath.asList()), classLoader);
        uRLPath.copyTo((Object)this.m_path);
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        return super.findClass(string);
    }

    @Override
    public URL findResource(String string) {
        return super.findResource(string);
    }

    URLPath getURLPath() {
        return this.m_path;
    }

    private static URL[] convertPath(List<URL> list) {
        int n = list.size();
        URL[] uRLArray = new URL[n];
        int n2 = 0;
        for (URL uRL : list) {
            if (JarUtil.isJarURL((URL)uRL) && !ModelUtil.hasLength((String)JarUtil.getJarEntry((URL)uRL))) {
                uRL = JarUtil.getJarFileURL((URL)uRL);
            }
            uRLArray[n2++] = uRL;
        }
        return uRLArray;
    }
}

