/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections.impexp;

import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import javax.swing.Icon;
import oracle.dbtools.raptor.connections.impexp.ImpExpEngine;
import oracle.dbtools.raptor.connections.impexp.Source;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.folders.FoldersConnectionPropertiesUpdater;
import oracle.dbtools.util.Logger;
import oracle.ideri.util.Product;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;

class ExportSource
implements Source {
    private final DatabaseConnections m_store;
    private Icon m_icon;
    private String m_label;
    private final FoldersConnectionPropertiesUpdater propsUpdater;

    ExportSource(DatabaseConnections databaseConnections) {
        this.m_store = databaseConnections;
        String string = databaseConnections.getStoreName();
        this.m_label = "IdeConnections".equals(string) && Product.isRaptor() ? DatabaseNavigatorResources.getString("STANDALONE_NAVIGATOR_LABEL") : DatabaseConnectionStores.getInstance().getShortLabel(string);
        this.propsUpdater = new FoldersConnectionPropertiesUpdater();
        this.propsUpdater.setConnectionStore(string);
    }

    @Override
    public String getName() {
        return this.m_store.getStoreName();
    }

    @Override
    public Icon getIcon() {
        if (this.m_icon == null) {
            this.m_icon = DatabaseConnectionStores.getInstance().getIcon(this.m_store.getStoreName());
        }
        return this.m_icon;
    }

    @Override
    public String getLabel() {
        return this.m_label;
    }

    @Override
    public Collection<String> listAllConnections() {
        return Collections.unmodifiableCollection(this.m_store.listConnections());
    }

    @Override
    public Properties getConnectionProperties(String string) {
        try {
            Properties properties = this.m_store.getProperties(string);
            this.propsUpdater.processForExport(string, properties);
            return properties;
        }
        catch (ConnectionException connectionException) {
            Logger.severe(ImpExpEngine.class, (Throwable)connectionException);
            return new Properties();
        }
    }
}

