/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.connections.OracleConnectionPanel;
import oracle.dbtools.raptor.connections.OracleConnectionType;
import oracle.dbtools.raptor.connections.OracleConnectionTypePanel;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.ide.util.ResourceUtils;

class TNSPanel
extends JPanel
implements OracleConnectionTypePanel {
    protected JRadioButton btnTns = new JRadioButton();
    protected JRadioButton btnSqlNet = new JRadioButton();
    protected JTextField tfdSqlNetName = new JTextField(15);
    protected ButtonGroup group = new ButtonGroup();
    private DataModel model = new DataModel();
    JComboBox cbxTnsName = new JComboBox(this.model);

    public TNSPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    @Override
    public void generateProperties(Properties properties) {
        Object object = "";
        String string = "";
        String string2 = "";
        DBConfig dBConfig = DBConfig.getInstance();
        if (this.btnTns.isSelected()) {
            int n = this.cbxTnsName.getSelectedIndex();
            if (n >= 0) {
                object = (String)this.cbxTnsName.getSelectedItem();
            }
        } else if (this.btnSqlNet.isSelected()) {
            object = OracleConnectionPanel.OCI_URL + this.tfdSqlNetName.getText();
        }
        properties.setProperty("customUrl", (String)object);
        properties.setProperty("OracleConnectionType", OracleConnectionType.TNS.name());
    }

    private void jbInit() throws Exception {
        this.model.setData(TNSHelper.getTNSEntries());
        ResourceUtils.resButton((AbstractButton)this.btnTns, (String)ConnectionDialogArb.getString("CONNECTION_DIALOG_DETAILS_TNSNAME"));
        ResourceUtils.resButton((AbstractButton)this.btnSqlNet, (String)ConnectionDialogArb.getString("CONNECTION_DIALOG_DETAILS_SQLNETNAME"));
        this.group.add(this.btnTns);
        this.group.add(this.btnSqlNet);
        this.group.setSelected(this.btnTns.getModel(), true);
        this.btnTns.setSelected(true);
        this.add((Component)this.btnTns, null);
        this.add((Component)this.cbxTnsName, null);
        this.add((Component)this.tfdSqlNetName, null);
        this.add((Component)this.btnSqlNet, null);
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        springLayout.putConstraint("West", (Component)this.btnTns, 5, "West", (Component)this.btnTns.getParent());
        springLayout.putConstraint("North", (Component)this.btnTns, 10, "North", (Component)this.btnTns.getParent());
        springLayout.putConstraint("North", (Component)this.cbxTnsName, 0, "North", (Component)this.btnTns);
        springLayout.putConstraint("East", (Component)this.cbxTnsName.getParent(), 5, "East", (Component)this.cbxTnsName);
        springLayout.putConstraint("West", (Component)this.btnSqlNet, 0, "West", (Component)this.btnTns);
        springLayout.putConstraint("North", (Component)this.btnSqlNet, 10, "South", (Component)this.btnTns);
        springLayout.putConstraint("North", (Component)this.tfdSqlNetName, 0, "North", (Component)this.btnSqlNet);
        springLayout.putConstraint("East", (Component)this.cbxTnsName, 0, "East", (Component)this.tfdSqlNetName);
        springLayout.putConstraint("West", (Component)this.cbxTnsName, 0, "West", (Component)this.tfdSqlNetName);
        springLayout.putConstraint("West", (Component)this.tfdSqlNetName, 5, "East", (Component)this.btnSqlNet);
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TNSPanel.this.toggleTextInputs();
            }
        };
        this.btnTns.getModel().addChangeListener(changeListener);
        this.btnSqlNet.getModel().addChangeListener(changeListener);
        this.toggleTextInputs();
    }

    @Override
    public void clear() {
        this.cbxTnsName.setSelectedItem(null);
        this.btnTns.setSelected(true);
        this.tfdSqlNetName.setText("");
    }

    private void toggleTextInputs() {
        if (this.btnTns.isSelected()) {
            this.tfdSqlNetName.setEnabled(false);
            this.tfdSqlNetName.setBackground(Color.LIGHT_GRAY);
            this.cbxTnsName.setEnabled(true);
            this.cbxTnsName.setBackground(Color.WHITE);
        } else if (this.btnSqlNet.isSelected()) {
            this.tfdSqlNetName.setOpaque(true);
            this.tfdSqlNetName.setEnabled(true);
            this.tfdSqlNetName.setBackground(Color.WHITE);
            this.cbxTnsName.setEnabled(false);
            this.cbxTnsName.setBackground(Color.LIGHT_GRAY);
        }
    }

    @Override
    public void setDefaultPrompts() {
        this.clear();
    }

    @Override
    public Component getPanel() {
        return this;
    }

    @Override
    public OracleConnectionType getConnectionType() {
        return OracleConnectionType.TNS;
    }

    @Override
    public void setOwner(OracleConnectionPanel oracleConnectionPanel) {
    }

    @Override
    public void updatePrompts(Properties properties) {
        String string = properties.getProperty("customUrl");
        String string2 = string.substring(string.lastIndexOf(64) + 1);
        this.cbxTnsName.setSelectedItem(string2);
        if (this.cbxTnsName.getSelectedItem() != null && this.cbxTnsName.getSelectedItem().equals(string2)) {
            this.btnTns.setSelected(true);
        } else {
            this.tfdSqlNetName.setText(string2);
            this.btnSqlNet.setSelected(true);
        }
    }

    private class DataModel
    extends DefaultComboBoxModel {
        List<TCPTNSEntry> data = null;

        private DataModel() {
        }

        public void setData(ArrayList<TCPTNSEntry> arrayList) {
            assert (arrayList != null);
            this.data = arrayList;
            TNSPanel.this.cbxTnsName.updateUI();
        }

        public List<TCPTNSEntry> getData() {
            return this.data;
        }

        public TCPTNSEntry getRowData(int n) {
            return this.data.get(n);
        }

        @Override
        public Object getElementAt(int n) {
            return this.getRowData(n).getName();
        }

        @Override
        public int getSize() {
            return this.data != null ? this.data.size() : 0;
        }
    }
}

