/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class ParserOptionsPanel
extends DefaultTraversablePanel {
    JPanel topPanel = new JPanel(new GridBagLayout());
    private JLabel parserThresholdLabel = new JLabel(Messages.getString("ParserOptionsPanel.parserThresholdLabel"));
    private WholeNumberField parseLimit = new WholeNumberField(6);
    private JLabel editorLabel = new JLabel(Messages.getString("ParserOptionsPanel.editorLabel"));
    protected JEditorPane editor = null;
    private final String template = "/*\nsql_statement: MYCOMMAND ;\nMYCOMMAND: 'THIS' 'IS' 'MY' 'COMMAND' ';'\n         | 'THIS' 'IS' 'MY' 'COMMAND' identifier ';' ;\n*/";
    static Insets emptyInsets = new Insets(0, 0, 0, 0);
    static Insets defaultInsets = new Insets(0, 0, 5, 5);
    static Insets indentedInsets = new Insets(0, 18, 5, 0);
    static Insets indentedHeaderInsets = new Insets(0, 18, 7, 5);
    private NumberFormat numberFormatter;

    public ParserOptionsPanel() {
        this.setHelpID("f1_parseroptions_html");
        this.initEditor();
        this.jbInit();
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        int n = dBConfig.getInt("PARSER_THRESHOLD");
        this.parseLimit.setValue(n);
        String string = dBConfig.getString("ADDITIONAL_RULES");
        if (string != null) {
            this.editor.setText(string);
        } else {
            this.editor.setText("/*\nsql_statement: MYCOMMAND ;\nMYCOMMAND: 'THIS' 'IS' 'MY' 'COMMAND' ';'\n         | 'THIS' 'IS' 'MY' 'COMMAND' identifier ';' ;\n*/");
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putInt("PARSER_THRESHOLD", this.parseLimit.getValue());
        try {
            String string = this.editor.getText();
            BackgroundParser.amendParserInstances(string);
            dBConfig.putString("ADDITIONAL_RULES", string);
        }
        catch (AssertionError assertionError) {
            throw new TraversalException(((Throwable)((Object)assertionError)).getMessage());
        }
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        this.numberFormatter = NumberFormat.getNumberInstance();
        this.numberFormatter.setMinimumFractionDigits(0);
        this.numberFormatter.setMaximumFractionDigits(0);
        this.topPanel.add((Component)this.parserThresholdLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 5, 0));
        this.topPanel.add((Component)this.parseLimit, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 5, 0));
        this.topPanel.add((Component)this.editorLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 5, 0));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.topPanel, "West");
        this.add(jPanel, "First");
        JScrollPane jScrollPane = new JScrollPane(this.editor);
        jScrollPane.setMinimumSize(new Dimension(460, 300));
        this.add(jScrollPane, "Center");
    }

    public void initEditor() {
        this.editor = EditorFactory.createIdeEditorPane();
    }
}

