/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.db.DBNavigatorManager;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;

public class NavigationFilterTreeRefresher {
    Collection<String> m_openConns = new HashSet<String>();
    private static final Logger LOGGER = Logger.getLogger(NavigationFilterTreeRefresher.class.getName());
    private String CONNECTIONS_LABEL = DatabaseNavigatorResources.getString("STANDALONE_NAVIGATOR_LABEL");

    private void refreshConnectionTrees() {
        NavigatorTree navigatorTree = null;
        NavigatorWindow navigatorWindow = DBNavigatorManager.getInstance().getNavigatorWindow();
        if (navigatorWindow != null && (navigatorTree = navigatorWindow.getTree()) != null) {
            NavigatorTreeNode navigatorTreeNode = navigatorTree.getRoot();
            Connections connections = Connections.getInstance();
            for (String string : connections.getConnNames()) {
                if (!connections.isConnectionOpenFast(string)) continue;
                URL uRL = DBURLFormatHelper.getURL("sqldev.nav", string);
                NavigatorTreeNode navigatorTreeNode2 = navigatorTree.findTreeNode(uRL, navigatorTreeNode);
                navigatorTree.refresh(navigatorTreeNode2);
                navigatorTree.expand(navigatorTreeNode2, false);
            }
        }
    }

    public void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NavigationFilterTreeRefresher.this.refreshConnectionTrees();
            }
        });
    }
}

