/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.raptor.SerializedData;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.builders.BuiltList;
import oracle.javatools.ui.builders.ListBuilder;
import oracle.javatools.util.ListenableCollection;

public class AutotraceInfo
extends DefaultTraversablePanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JCheckBox chkMyStat = new JCheckBox();
    private JCheckBox abbrevStat = new JCheckBox();
    private JCheckBox skipNullCols = new JCheckBox();
    private JCheckBox skipNullCols1 = new JCheckBox();
    private JCheckBox fetchAllRows = new JCheckBox();
    private JCheckBox searchInsight = new JCheckBox();
    ListenableCollection<String> aItems;
    ListenableCollection<String> eItems;

    public AutotraceInfo() {
        this.setHelpID("f1_cdbdprefautotrace_html");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        SerializedData serializedData = SerializedData.getInstance();
        for (String string : serializedData.explainOptions.keySet()) {
            if (serializedData.explainOptions.get(string).booleanValue()) {
                this.eItems.add((Object)string);
                continue;
            }
            this.eItems.remove((Object)string);
        }
        for (String string : serializedData.autotraceOptions.keySet()) {
            if (serializedData.autotraceOptions.get(string).booleanValue()) {
                this.aItems.add((Object)string);
                continue;
            }
            this.aItems.remove((Object)string);
        }
        this.chkMyStat.setSelected(serializedData.myStat);
        this.abbrevStat.setSelected(serializedData.abbrevStat);
        this.skipNullCols.setSelected(serializedData.skipNullCols);
        this.skipNullCols1.setSelected(serializedData.skipNullCols);
        this.fetchAllRows.setSelected(serializedData.fetchAll);
        this.searchInsight.setSelected(serializedData.searchInsight);
    }

    public void setAutoTraceOption(String string) {
        this.aItems.add((Object)string);
    }

    public void unsetAutoTraceOption(String string) {
        this.aItems.remove((Object)string);
    }

    public void setExplainPlanOption(String string) {
        this.eItems.add((Object)string);
    }

    public void unsetExplainPlanOption(String string) {
        this.eItems.remove((Object)string);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        SerializedData serializedData = SerializedData.getInstance();
        for (String string : serializedData.explainOptions.keySet()) {
            if (this.eItems.contains((Object)string)) {
                serializedData.explainOptions.put(string, true);
                continue;
            }
            serializedData.explainOptions.put(string, false);
        }
        for (String string : serializedData.autotraceOptions.keySet()) {
            if (this.aItems.contains((Object)string)) {
                serializedData.autotraceOptions.put(string, true);
                continue;
            }
            serializedData.autotraceOptions.put(string, false);
        }
        serializedData.myStat = this.chkMyStat.isSelected();
        serializedData.abbrevStat = this.abbrevStat.isSelected();
        serializedData.skipNullCols = this.skipNullCols.isSelected();
        serializedData.fetchAll = this.fetchAllRows.isSelected();
        serializedData.searchInsight = this.searchInsight.isSelected();
        SerializedData.write();
    }

    private void jbInit() throws Exception {
        String string2;
        this.setLayout(new GridBagLayout());
        int n = 5;
        int n2 = 5;
        JLabel jLabel = new JLabel(PreferencesArb.getString("AUTOTRACE"));
        Insets insets = new Insets(15, 15, 0, 0);
        this.add(jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets, n, n2));
        JLabel jLabel2 = new JLabel(PreferencesArb.getString("EXPLAIN"));
        this.add(jLabel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, insets, n, n2));
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String object2 : SerializedData.getInstance().autotraceOptions.keySet()) {
            linkedList.add(object2);
        }
        LinkedList linkedList2 = new LinkedList();
        for (String string2 : SerializedData.getInstance().explainOptions.keySet()) {
            linkedList2.add(string2);
        }
        ListBuilder listBuilder = new ListBuilder();
        listBuilder.setModel(linkedList);
        listBuilder.setRollover(true);
        this.aItems = listBuilder.setCheckable(new LinkedList());
        string2 = listBuilder.build();
        JComponent jComponent = string2.getGUI();
        int n3 = 11;
        this.add(jComponent, new GridBagConstraints(0, 1, 1, n3, 1.0, 1.0, 17, 1, insets, n, n2));
        ListBuilder listBuilder2 = new ListBuilder();
        listBuilder2.setModel((List)linkedList2);
        listBuilder2.setRollover(true);
        this.eItems = listBuilder2.setCheckable(new LinkedList());
        BuiltList builtList = listBuilder2.build();
        JComponent jComponent2 = builtList.getGUI();
        this.add(jComponent2, new GridBagConstraints(1, 1, 1, n3++, 1.0, 1.0, 17, 1, insets, n, n2));
        ResourceUtils.resButton((AbstractButton)this.chkMyStat, (String)PreferencesArb.getString("MYSTAT"));
        this.add(this.chkMyStat, new GridBagConstraints(0, n3++, 1, 1, 0.0, 0.0, 17, 0, insets, n, n2));
        ResourceUtils.resButton((AbstractButton)this.abbrevStat, (String)PreferencesArb.getString("ABBREVSTAT"));
        this.add(this.abbrevStat, new GridBagConstraints(0, n3++, 1, 1, 0.0, 0.0, 17, 0, insets, n, n2));
        ResourceUtils.resButton((AbstractButton)this.skipNullCols, (String)PreferencesArb.getString("SKIPNULLCOLS"));
        this.add(this.skipNullCols, new GridBagConstraints(0, n3, 1, 1, 0.0, 0.0, 17, 0, insets, n, n2));
        this.skipNullCols.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                AutotraceInfo.this.skipNullCols1.setSelected(AutotraceInfo.this.skipNullCols.isSelected());
            }
        });
        this.skipNullCols1.setEnabled(false);
        ResourceUtils.resButton((AbstractButton)this.skipNullCols1, (String)PreferencesArb.getString("SKIPNULLCOLS"));
        this.add(this.skipNullCols1, new GridBagConstraints(1, n3++, 1, 1, 0.0, 0.0, 17, 0, insets, n, n2));
        ResourceUtils.resButton((AbstractButton)this.fetchAllRows, (String)PreferencesArb.getString("FETCHALL"));
        this.add(this.fetchAllRows, new GridBagConstraints(0, n3++, 1, 1, 0.0, 0.0, 17, 0, insets, n, n2));
        ResourceUtils.resButton((AbstractButton)this.searchInsight, (String)PreferencesArb.getString("SEARCHINSIGHT"));
        this.add(this.searchInsight, new GridBagConstraints(0, n3++, 1, 1, 0.0, 0.0, 17, 0, insets, n, n2));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }
}

