/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.navigator;

import java.awt.Component;
import oracle.dbtools.raptor.cloud.navigator.CloudConnection;
import oracle.dbtools.raptor.cloud.navigator.CloudConnections;
import oracle.dbtools.raptor.cloud.navigator.CloudController;
import oracle.dbtools.raptor.cloud.navigator.CloudObject;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Element;
import oracle.jdeveloper.JDeveloperMenuConstants;

public final class CloudContextMenuListener
implements ContextMenuListener {
    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        Element[] elementArray = context.getSelection();
        if (elementArray.length == 0) {
            return;
        }
        boolean bl = elementArray.length > 1;
        Element element = elementArray[0];
        if (element instanceof CloudConnections) {
            this.addMenuItem((MenuManager)contextMenu, CloudController.NEW_CLOUD_CONN_CMD_ID, 1.0f);
        } else if (element instanceof CloudConnection) {
            if (!bl) {
                this.addMenuItem((MenuManager)contextMenu, CloudController.OPEN_CMD_ID, 1.0f, 1.0f);
                this.addMenuItem((MenuManager)contextMenu, CloudController.CLOSE_CMD_ID, 1.1f, 1.0f);
                this.addMenuItem((MenuManager)contextMenu, 56, 1.1f, JDeveloperMenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
            }
            this.addMenuItem((MenuManager)contextMenu, 20, 1.0f);
        } else if (element instanceof CloudObject && ((CloudObject)element).getObjectType().equals("DEPLOYMENTS")) {
            this.addMenuItem((MenuManager)contextMenu, CloudController.STATUS_CMD_ID, 1.0f, 1.0f);
            this.addMenuItem((MenuManager)contextMenu, CloudController.LOG_CMD_ID, 1.0f, 1.0f);
            this.addMenuItem((MenuManager)contextMenu, CloudController.DOWNLOAD_LOG_CMD_ID, 1.0f, 1.0f);
            this.addMenuItem((MenuManager)contextMenu, CloudController.DELETE_CMD_ID, 1.0f, 1.0f);
        }
    }

    private void addMenuItem(MenuManager menuManager, int n, float f) {
        this.addMenuItem(menuManager, n, Float.MAX_VALUE, f);
    }

    private void addMenuItem(MenuManager menuManager, int n, float f, float f2) {
        IdeAction ideAction = IdeAction.find((int)n);
        if (ideAction != null) {
            menuManager.add((Component)menuManager.createMenuItem((ToggleAction)ideAction, f), f2);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }
}

