/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.navigator;

import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import oracle.dbtools.http.Session;
import oracle.dbtools.http.SessionException;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.navigator.db.BaseConnectionNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;

public class CloudConnection
extends BaseConnectionNode<Session> {
    private URL m_url;

    public static CloudConnection findConnectionNode(URL uRL) {
        return (CloudConnection)CloudConnection.findConnectionNodeImpl(uRL);
    }

    public static CloudConnection findOrCreateConnectionNode(URL uRL) {
        return CloudConnection.findOrCreateConnectionNodeImpl(uRL, CloudConnection.class);
    }

    public String getConnectionName() {
        return DBURLFormatHelper.getConnectionName(this.getURL());
    }

    @Override
    protected Session openConnectionImpl() throws IOException {
        Session session = null;
        try {
            session = CConnections.getInstance().getConnection(this.getConnectionName(), true);
            if (session == null) {
                throw new BaseConnectionNode.ExceptionWrapper((Throwable)new ConnectionCanceledException());
            }
        }
        catch (SessionException sessionException) {
            Throwable throwable = sessionException.getCause();
            if (throwable != null) {
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                throw new BaseConnectionNode.ExceptionWrapper(throwable);
            }
            throw new BaseConnectionNode.ExceptionWrapper(sessionException);
        }
        return session;
    }

    @Override
    protected boolean closeConnectionImpl() {
        return CConnections.getInstance().closeConnection(this.getConnectionName());
    }

    @Override
    public boolean mayHaveChildren() {
        return true;
    }

    public String getShortLabel() {
        return this.getConnectionName();
    }

    public Icon getIcon() {
        return super.getIcon();
    }

    @Override
    public String getQualifiedConnectionName() {
        return this.getConnectionName();
    }
}

