/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.connection;

import oracle.dbtools.http.Client;
import oracle.dbtools.http.SessionType;
import oracle.dbtools.http.auth.AuthenticationEngine;
import oracle.dbtools.http.auth.basic.HeadlessBasicAuthenticationEngine;
import oracle.dbtools.raptor.cloud.auth.basic.GUIBasicAuthenticationEngine;
import oracle.ide.Ide;
import oracle.ide.ProductInformation;
import oracle.ide.Version;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.util.GuidGen;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ideimpl.webupdate.CheckForUpdatesPreferences;
import oracle.ideimpl.webupdate.WebUpdateAddin;

public class DefaultClient
extends Client
implements ShutdownHook {
    DefaultClient(SessionType sessionType) {
        super(sessionType);
        ExitCommand.addShutdownHook((ShutdownHook)this);
    }

    protected void initProxy() {
        ProxyOptions proxyOptions = ProxyOptions.getProxyOptions();
        proxyOptions.applyToCurrentVM();
    }

    protected AuthenticationEngine createAuthenticationEngine() {
        return Ide.getIdeArgs().getCreateUI() ? new GUIBasicAuthenticationEngine() : new HeadlessBasicAuthenticationEngine();
    }

    protected String getUserAgent() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Ide.getProgramShortName());
        stringBuffer.append("/");
        stringBuffer.append(Version.VER);
        stringBuffer.append(" (");
        stringBuffer.append(System.getProperty("os.name"));
        stringBuffer.append(" ");
        stringBuffer.append(System.getProperty("os.version"));
        stringBuffer.append("; ");
        stringBuffer.append(System.getProperty("os.arch"));
        stringBuffer.append("; Java ");
        stringBuffer.append(System.getProperty("java.version"));
        stringBuffer.append("; ");
        stringBuffer.append(this.getSystemGuid());
        stringBuffer.append("; ");
        stringBuffer.append(ProductInformation.getProductInformation().getUserAgentExtras());
        stringBuffer.append(") ");
        stringBuffer.append(Version.VER_FULL);
        return stringBuffer.toString();
    }

    private String getSystemGuid() {
        CheckForUpdatesPreferences checkForUpdatesPreferences = WebUpdateAddin.getPreferences();
        String string = checkForUpdatesPreferences.getInstanceGuid();
        if (string == null) {
            string = GuidGen.toString((byte[])GuidGen.uuidCreate());
            checkForUpdatesPreferences.setInstanceGuid(string);
        }
        return string;
    }

    public boolean canShutdown() {
        return true;
    }

    public void shutdown() {
        this.shutdownClient();
    }
}

