/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.apex;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.sql.Connection;
import java.util.Arrays;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.raptor.apex.importer.ApexImporter;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.model.Element;
import oracle.ide.util.dnd.DropHelper;
import oracle.ide.util.dnd.TransferableTreeNode;
import oracle.ide.util.dnd.TransferablesList;

public class DeployToOracleDropHelper
implements DropHelper {
    private static final String APEX = "APEX";

    public boolean canTransferData(Object object, DataFlavor[] dataFlavorArray, int n) {
        DatabaseConnection databaseConnection = this.getDatabaseConnection(object);
        try {
            List<DataFlavor> list;
            if (databaseConnection != null && Connections.getInstance().isConnectionOpen(databaseConnection.getQualifiedConnectionName()) && Connections.getInstance().isOracle((Connection)databaseConnection.getConnection()) && (list = Arrays.asList(dataFlavorArray)).contains(TransferableTreeNode.TREE_NODE_FLAVOR) && !list.contains(TransferablesList.TRANSFERABLE_LIST_FLAVOR)) {
                return true;
            }
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
        return false;
    }

    private DatabaseConnection getDatabaseConnection(Object object) {
        DatabaseConnection databaseConnection = null;
        Element element = DBObjectNodeUtil.getTreeNodeElement((Object)object);
        if (element instanceof DatabaseConnection) {
            databaseConnection = (DatabaseConnection)element;
        }
        return databaseConnection;
    }

    public boolean transferData(Object object, Transferable[] transferableArray, int n) {
        if (transferableArray.length > 1) {
            return false;
        }
        DatabaseConnection databaseConnection = this.getDatabaseConnection(object);
        DBObject dBObject = null;
        try {
            Object object2 = transferableArray[0].getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR);
            if (object2 instanceof DefaultMutableTreeNode) {
                dBObject = new DBObject(((NavigatorTreeNode)object2).getElement());
            }
            if (null == dBObject || !APEX.equals(dBObject.getObjectType())) {
                return false;
            }
            Context context = Context.newIdeContext(dBObject.getElement());
            ApexImporter.showDeployWizard(context, databaseConnection.getQualifiedConnectionName());
            return true;
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
            return false;
        }
    }

    public float getWeight() {
        return 10.0f;
    }
}

