/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.Connection;
import java.util.Map;
import java.util.Objects;
import javax.swing.RepaintManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import oracle.dbtools.common.config.ICommonConfig;
import oracle.dbtools.common.config.IEnvironmentConfig;
import oracle.dbtools.common.config.IStorage;
import oracle.dbtools.common.ddl.DDLFormatConfig;
import oracle.dbtools.common.ddl.TargetFormatConfig;
import oracle.dbtools.common.utils.DBObjectHandler;
import oracle.dbtools.common.utils.IDBObjectHandler;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.export.ExportDataFormatConfig;
import oracle.dbtools.export.service.ExportService;
import oracle.dbtools.export.service.ExportServiceType;
import oracle.dbtools.export.service.ExportServicesRegistry;
import oracle.dbtools.extract.models.ExtractSqlHandler;
import oracle.dbtools.extract.models.IExtractSqlHandler;
import oracle.dbtools.importer.core.ImportDataFormatConfig;
import oracle.dbtools.importer.readers.DataReaderRegistry;
import oracle.dbtools.importer.readers.IDataReadable;
import oracle.dbtools.insight.CompletionConfig;
import oracle.dbtools.raptor.ISQLEditor;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.UIEnvironmentStorage;
import oracle.dbtools.raptor.UIMessageHandler;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.ITaskDialog;
import oracle.dbtools.raptor.backgroundTask.ITaskTracker;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.dialogs.RaptorTaskUI;
import oracle.dbtools.raptor.backgroundTask.dialogs.TaskDialog;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskUI;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskViewer;
import oracle.dbtools.raptor.backgroundTask.ui.TaskProgressViewer;
import oracle.dbtools.raptor.config.CustomFormat;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.FormatSQLOptionsPanel;
import oracle.dbtools.raptor.connections.ConnectionTypeRegistry;
import oracle.dbtools.raptor.connections.IConnectionPanel;
import oracle.dbtools.raptor.data.importer.ImportGenRegisterSD;
import oracle.dbtools.raptor.data.readers.XLSReader;
import oracle.dbtools.raptor.data.readers.XLSXReader;
import oracle.dbtools.raptor.ddl.DDLRegisterSD;
import oracle.dbtools.raptor.editors.ActiveViewStatusChanger;
import oracle.dbtools.raptor.export.service.XSJTable;
import oracle.dbtools.raptor.extract.models.UIExtractSqlHandler;
import oracle.dbtools.raptor.format.ExcelFormatter;
import oracle.dbtools.raptor.format.ExcelXFormatter;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.format.IResultFormatter;
import oracle.dbtools.raptor.format.T2Formatter;
import oracle.dbtools.raptor.format.XLSXFormatter;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.navigator.net.DBRecognizer;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.dbtools.raptor.nls.INLSSupplier;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.status.StatusEditorAddin;
import oracle.dbtools.raptor.tasks.IdeTaskWrapper;
import oracle.dbtools.raptor.utils.ClosedConnectionListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.IExceptionHandler;
import oracle.dbtools.raptor.utils.IMessageHandler;
import oracle.dbtools.raptor.utils.IdeLogImpl;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.raptor.utils.MessageHandler;
import oracle.dbtools.raptor.utils.SQLExceptionListener;
import oracle.dbtools.raptor.utils.SQLExceptionListenerRegistry;
import oracle.dbtools.raptor.utils.UIDBObjectHandler;
import oracle.dbtools.raptor.utils.exceptions.UIExceptionHandler;
import oracle.dbtools.util.CheckThreadViolationRepaintManager;
import oracle.dbtools.util.Debug;
import oracle.dbtools.util.EventDispatchThreadHangMonitor;
import oracle.dbtools.util.Logger;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.Version;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.Preferences;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.layout.IdeProperties;
import oracle.ide.model.Recognizer;
import oracle.ide.view.ActiveViewListener;
import oracle.ideimpl.webupdate.UpdateManager;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.DBException;
import oracle.javatools.db.ora.OracleDatabaseFactory;
import oracle.javatools.editor.EditorProperties;
import oracle.jdbc.OracleConnection;

public class RaptorDBAddin
implements Addin {
    private static ISQLEditor m_iSqlEditor;
    private static boolean m_autoCommitWorking;
    private static final String[] HACK_FONTS;

    /*
     * WARNING - void declaration
     */
    public void initialize() {
        void var6_13;
        Object object2;
        UIDefaults uIDefaults;
        ExceptionHandler.setHandler((IExceptionHandler)new UIExceptionHandler());
        MessageHandler.setHandler((IMessageHandler)new UIMessageHandler());
        DBObjectHandler.setHandler((IDBObjectHandler)new UIDBObjectHandler());
        IEnvironmentConfig.Storage.setBackingStorage((IStorage)new UIEnvironmentStorage());
        RaptorTaskManager.getInstance().setIDETaskTracker((ITaskTracker)new IdeTaskWrapper());
        RaptorTaskManager.getInstance().setTaskProgressViewer((ITaskViewer)TaskProgressViewer.getInstance());
        RaptorTaskManager.getInstance().setTaskDialog((ITaskDialog)new TaskDialog());
        RaptorTaskManager.getInstance().setDefaultTaskUI((ITaskUI)new RaptorTaskUI());
        EditorManager.getEditorManager().registerDynamic((EditorAddin)new StatusEditorAddin());
        ResultSetFormatter.setMaxRows((int)5000);
        this.initNavigator();
        Recognizer.registerLowPriorityRecognizer((Recognizer)new DBRecognizer());
        Ide.getMainWindow().addActiveViewListener((ActiveViewListener)new ActiveViewStatusChanger());
        boolean bl = false;
        if (bl) {
            uIDefaults = UIManager.getLookAndFeelDefaults();
            uIDefaults.put("ProgressBarUI", "oracle.javatools.ui.plaf.theme.ThemedProgressBarUI");
            uIDefaults.put("TabbedPaneUI", "oracle.javatools.ui.plaf.theme.ThemedTabbedPaneUI");
            uIDefaults.put("ButtonUI", "oracle.javatools.ui.plaf.theme.ThemedButtonUI");
            uIDefaults.put("ToggleButtonUI", "oracle.javatools.ui.plaf.theme.ThemedToggleButtonUI");
        }
        Log.setLogImpl((Log.ILog)new IdeLogImpl());
        Debug.setDebug((Version.DEBUG_BUILD == 0 ? 1 : 0) != 0);
        if (Debug.isDebugBuild() && RaptorExtensionConstants.isStandAlone()) {
            long l = -1L;
            object2 = Ide.getIdeArgs().getArgs();
            for (int i = 0; i < ((String[])object2).length; ++i) {
                if (object2[i].equals("detect-hangs")) {
                    if (i >= ((String[])object2).length) continue;
                    String object = object2[i + 1];
                    l = Long.valueOf(object);
                    continue;
                }
                if (!object2[i].equals("check-EDT-rule")) continue;
                RepaintManager.setCurrentManager((RepaintManager)new CheckThreadViolationRepaintManager());
            }
            if (l > -1L) {
                EventDispatchThreadHangMonitor.UNREASONABLE_DISPATCH_DURATION_MS = l;
                EventDispatchThreadHangMonitor.initMonitoring();
                EventDispatchThreadHangMonitor.INSTANCE.haveShownSomeComponent = true;
            }
        }
        uIDefaults = Preferences.getPreferences();
        DBConfig dBConfig = DBConfig.getInstance((PropertyStorage)uIDefaults);
        ICommonConfig.Storage.setBackingStorage((IStorage)dBConfig);
        DDLFormatConfig.DefaultInitializer.init();
        TargetFormatConfig.DefaultInitializer.init();
        ExportDataFormatConfig.DefaultInitializer.init();
        ImportDataFormatConfig.DefaultInitializer.init();
        CompletionConfig.DefaultInitializer.init();
        this.initializeFormatter(dBConfig);
        object2 = GraphicsEnvironment.getLocalGraphicsEnvironment();
        ClassLoader classLoader = this.getClass().getClassLoader();
        for (String string : HACK_FONTS) {
            try (InputStream inputStream = classLoader.getResourceAsStream("/META-INF/" + string);){
                Font font = Font.createFont(0, inputStream);
                ((GraphicsEnvironment)object2).registerFont(font);
            }
            catch (FontFormatException | IOException exception) {
                Logger.severe(RaptorDBAddin.class, (Throwable)exception);
            }
        }
        SQLExceptionListenerRegistry.addListener((SQLExceptionListener)new ClosedConnectionListener());
        NLSProvider.setNLSSupplier((INLSSupplier)new INLSSupplier(){

            public DefaultNLSProvider getNLSProvider(Connection connection) {
                return ConnectionTypeDetails.getTypeDetails("", connection).getNLSProvider(connection);
            }

            public DefaultNLSProvider getNLSProvider(String string) {
                Connection connection = null;
                try {
                    connection = Connections.getInstance().getConnection(string);
                }
                catch (DBException dBException) {
                    Logger.warn(RaptorDBAddin.class, (String)dBException.getStackTrace()[0].toString(), (Throwable)dBException);
                }
                return ConnectionTypeDetails.getTypeDetails("", connection).getNLSProvider(connection);
            }
        });
        DDLRegisterSD.registerHandlers();
        FormatRegistry.registerBasics();
        FormatRegistry.registerFormater((IResultFormatter)new ExcelFormatter());
        FormatRegistry.registerFormater((IResultFormatter)new ExcelXFormatter());
        FormatRegistry.registerFormater((IResultFormatter)new XLSXFormatter());
        FormatRegistry.unregisterFormater((IResultFormatter)new T2Formatter());
        ResultSetFormatter.setMaxRows((int)dBConfig.getInt("MAXSCRIPTROWS"));
        ExportServicesRegistry.registerService((ExportServiceType)ExportServiceType.JTABLE, (ExportService)new XSJTable());
        ExtractSqlHandler.setHandler((IExtractSqlHandler)new UIExtractSqlHandler());
        String string = System.getProperty("line.separator");
        EnvironOptions environOptions = (EnvironOptions)Ide.getSettings().getData("environment-options");
        int n = environOptions.getLineTerminator();
        if (n == 1) {
            String string2 = "\r\n";
        } else if (n == 3) {
            String string3 = "\r";
        } else if (n == 2) {
            String string4 = "\n";
        }
        FormatRegistry.setLineTerminator((String)var6_13);
        DataReaderRegistry.registerReader((IDataReadable)new XLSReader());
        DataReaderRegistry.registerReader((IDataReadable)new XLSXReader());
        ImportGenRegisterSD.registerHandlers();
        System.setProperty("http.agent", UpdateManager.getInstance().getUserAgent(UpdateManager.getInstance().getMasterServerURL(), true));
    }

    private void initializeFormatter(DBConfig dBConfig) {
        if (RaptorExtensionConstants.isStandAlone()) {
            FormatSQLOptionsPanel.loadOptions();
            CustomFormat customFormat = CustomFormat.getInstance();
            EditorProperties editorProperties = EditorProperties.getProperties();
            Map map = customFormat.options;
            Objects.requireNonNull(customFormat);
            editorProperties.putIntegerProperty("indent-size", ((Integer)map.get("identSpaces")).intValue());
            EditorProperties editorProperties2 = EditorProperties.getProperties();
            Map map2 = customFormat.options;
            Objects.requireNonNull(customFormat);
            editorProperties2.putBooleanProperty("use-tabs", ((Boolean)map2.get("useTab")).booleanValue());
            EditorProperties editorProperties3 = EditorProperties.getProperties();
            Map map3 = customFormat.options;
            Objects.requireNonNull(customFormat);
            editorProperties3.putIntegerProperty("tab-size", ((Integer)map3.get("identSpaces")).intValue());
        }
    }

    private void initNavigator() {
        IdeProperties ideProperties = Ide.getIdeProperties();
        ideProperties.setProperty("TreeAutoExpander.Enabled", Boolean.toString(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerConnectionPanel(String string) {
        URL uRL = RaptorDBAddin.class.getClassLoader().getResource(string);
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            int n = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                string2 = string2.trim();
                ++n;
                if (string2.length() <= 0) continue;
                int n2 = string2.indexOf(61);
                if (n2 < 0) {
                    throw new RuntimeException("Invalid INI file format at line " + n + " -- Expected key=value found " + string2);
                }
                String string3 = string2.substring(0, n2).trim();
                String string4 = string2.substring(n2 + 1, string2.length()).trim();
                Class<IConnectionPanel> clazz = null;
                try {
                    clazz = Class.forName(string4).asSubclass(IConnectionPanel.class);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Logger.warn(RaptorDBAddin.class, (String)classNotFoundException.getStackTrace()[0].toString(), (Throwable)classNotFoundException);
                }
                ConnectionTypeRegistry.registerConnectionType(string3, clazz, null);
            }
        }
        catch (IOException iOException) {
            Logger.warn(RaptorDBAddin.class, (String)iOException.getStackTrace()[0].toString(), (Throwable)iOException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                Logger.warn(RaptorDBAddin.class, (String)iOException.getStackTrace()[0].toString(), (Throwable)iOException);
            }
        }
    }

    public static synchronized void registerSqlOpener(ISQLEditor iSQLEditor) {
        m_iSqlEditor = iSQLEditor;
    }

    public static ISQLEditor getSqlOpener() {
        return m_iSqlEditor;
    }

    public static void setAutoCommit(final boolean bl) {
        if (!m_autoCommitWorking) {
            RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("RaptorDBAddin.0"), true, IRaptorTaskRunMode.TASKVIEWER){

                protected Void doWork() throws TaskException {
                    m_autoCommitWorking = true;
                    OracleDatabaseFactory.setDefaultAutocommit((boolean)bl);
                    Connections connections = Connections.getInstance();
                    for (String string : connections.getConnNames()) {
                        try {
                            Connection connection;
                            ConnectionTypeDetails connectionTypeDetails;
                            if (!connections.isConnectionOpen(string) || (connectionTypeDetails = ConnectionTypeDetails.getTypeDetails(string, connection = connections.getConnection(string))) == null || !connectionTypeDetails.isSupportsAutocommit()) continue;
                            int n = ((OracleConnection)connection).getDefaultRowPrefetch();
                            int n2 = DBConfig.getInstance().getInt("ARRAYFETCHSIZE");
                            if (Connections.getInstance().isOracle(string) && n != n2) {
                                ((OracleConnection)connection).setDefaultRowPrefetch(DBConfig.getInstance().getInt("ARRAYFETCHSIZE"));
                            }
                            if (connection.getAutoCommit() == bl) continue;
                            connection.setAutoCommit(bl);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    m_autoCommitWorking = false;
                    return null;
                }
            };
            raptorTask.setCancellable(false);
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        }
    }

    static {
        HACK_FONTS = new String[]{"Hack-Bold.ttf", "Hack-BoldItalic.ttf", "Hack-Italic.ttf", "Hack-Regular.ttf"};
    }
}

