/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.app.SqlPatroller;
import oracle.dbtools.format.Messages;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.db.DBNavigatorWindow;
import oracle.dbtools.raptor.navigator.impl.DatabaseSourceNode;
import oracle.dbtools.raptor.navigator.plsql.PlSqlCompilerPage;
import oracle.dbtools.raptor.phighlight.HighlightEditorPlugin;
import oracle.dbtools.raptor.phighlight.Issue;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.BasicEditorPaneContainer;
import oracle.jdeveloper.compiler.IdeLog;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.ojc.interfaces.Storage;

public class SqlPatrollerCommand
extends Command {
    public SqlPatrollerCommand(Context context) {
        super(-1, 0, "Patrol SQL Command");
        this.context = context;
    }

    public int doit() {
        View view = this.context.getView();
        if (view instanceof BasicEditorPaneContainer) {
            BasicEditorPaneContainer basicEditorPaneContainer = (BasicEditorPaneContainer)view;
            final BasicEditorPane basicEditorPane = basicEditorPaneContainer.getFocusedEditorPane();
            if (basicEditorPane == null) {
                return 0;
            }
            final TextNode textNode = (TextNode)this.context.getNode();
            RaptorTask<Void> raptorTask = new RaptorTask<Void>(Messages.getString("Patrolling"), true, IRaptorTaskRunMode.IDE_STATUSBAR){
                Thread thread;

                protected Void doWork() throws TaskException {
                    this.thread = Thread.currentThread();
                    SqlPatrollerCommand.this.patrol(basicEditorPane, textNode);
                    return null;
                }

                public boolean cancel() {
                    if (this.thread != null) {
                        System.out.println("interrupting thread " + this.thread.getName());
                        this.thread.interrupt();
                    }
                    return super.cancel();
                }
            };
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void patrol(BasicEditorPane basicEditorPane, TextNode textNode) {
        String string;
        block19: {
            string = basicEditorPane.getText();
            TextBuffer textBuffer = textNode.acquireTextBuffer();
            try {
                if (!textBuffer.tryReadLock()) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, "!buffer.tryReadLock()");
                    return;
                }
                string = textBuffer.getString(0, textBuffer.getLength());
                if (string != null) break block19;
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, "text == null");
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, exception.getMessage(), exception);
                return;
            }
            finally {
                try {
                    textBuffer.readUnlock();
                    textNode.releaseTextBuffer();
                }
                catch (Throwable throwable) {}
            }
            return;
        }
        List list = LexerToken.parse((String)string);
        try {
            List<Issue> list2 = new SqlPatroller().analyze(string, list);
            SqlPatrollerCommand.markIssues(basicEditorPane, textNode, list2);
        }
        catch (Throwable throwable) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, throwable.getStackTrace()[0].toString(), throwable);
            return;
        }
    }

    public static void markIssues(final BasicEditorPane basicEditorPane, final TextNode textNode, final List<Issue> list) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Issue issue2;
                    HighlightEditorPlugin highlightEditorPlugin;
                    if (basicEditorPane != null) {
                        highlightEditorPlugin = HighlightEditorPlugin.highlights.get(basicEditorPane);
                        highlightEditorPlugin.setWiggleRanges(list);
                        highlightEditorPlugin.renderAdvisorHighlights(null);
                    }
                    highlightEditorPlugin = new IdeStorage((Node)textNode);
                    IdeLog ideLog = new IdeLog();
                    LogPage logPage = PlSqlCompilerPage.getErrorLog();
                    ideLog.registerAsynchronousLogPage(logPage);
                    String string = "My Project";
                    if (textNode instanceof DatabaseSourceNode) {
                        string = ((DatabaseSourceNode)textNode).getConnectionName();
                    }
                    ideLog.setProject(DBNavigatorWindow.getProject(string));
                    ideLog.setWorkspace(DBNavigatorWindow.getWorkspace());
                    ideLog.clear((Storage)highlightEditorPlugin);
                    for (Issue issue2 : list) {
                        ideLog.warning((Storage)highlightEditorPlugin, issue2.line, issue2.offset, 0, issue2.msg);
                    }
                    ideLog.completed();
                    ideLog.unregisterAsynchronousLogPage(logPage);
                    String string2 = "PLSQLNODE_WARNINGS";
                    issue2 = LogManager.getLogManager();
                    issue2.getMsgPage().log((Object)DatabaseNavigatorResources.format(string2, textNode.getShortLabel()));
                    if (!issue2.isLogVisible()) {
                        issue2.showLog();
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, throwable.getStackTrace()[0].toString(), throwable);
                }
            }
        });
    }
}

