/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import oracle.jdevimpl.help.ColorUtils;

public class TextColumnBorder
extends AbstractBorder {
    private Insets _baseInsets = new Insets(1, 2, 5, 2);

    @Override
    public final void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        this.drawRoundedRectangleBorder(g, width, height);
        this.drawLeftShadow(g, width, height);
        this.drawRightShadow(g, width, height);
        this.drawBottomShadow(g, width, height);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    @Override
    public final Insets getBorderInsets(Component c) {
        return this.getBorderInsets(null, this._baseInsets);
    }

    @Override
    public final boolean isBorderOpaque() {
        return true;
    }

    private void drawRoundedRectangleBorder(Graphics g, int width, int height) {
        g.setColor(ColorUtils.contentPanelBorderColor);
        g.drawRoundRect(1, 0, width - 3, height - 5, 5, 5);
    }

    private void drawLeftShadow(Graphics g, int width, int height) {
        g.setColor(ColorUtils.contentPanelBorderShadow2);
        g.drawLine(0, 2, 0, height - 7);
    }

    private void drawRightShadow(Graphics g, int width, int height) {
        g.setColor(ColorUtils.contentPanelBorderShadow2);
        g.drawLine(width - 1, 2, width - 1, height - 7);
    }

    private void drawBottomShadow(Graphics g, int width, int height) {
        g.setColor(ColorUtils.contentPanelBorderShadow1);
        g.drawLine(3, height - 4, width - 4, height - 4);
        g.setColor(ColorUtils.contentPanelBorderShadow2);
        g.drawLine(3, height - 3, width - 4, height - 3);
        g.setColor(ColorUtils.contentPanelBorderShadow3);
        g.drawLine(3, height - 2, width - 4, height - 2);
        g.setColor(ColorUtils.contentPanelBorderShadow4);
        g.drawLine(3, height - 1, width - 4, height - 1);
    }
}

