/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ide.util.IconDescription;
import javax.ide.util.MissingIconException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.osgi.boot.api.IdeBootProperties;
import oracle.ide.osgi.boot.api.IdeBootUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ide.webbrowser.internal.Util;
import oracle.javatools.controls.GradientPanel;
import oracle.javatools.util.SwingUtils2;
import oracle.jdeveloper.help.Cell;
import oracle.jdeveloper.help.CellComponent;
import oracle.jdevimpl.help.BrandingInfo;
import oracle.jdevimpl.help.Button;
import oracle.jdevimpl.help.ColorUtils;
import oracle.jdevimpl.help.ColumnInfo;
import oracle.jdevimpl.help.ComponentInfo;
import oracle.jdevimpl.help.DropShadow;
import oracle.jdevimpl.help.IconicButton;
import oracle.jdevimpl.help.Link;
import oracle.jdevimpl.help.MenuButton;
import oracle.jdevimpl.help.Options;
import oracle.jdevimpl.help.StartPageDefinition;
import oracle.jdevimpl.help.StartPageExtArb;
import oracle.jdevimpl.help.StartPageHook;
import oracle.jdevimpl.help.StartPageTabbedPaneUI;
import oracle.jdevimpl.help.TabInfo;
import oracle.jdevimpl.help.TextColumnBorder;
import oracle.jdevimpl.help.Utils;

public class StartPageBuilder {
    private StartPageDefinition _definition;
    private Image _backgroundImage;
    private static final String BACKGROUND_IMAGE = "/oracle/jdevimpl/help/images/startpage_background.png";
    private static Color BACKGROUND = SwingUtils2.isInHighConstrastMode() && !StartPageBuilder.isHighContrastWhite() ? UIManager.getColor("List.foreground") : UIManager.getColor("List.background");
    private static Color FOREGROUND = SwingUtils2.isInHighConstrastMode() && !StartPageBuilder.isHighContrastWhite() ? UIManager.getColor("List.background") : UIManager.getColor("List.foreground");

    public JPanel buildStartPage() {
        MyGradientPanel mainPanel = new MyGradientPanel(this.getDefinition().getBrandingInfo());
        JPanel tabContainer = new JPanel(new BorderLayout());
        tabContainer.setBackground(BACKGROUND);
        tabContainer.setBorder(BorderFactory.createEmptyBorder());
        mainPanel.setTabContainer(tabContainer);
        mainPanel.add(tabContainer);
        tabContainer.putClientProperty("print.printable", Boolean.TRUE);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setTabLayoutPolicy(1);
        tabbedPane.setFont(tabbedPane.getFont().deriveFont(0, ColorUtils.getDefaultFontSize(tabbedPane, 11.0f)));
        tabbedPane.setUI(new StartPageTabbedPaneUI());
        tabbedPane.setBackground(BACKGROUND);
        tabbedPane.setForeground(FOREGROUND);
        tabbedPane.setOpaque(SwingUtils2.isInHighConstrastMode());
        tabContainer.add((Component)tabbedPane, "Center");
        this.createTabs(tabbedPane);
        this.ensurePanelBuilt(tabbedPane);
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Object o = e.getSource();
                if (o instanceof JTabbedPane) {
                    JTabbedPane tPane = (JTabbedPane)o;
                    StartPageBuilder.this.ensurePanelBuilt(tPane);
                    Options.setLastActiveTab(tPane.getSelectedIndex());
                }
            }
        });
        return mainPanel;
    }

    private void ensurePanelBuilt(JTabbedPane tabPane) {
        Component c = tabPane.getSelectedComponent();
        if (c instanceof LazyTabPanel) {
            ((LazyTabPanel)c).buildContent();
        }
    }

    public StartPageDefinition getDefinition() {
        if (this._definition == null) {
            this._definition = StartPageHook.getStartPageDefinition();
        }
        return this._definition;
    }

    private static Image getImage(String imagePath) {
        URL imageURL = StartPageBuilder.class.getResource(imagePath);
        ImageIcon icon = new ImageIcon(imageURL);
        return icon.getImage();
    }

    private void createTabs(JTabbedPane tabPane) {
        this._backgroundImage = StartPageBuilder.getImage(BACKGROUND_IMAGE);
        List<TabInfo> tabList = this.getDefinition().getTabs();
        for (int i = 0; i < tabList.size(); ++i) {
            TabInfo tabinfo = tabList.get(i);
            LazyTabPanel lazyPanel = new LazyTabPanel(tabinfo, this._definition, this._backgroundImage);
            tabPane.addTab(tabinfo.getName(), lazyPanel);
        }
        int lastSelectedTab = Math.max(Options.getLastActiveTab(), 0);
        tabPane.setSelectedIndex(lastSelectedTab);
    }

    private static boolean isHighContrastWhite() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Color rgbBackground = (Color)toolkit.getDesktopProperty("win.desktop.backgroundColor");
        return SwingUtils2.isInHighConstrastMode() && rgbBackground != null && rgbBackground.getRed() == 255 && rgbBackground.getGreen() == 255 && rgbBackground.getBlue() == 255;
    }

    private static class MyGradientPanel
    extends GradientPanel {
        Image _headerGlow;
        Image _backgroundShadow;
        JComponent _tabPanel;
        BrandingInfo _brandingInfo;
        JLabel _productIcon;
        JLabel _productLogo;
        private static final String HEADERGLOW_IMAGE = "/oracle/jdevimpl/help/images/header_glow.png";
        private static final String BACKGROUNDSHADOW_IMAGE = "/oracle/jdevimpl/help/images/background_shadow.png";
        private static final int XOVERLAP = 400;

        public MyGradientPanel(BrandingInfo brandingInfo) {
            super(new Color(235, 235, 235), new Color(248, 248, 248), 8);
            this.setBorder(BorderFactory.createEmptyBorder());
            this._headerGlow = StartPageBuilder.getImage(HEADERGLOW_IMAGE);
            this._backgroundShadow = StartPageBuilder.getImage(BACKGROUNDSHADOW_IMAGE);
            this._brandingInfo = brandingInfo;
            Icon icon = MyGradientPanel.getIconFromIconDescription(this._brandingInfo.getProductIcon());
            if (icon != null) {
                this._productIcon = new JLabel(icon);
                this.add(this._productIcon);
            }
            if ((icon = MyGradientPanel.getIconFromIconDescription(this._brandingInfo.getLogo())) != null) {
                this._productLogo = new JLabel(icon);
                this.add(this._productLogo);
            }
        }

        public Dimension getPreferredSize() {
            Dimension d = this._tabPanel.getPreferredSize();
            d.setSize(d.width, d.height + 80);
            return d;
        }

        public void doLayout() {
            int pWidth = this.getWidth();
            Dimension d = this._tabPanel.getPreferredSize();
            int tabWidth = d.width;
            int tabHeight = d.height;
            int mainctr = pWidth / 2;
            int tabctr = tabWidth / 2;
            int offset = mainctr - tabctr;
            if (offset < 0) {
                offset = 0;
            }
            this._tabPanel.setBounds(offset, 75, tabWidth, tabHeight);
            d = this._productIcon.getPreferredSize();
            this._productIcon.setBounds(offset + 32, 9, d.width, d.height);
            d = this._productLogo.getPreferredSize();
            this._productLogo.setBounds(offset + tabWidth - (d.width + 32), 29, d.width, d.height);
        }

        public void setTabContainer(JComponent comp) {
            this._tabPanel = comp;
        }

        protected void paintComponent(Graphics g) {
            int h;
            int w;
            super.paintComponent(g);
            if (this._headerGlow != null) {
                w = this._headerGlow.getWidth((ImageObserver)((Object)this));
                h = this._headerGlow.getHeight((ImageObserver)((Object)this));
                int drawx = this._tabPanel.getX();
                int drawy = 0;
                g.drawImage(this._headerGlow, drawx, drawy, w, h, (ImageObserver)((Object)this));
            }
            if (this._backgroundShadow != null) {
                w = this._backgroundShadow.getWidth(null);
                h = this._backgroundShadow.getHeight(null);
                int pWidth = this.getWidth();
                int pHeight = this.getHeight();
                int tabContainerRightEdge = this._tabPanel.getX() + this._tabPanel.getWidth();
                int tabContainerBottomEdge = this._tabPanel.getY() + this._tabPanel.getHeight();
                int rightSpace = pWidth - tabContainerRightEdge;
                int bottomSpace = this.getHeight() - tabContainerBottomEdge;
                int subimageW = rightSpace + 400;
                int subimageH = bottomSpace + this._tabPanel.getHeight();
                int drawx = tabContainerRightEdge - 400;
                int drawy = this._tabPanel.getY();
                g.drawImage(this._backgroundShadow, drawx, drawy, pWidth, pHeight, Math.min(w - subimageW, w), Math.min(h - subimageH, h), w, h, null);
            }
        }

        private static Icon getIconFromIconDescription(IconDescription idesc) {
            try {
                if (idesc != null && idesc.getURL() != null) {
                    ImageIcon icon = new ImageIcon(idesc.getURL());
                    return icon;
                }
            }
            catch (MissingIconException missingIconException) {
                // empty catch block
            }
            return null;
        }
    }

    private static class LazyTabPanel
    extends ImagePanel {
        private boolean _initialized;
        private TabInfo _tabInfo;
        private StartPageDefinition _definition;
        private Image _backgroundImage;
        private Dimension _size = new Dimension(858, 390);

        public LazyTabPanel(TabInfo tabInfo, StartPageDefinition definition, Image backgroundImage) {
            super((LayoutManager)new GridBagLayout(), backgroundImage);
            super.setName(tabInfo.getName());
            this._tabInfo = tabInfo;
            this._definition = definition;
            this._backgroundImage = backgroundImage;
            this._size = new Dimension(this._backgroundImage.getWidth(null), this._backgroundImage.getHeight(null));
            this.setMaximumSize(this._size);
            this.setMinimumSize(this._size);
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(30, 32, 14, 32));
        }

        @Override
        public Dimension getPreferredSize() {
            return this._size;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.drawImage(this._backgroundImage, 0, 0, this.getWidth(), this.getHeight(), this);
        }

        protected void buildContent() {
            if (this._initialized) {
                return;
            }
            ArrayList<ColumnInfo> colList = new ArrayList<ColumnInfo>(this._tabInfo.getColumns());
            ArrayList<JPanel> columnPanels = new ArrayList<JPanel>(colList.size());
            GridBagConstraints constr = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
            boolean includesRSSComp = false;
            for (int i = 0; i < colList.size(); ++i) {
                ColumnInfo col = (ColumnInfo)colList.get(i);
                JPanel colPanel = this.createColumnPanel(col, this.getMaxColumnWidth(i, colList.size(), i == 0 ? null : (JPanel)columnPanels.get(0)));
                if (colPanel == null) continue;
                columnPanels.add(colPanel);
                if (!col.hasRSSComp()) continue;
                includesRSSComp = true;
            }
            JPanel panel = new JPanel();
            panel.setOpaque(false);
            GridLayout glayout = new GridLayout(1, colList.size() - 1, 5, 0);
            panel.setLayout(glayout);
            for (int i = 0; i < columnPanels.size(); ++i) {
                JScrollPane spane;
                Dimension colPrefSize;
                int rightMargin;
                constr.insets.right = rightMargin = ((ColumnInfo)colList.get(i)).getRightMargin();
                if (i == 0) {
                    colPrefSize = ((JPanel)columnPanels.get(i)).getPreferredSize();
                    if (colPrefSize.width > this.getMaxColumnWidth(i, columnPanels.size(), (JPanel)columnPanels.get(0)) || colPrefSize.height > 310) {
                        spane = new JScrollPane((Component)columnPanels.get(i), 20, 31);
                        spane.getVerticalScrollBar().setUnitIncrement(40);
                        spane.getViewport().setOpaque(false);
                        spane.setOpaque(false);
                        spane.setMinimumSize(new Dimension(Math.min(colPrefSize.width, this.getMaxColumnWidth(i, columnPanels.size(), (JPanel)columnPanels.get(0))), Math.min(colPrefSize.height, 310)));
                        this.add((Component)spane, constr);
                    } else {
                        this.add((Component)columnPanels.get(i), constr);
                    }
                    ++constr.gridx;
                    continue;
                }
                glayout.setHgap(constr.insets.right == 0 ? 5 : constr.insets.right);
                colPrefSize = ((JPanel)columnPanels.get(i)).getPreferredSize();
                if (!(includesRSSComp || colPrefSize.width <= this.getMaxColumnWidth(i, columnPanels.size(), (JPanel)columnPanels.get(0)) && colPrefSize.height <= 310)) {
                    spane = new JScrollPane((Component)columnPanels.get(i), 20, 31);
                    spane.getVerticalScrollBar().setUnitIncrement(31);
                    spane.getViewport().setOpaque(false);
                    spane.setOpaque(false);
                    if (((ColumnInfo)colList.get(i)).getShowBorder()) {
                        ((JPanel)columnPanels.get(i)).setBorder(BorderFactory.createEmptyBorder(11, 21, 11, 21));
                        spane.setBorder(BorderFactory.createCompoundBorder(new TextColumnBorder(), BorderFactory.createEmptyBorder()));
                    }
                    spane.setMinimumSize(new Dimension(Math.min(colPrefSize.width, this.getMaxColumnWidth(i, columnPanels.size(), (JPanel)columnPanels.get(0))), Math.min(colPrefSize.height, 310)));
                    panel.add(spane);
                    continue;
                }
                if (((ColumnInfo)colList.get(i)).getShowBorder()) {
                    ((JPanel)columnPanels.get(i)).setBorder(BorderFactory.createCompoundBorder(new TextColumnBorder(), BorderFactory.createEmptyBorder(11, 21, 11, 21)));
                }
                panel.add((Component)columnPanels.get(i));
            }
            if (panel.getComponentCount() > 0) {
                constr.weightx = 1.0;
                this.add((Component)panel, constr);
            } else {
                JPanel spacerPanel = new JPanel();
                spacerPanel.setOpaque(false);
                constr.gridwidth = 0;
                constr.weightx = 1.0;
                ++constr.gridx;
                constr.insets = new Insets(0, 0, 0, 0);
                this.add((Component)spacerPanel, constr);
            }
            constr.gridwidth = 0;
            constr.gridx = 0;
            constr.gridy = 2;
            constr.gridheight = 1;
            constr.weightx = 1.0;
            constr.weighty = 1.0;
            constr.anchor = 15;
            constr.insets = new Insets(5, 0, 0, 0);
            this.add((Component)this.createBottomPanel(), constr);
            this._initialized = true;
        }

        private int getMaxColumnWidth(int columnPosition, int numColumns, JPanel firstColumn) {
            if (columnPosition == 0) {
                return this._size.width / 3 - 65;
            }
            int firstColPrefWidth = firstColumn.getPreferredSize().width;
            return (this._size.width - firstColPrefWidth - 97 - (numColumns - 1) * 45 - (numColumns - 2) * 5) / (numColumns - 1);
        }

        private JPanel createBottomPanel() {
            final JCheckBox cbox = new JCheckBox();
            cbox.setSelected(Options.getShowOnStartup());
            cbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Options.setShowOnStartup(cbox.isSelected());
                }
            });
            cbox.setOpaque(false);
            cbox.setFont(cbox.getFont().deriveFont(0, ColorUtils.getDefaultFontSize(cbox, 11.0f)));
            cbox.setForeground(ColorUtils.checkboxTextColor);
            ResourceUtils.resButton((AbstractButton)cbox, (String)StartPageExtArb.get("SHOW_ON_STARTUP_CHECKBOX"));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setOpaque(false);
            panel.setBorder(BorderFactory.createEmptyBorder());
            panel.add((Component)cbox, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            JLabel label = new JLabel();
            label.setFont(label.getFont().deriveFont(0, ColorUtils.getDefaultFontSize(label, 10.0f)));
            label.setForeground(ColorUtils.copyrightTextColor);
            label.setText(IdeBootUtil.COPYRIGHT_RESOLVED_TEXT);
            panel.add((Component)label, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.1, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel createColumnPanel(ColumnInfo col, int maxWidth) {
            int cellCount = 0;
            List<Cell> cellList = col.getCells();
            JPanel cPanel = new JPanel(new GridBagLayout());
            cPanel.setOpaque(false);
            cPanel.setBorder(BorderFactory.createEmptyBorder());
            if (col.hasRSSComp()) {
                cPanel.setOpaque(true);
                cPanel.setBackground(ColorUtils.contentPanelBackgroundColor);
            }
            GridBagConstraints constr = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
            String headerText = col.getName();
            if (headerText != null) {
                JLabel label = new JLabel();
                label.setHorizontalAlignment(10);
                label.setBorder(BorderFactory.createEmptyBorder());
                label.setFont(label.getFont().deriveFont(1, ColorUtils.getDefaultFontSize(label, 11.0f)));
                label.setForeground(ColorUtils.columnHeaderTextColor);
                label.setText(headerText);
                constr.insets = new Insets(0, 0, 21, 0);
                constr.weightx = 1.0;
                constr.fill = 2;
                cPanel.add((Component)label, constr);
            }
            int maxEntries = col.getMaxEntries();
            boolean lastCell = false;
            if (cellList != Collections.EMPTY_LIST) {
                for (int i = 0; i < cellList.size() && i < maxEntries; ++i) {
                    if (i == maxEntries || i == cellList.size() - 1) {
                        lastCell = true;
                    }
                    ++constr.gridy;
                    Component c = this.createControl(cellList.get(i), maxWidth);
                    if (c == null) continue;
                    ++cellCount;
                    if (c instanceof Button || c instanceof MenuButton) {
                        JComponent jcomp = (JComponent)c;
                        constr.insets = new Insets(0, 0, 19, 0);
                        constr.weightx = 0.0;
                        constr.fill = 1;
                        c = DropShadow.createShadowedComponent(jcomp);
                    } else if (c instanceof Link) {
                        constr.insets = new Insets(0, 0, 21, 0);
                        constr.weightx = 1.0;
                        constr.fill = 2;
                    } else if (c instanceof IconicButton) {
                        constr.insets = new Insets(0, 0, 19, 0);
                        constr.weightx = 1.0;
                        constr.fill = 0;
                    } else {
                        constr.insets = new Insets(0, 0, 21, 0);
                        constr.weightx = 1.0;
                        constr.fill = 2;
                    }
                    if (lastCell) {
                        constr.insets.bottom = 0;
                    }
                    cPanel.add(c, constr);
                }
            }
            boolean spacerCreated = false;
            cellList = col.getSummaryCells();
            if (cellList != Collections.EMPTY_LIST) {
                ++constr.gridy;
                constr.weighty = 1.0;
                constr.insets = new Insets(0, 0, 0, 0);
                constr.fill = 3;
                cPanel.add((Component)new JLabel(), constr);
                ++constr.gridy;
                spacerCreated = true;
                constr.fill = 2;
                constr.weighty = 0.0;
                Insets summaryInset = new Insets(52, 0, 11, 21);
                if (col.hasRSSComp()) {
                    summaryInset.top = 19;
                }
                constr.insets = summaryInset;
                Component c = this.createControl(cellList.get(0), maxWidth);
                if (c != null) {
                    constr.anchor = 15;
                    ++cellCount;
                    cPanel.add(c, constr);
                }
            }
            if (cellCount == 0) {
                return null;
            }
            if (!spacerCreated) {
                ++constr.gridy;
                constr.weighty = 1.0;
                constr.insets = new Insets(0, 0, 0, 0);
                constr.fill = 3;
                cPanel.add((Component)new JLabel(), constr);
            }
            return cPanel;
        }

        private Component createControl(Cell cellInfo, int maxWidth) {
            String compId = cellInfo.getCompId();
            ComponentInfo compInfo = this._definition.getComponentInfo(compId);
            if (compInfo != null && this.isVisibilityValid(cellInfo) && !this.isInvalidExtensionLink(compInfo, cellInfo) && !this.isInvalidExtensionListLink(compInfo, cellInfo)) {
                try {
                    CellComponent cellComp = (CellComponent)compInfo.getMetaClass().newInstance();
                    cellComp.setCell(cellInfo);
                    if (maxWidth > -1 && cellComp instanceof Link) {
                        Dimension d = ((Component)((Object)cellComp)).getPreferredSize();
                        if (d.width > maxWidth) {
                            cellComp = (CellComponent)compInfo.getMetaClass().newInstance();
                            cellComp.setCell(cellInfo);
                            ((Link)cellComp).setTextWrapper(WordWrapper.getTextWrapper());
                        }
                    }
                    return (Component)((Object)cellComp);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return null;
        }

        private boolean isVisibilityValid(Cell cell) {
            String cellVisibility = cell.getParameterValue("visibility");
            if (cellVisibility != null) {
                if (cellVisibility.equalsIgnoreCase("all")) {
                    return true;
                }
                if (cellVisibility.equalsIgnoreCase("internal")) {
                    return Util.isInsideOracle();
                }
                if (cellVisibility.equalsIgnoreCase("internalDeveloper")) {
                    return Util.isInsideOracle() && IdeBootProperties.isDebugBuild() != false;
                }
                return !Util.isInsideOracle();
            }
            return true;
        }

        private boolean isInvalidExtensionLink(ComponentInfo compInfo, Cell cell) {
            String compId = compInfo.getId();
            if (compId.equals("installableExtensionLink")) {
                return Utils.extensionExists(cell.getParameterValue("extensionId"));
            }
            return false;
        }

        private boolean isInvalidExtensionListLink(ComponentInfo compInfo, Cell cell) {
            boolean retval = false;
            String compId = compInfo.getId();
            if (compId.equals("installableExtensionListLink")) {
                retval = true;
                Collection<String> extensions = Utils.getExtensionSet(cell.getParameter("extensionListFile"));
                if (extensions != Collections.EMPTY_SET) {
                    for (String extensionId : extensions) {
                        if (Utils.extensionExists(extensionId)) continue;
                        retval = false;
                        break;
                    }
                }
            }
            return retval;
        }
    }

    private static class ImagePanel
    extends JPanel {
        Image _backgroundImage;
        int _panelHeight = -1;
        int _panelWidth = -1;
        boolean _imagePainted;

        public ImagePanel(LayoutManager layout, Image image) {
            super(layout);
            this._backgroundImage = image;
            super.setBorder(BorderFactory.createEmptyBorder());
            this._panelWidth = image.getWidth(this);
            this._panelHeight = image.getHeight(this);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            return new Dimension(this._panelWidth == -1 ? d.width : this._panelWidth, this._panelHeight == -1 ? d.height : this._panelHeight);
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this._backgroundImage != null && !this._imagePainted) {
                g.clearRect(0, 0, this._backgroundImage.getWidth(this), this._backgroundImage.getHeight(this));
                g.drawImage(this._backgroundImage, 0, 0, this._backgroundImage.getWidth(this), this._backgroundImage.getHeight(this), this);
                this._imagePainted = true;
            }
        }
    }
}

