/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.layout.URL2String;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.help.Cell;
import oracle.jdeveloper.help.CellComponent;
import oracle.jdevimpl.help.ColorUtils;
import oracle.jdevimpl.help.Link;
import oracle.jdevimpl.help.StartPageExtArb;

public class RecentProjectsPanel
extends JPanel
implements CellComponent {
    private int MAX_PROJECTS;
    private int maxChars = 30;
    private ChangeListener _changeListener;

    public RecentProjectsPanel() {
        super(new BorderLayout());
        this.setOpaque(false);
        this._changeListener = new RecentProjectsPanelChangeListener();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.rebuildContent();
        Container c = this.getParent();
        if (c != null && c instanceof JComponent) {
            FileOpenHistory.getInstance().addChangeListener(this._changeListener);
            ((JComponent)c).addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    RecentProjectsPanel.this.rebuildContent();
                    FileOpenHistory.getInstance().addChangeListener(RecentProjectsPanel.this._changeListener);
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    FileOpenHistory.getInstance().removeChangeListener(RecentProjectsPanel.this._changeListener);
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }
            });
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
    }

    private void rebuildContent() {
        this.removeAll();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        String[] projects = FileOpenHistory.getInstance().getWorkspaceHistory();
        String label = null;
        label = projects == null || projects.length == 0 ? StartPageExtArb.get("NO_RECENT_PROJECT_LABEL") : StartPageExtArb.get("RECENT_PROJECTS_LABEL");
        JLabel jlabel = new JLabel(label);
        jlabel.setFont(jlabel.getFont().deriveFont(1, 11.0f));
        jlabel.setForeground(ColorUtils.columnHeaderTextColor);
        jlabel.setBorder(BorderFactory.createEmptyBorder());
        jlabel.setHorizontalAlignment(10);
        panel.add((Component)jlabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        int row = 1;
        for (String projectString : projects) {
            URL projectURL = URL2String.toURL((String)projectString);
            String projectName = URLFileSystem.getFileName((URL)projectURL);
            String trimmedLinkString = this.trimProjectName(projectName);
            Link b = new Link(trimmedLinkString, (Action)FileOpenHistory.getNewReopenAction((URL)projectURL));
            String fullLinkString = URLFileSystem.getPath((URL)projectURL);
            b.setToolTipText(fullLinkString);
            panel.add((Component)((Object)b), new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 15, 10, 10), 0, 0));
            if (row >= this.MAX_PROJECTS) break;
        }
        this.add((Component)panel, "Center");
        this.removeOpenedApps(panel);
    }

    @Override
    public void setCell(Cell cell) {
        String maxEntriesString = cell.getParameterValue("maxEntries");
        this.MAX_PROJECTS = Integer.valueOf(maxEntriesString);
    }

    private String trimProjectName(String projectName) {
        if (this.maxChars > 0 && projectName.length() > this.maxChars) {
            return projectName.substring(0, this.maxChars) + "...";
        }
        return projectName;
    }

    private void removeOpenedApps(JPanel panel) {
        Iterator iter = Ide.getWorkspaces().getChildren();
        while (iter.hasNext()) {
            URL wsURL;
            Workspace ws = (Workspace)iter.next();
            if (ws == null || (wsURL = ws.getURL()) == null || wsURL.getPath() == null) continue;
            String fullLinkString = URLFileSystem.getPath((URL)wsURL);
            for (Component comp : panel.getComponents()) {
                Link link;
                String linkPath;
                if (!(comp instanceof Link) || (linkPath = (link = (Link)((Object)comp)).getToolTipText()) == null || !linkPath.equals(fullLinkString)) continue;
                panel.remove((Component)((Object)link));
            }
            if (panel.getComponents() == null || panel.getComponents().length != 1 || !(panel.getComponents()[0] instanceof JLabel)) continue;
            JLabel label = (JLabel)panel.getComponent(0);
            label.setText(StartPageExtArb.get("NO_RECENT_PROJECT_LABEL"));
        }
    }

    private class RecentProjectsPanelChangeListener
    implements ChangeListener {
        private RecentProjectsPanelChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            RecentProjectsPanel.this.rebuildContent();
        }
    }
}

