/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.jdeveloper.help.Cell;
import oracle.jdeveloper.help.CellComponent;
import oracle.jdevimpl.help.ActionWrapper;
import oracle.jdevimpl.help.ColorUtils;

public class Link
extends MultiLineLabel
implements CellComponent {
    private Cell _cell;
    private Action _action;

    public Link() {
        this.init();
    }

    public Link(String label) {
        super(label);
    }

    public Link(String label, Action action) {
        this(label);
        this._action = action;
        this.init();
    }

    public boolean isFocusable() {
        return true;
    }

    @Override
    public void setCell(Cell cell) {
        this._cell = cell;
        String cellname = cell.getName();
        this.setText(cellname);
        this._action = new ActionWrapper(cell);
        this.getActionMap().put("activate", this._action);
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "activate");
        this.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "activate");
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Action action = this._action;
        if (action != null) {
            this.setEnabled(action.isEnabled());
        } else {
            this.setEnabled(true);
        }
        super.paintComponent((Graphics)g2);
    }

    protected void paintBorder(Graphics g) {
        if (this.hasFocus()) {
            super.paintBorder(g);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleLink();
        }
        return this.accessibleContext;
    }

    private void init() {
        this.setBorder(BorderFactory.createLineBorder(ColorUtils.focusLine, 1));
        this.setFont(this.getFont().deriveFont(0, ColorUtils.getDefaultFontSize((JComponent)((Object)this), 11.0f)));
        this.setForeground(ColorUtils.linkNormalTextColor);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setPreferredAspectRatio(0.0f);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Link.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                Link.this.repaint();
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Link.this._action.actionPerformed(new ActionEvent(this, 1001, ""));
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                Link.this.setForeground(ColorUtils.linkRolloverTextColor);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Link.this.setForeground(ColorUtils.linkNormalTextColor);
            }
        });
    }

    protected class AccessibleLink
    extends JComponent.AccessibleJComponent {
        protected AccessibleLink() {
            super((JComponent)((Object)Link.this));
        }

        @Override
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (Link.this.getText() == null) {
                return super.getAccessibleName();
            }
            return Link.this.getText();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet set = super.getAccessibleStateSet();
            set.add(AccessibleState.FOCUSABLE);
            set.add(AccessibleState.ENABLED);
            if (Link.this.isFocusOwner()) {
                set.add(AccessibleState.FOCUSED);
            }
            return set;
        }
    }
}

