/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.sqlhistory;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class SqlHistoryFilterModel
extends AbstractTableModel
implements TableModelListener {
    protected List<Integer> indexList = new ArrayList<Integer>();
    protected String filter = "";
    protected TableModel model;

    public SqlHistoryFilterModel() {
    }

    public SqlHistoryFilterModel(TableModel tableModel) {
        this.setModel(tableModel);
    }

    public void setModel(TableModel tableModel) {
        this.model = tableModel;
        tableModel.addTableModelListener(this);
        this.reallocateIndexes();
    }

    public TableModel getModel() {
        return this.model;
    }

    public synchronized void setFilter(String string) {
        this.filter = string;
        int n = this.model.getRowCount();
        this.indexList.clear();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)this.model.getValueAt(i, 0);
            if (string.equals("")) {
                this.indexList.add(new Integer(i));
                continue;
            }
            if (string2 == null || !string2.toLowerCase().contains(string.toLowerCase())) continue;
            this.indexList.add(new Integer(i));
        }
        this.fireTableDataChanged();
    }

    public String getFilter() {
        return this.filter;
    }

    @Override
    public String getColumnName(int n) {
        return this.model.getColumnName(n);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.model.getColumnClass(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.model.isCellEditable(n, n2);
    }

    public synchronized void reallocateIndexes() {
        int n = this.model.getRowCount();
        this.indexList.clear();
        for (int i = 0; i < n; ++i) {
            String string = (String)this.model.getValueAt(i, 0);
            if (this.filter.equals("")) {
                this.indexList.add(new Integer(i));
                continue;
            }
            if (string == null || !string.toLowerCase().contains(this.filter.toLowerCase())) continue;
            this.indexList.add(new Integer(i));
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.reallocateIndexes();
        this.fireTableChanged(tableModelEvent);
    }

    @Override
    public int getRowCount() {
        return this.indexList.size();
    }

    @Override
    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        int n3 = this.getRealRowIndex(n);
        return this.model.getValueAt(n3, n2);
    }

    public int getRealRowIndex(int n) {
        return this.indexList.get(n);
    }
}

