/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.extension;

import java.io.Reader;
import java.net.URL;
import java.sql.Connection;
import java.util.Iterator;
import javax.swing.JComponent;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.cmdline.LoadCommand;
import oracle.dbtools.cmdline.UnLoadCommand;
import oracle.dbtools.commands.DataPumpCommands;
import oracle.dbtools.commands.NetCommands;
import oracle.dbtools.raptor.ISQLEditor;
import oracle.dbtools.raptor.RaptorDBAddin;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.export.data.DataMover;
import oracle.dbtools.raptor.newscriptrunner.CommandRegistry;
import oracle.dbtools.raptor.newscriptrunner.IGetScriptParser;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.SqlParserProvider;
import oracle.dbtools.raptor.runner.DBStarterFactory;
import oracle.dbtools.raptor.runner.DbmsOutAdapter;
import oracle.dbtools.raptor.templates.TemplateVariableHandler;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.TNSPing;
import oracle.dbtools.worksheet.WorksheetResources;
import oracle.dbtools.worksheet.commands.CreateConnCmd;
import oracle.dbtools.worksheet.commands.SetServerOutputForDBMSTab;
import oracle.dbtools.worksheet.commands.SetWorkSheetTab;
import oracle.dbtools.worksheet.commands.autotrace.AutotraceAction;
import oracle.dbtools.worksheet.commands.dbmsoutput.DbmsOutputDockable;
import oracle.dbtools.worksheet.commands.dbmsoutput.DbmsOutputDockableFactory;
import oracle.dbtools.worksheet.commands.dbmsoutput.DbmsOutputPane;
import oracle.dbtools.worksheet.commands.scriptrunner.extension.ScriptRunnerHook;
import oracle.dbtools.worksheet.editor.OpenWorksheetWizard;
import oracle.dbtools.worksheet.editor.Worksheet;
import oracle.dbtools.worksheet.editor.WorksheetOpenController;
import oracle.dbtools.worksheet.extension.ConnectionVarHandler;
import oracle.dbtools.worksheet.extension.WorksheetConnectionListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorKeyStrokes;
import oracle.ide.ceditor.keymap.KeymapManager;
import oracle.ide.controller.Controller;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorAddin;
import oracle.ide.util.MenuSpec;
import oracle.ide.view.View;
import oracle.ideimpl.editor.EditorManagerImpl;
import oracle.javatools.db.DBException;

public class WorksheetAddin
extends EditorAddin {
    public void initialize() {
        Connections.getInstance().addConnectionListener((ConnectionListener)new WorksheetConnectionListener());
        this.disableSplitDocumentAction();
        CommandRegistry.addListener(SetWorkSheetTab.class, (SQLCommand.StmtSubType)SQLCommand.StmtSubType.G_S_SET_WORKSHEETNAME);
        CommandRegistry.addListener(DataMover.class, (SQLCommand.StmtSubType)SQLCommand.StmtSubType.G_S_FORALLEVENTS_STMTSUBTYPE);
        CommandRegistry.addListener(TNSPing.class, (SQLCommand.StmtSubType)SQLCommand.StmtSubType.G_S_FORALLEVENTS_STMTSUBTYPE);
        CommandRegistry.addListener(SetServerOutputForDBMSTab.class, (SQLCommand.StmtSubType)SQLCommand.StmtSubType.G_S_BEFOREAFTER_SCRIPT);
        CommandRegistry.addListener(CreateConnCmd.class, (SQLCommand.StmtSubType)SQLCommand.StmtSubType.G_S_CREATE_CONN);
        CommandRegistry.addListener(LoadCommand.class, (SQLCommand.StmtSubType)SQLCommand.StmtSubType.G_S_LOAD);
        CommandRegistry.addListener(UnLoadCommand.class, (SQLCommand.StmtSubType)SQLCommand.StmtSubType.G_S_UNLOAD);
        DataPumpCommands.registerCommands();
        NetCommands.registerCommands();
        WorksheetOpenController.init();
        TemplateVariableHandler.getVariablesMap().put("#user#", ConnectionVarHandler.class);
        RaptorDBAddin.registerSqlOpener((ISQLEditor)new ISQLEditor(){

            public View openNewEditor(String string, String string2) {
                return OpenWorksheetWizard.openNewTempWorksheet(string2, string);
            }

            public View openNewEditor(URL uRL, String string) {
                return OpenWorksheetWizard.openNewWorksheet(string, uRL);
            }

            public void showAutotraceStats(String string, View view) {
                AutotraceAction.showAutotraceStats(string, (Worksheet)view);
            }
        });
        SqlParserProvider.addGetScriptProvider((IGetScriptParser)new IGetScriptParser(){

            public Iterator<ISQLCommand> getScriptParserIterator(ScriptRunnerContext scriptRunnerContext, Reader reader) {
                return ScriptRunnerHook.getScriptParser(scriptRunnerContext, reader);
            }
        });
        Ide.getMainWindow().addDynamicMenuListener(new DynamicMenuListener(){

            public JComponent[] gatherDynamicActions(Context context) {
                if (context.getView() instanceof Worksheet) {
                    KeymapManager keymapManager = KeymapManager.getInstance();
                    EditorKeyStrokes editorKeyStrokes = keymapManager.getEditorKeyStrokes();
                    IdeAction ideAction = editorKeyStrokes.lookupAction("toggle-java-comments");
                    ideAction.setEnabled(true);
                    IdeAction ideAction2 = editorKeyStrokes.lookupAction("completion-insight");
                    ideAction2.setEnabled(true);
                    IdeAction ideAction3 = editorKeyStrokes.lookupAction("block-indent");
                    ideAction3.setEnabled(true);
                    IdeAction ideAction4 = editorKeyStrokes.lookupAction("block-outdent");
                    ideAction4.setEnabled(true);
                    return new JComponent[]{Ide.getMenubar().createMenuItem((ToggleAction)ideAction), Ide.getMenubar().createMenuItem((ToggleAction)ideAction2), Ide.getMenubar().createMenuItem((ToggleAction)ideAction3), Ide.getMenubar().createMenuItem((ToggleAction)ideAction4)};
                }
                return new JComponent[0];
            }
        });
        DBStarterFactory.dbmsOutInstance = new DbmsOutAdapter(){

            public void log(String string, Connection connection) {
                DbmsOutputPane dbmsOutputPane = DbmsOutputPane.getInstance();
                if (dbmsOutputPane != null) {
                    ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
                    scriptRunnerContext.setCurrentConnection(connection);
                    dbmsOutputPane.setOutputResult(scriptRunnerContext, string);
                }
            }

            public void enableDbmsOutput(String string) {
                try {
                    DbmsOutputDockable dbmsOutputDockable = DbmsOutputDockableFactory.getDbmsDockable();
                    dbmsOutputDockable.setDockableVisible(true);
                    DbmsOutputPane dbmsOutputPane = (DbmsOutputPane)dbmsOutputDockable.getPane();
                    dbmsOutputPane.init();
                    dbmsOutputPane.connect(string);
                    Connection connection = Connections.getInstance().getConnection(string);
                    dbmsOutputPane.enableOutput(connection, true);
                }
                catch (DBException dBException) {
                    dBException.printStackTrace();
                }
            }
        };
    }

    private void disableSplitDocumentAction() {
        IdeAction ideAction = IdeAction.get((int)EditorManagerImpl.SPLIT_DOCUMENT_CMD_ID);
        ideAction.addController(new Controller(){

            public boolean handleEvent(IdeAction ideAction, Context context) {
                return false;
            }

            public boolean update(IdeAction ideAction, Context context) {
                View view = context.getView();
                if (view != null && view instanceof Worksheet) {
                    ideAction.setEnabled(false);
                    return true;
                }
                return false;
            }
        });
    }

    public Class<Worksheet> getEditorClass() {
        return Worksheet.class;
    }

    public MenuSpec getMenuSpecification() {
        return new MenuSpec(StringUtils.stripMnemonic((String)WorksheetResources.getString("WORKSHEET_NEW")), null, null);
    }
}

