/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.editor.bookmarks;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import oracle.dbtools.worksheet.editor.bookmarks.WorksheetBookmark;
import oracle.ide.bookmarks.Bookmark;
import oracle.ide.bookmarks.BookmarkManager;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

final class BookmarkOptions
extends HashStructureAdapter
implements Copyable {
    public static final String KEY_SETTINGS = "WorksheetBookmarkOptions";
    private static final String PERSISTED_BOOKMARKS = "persistedWorksheetBookmarks";
    private static final String PROPERTY_URL = "url";
    private static final String PROPERTY_LINE = "line";
    private static final String PROPERTY_ORDINAL = "ordinal";

    public BookmarkOptions() {
        this(HashStructure.newInstance());
    }

    private BookmarkOptions(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static BookmarkOptions getInstance(PropertyStorage propertyStorage) {
        return new BookmarkOptions(BookmarkOptions.findOrCreate((PropertyStorage)propertyStorage, (String)KEY_SETTINGS));
    }

    public Collection<Bookmark> extractPersistedBookmarks() {
        ListStructure listStructure = this._hash.getListStructure(PERSISTED_BOOKMARKS);
        if (listStructure == null) {
            return Collections.emptyList();
        }
        ArrayList<Bookmark> arrayList = new ArrayList<Bookmark>();
        for (Object object : listStructure.toArray()) {
            HashStructure hashStructure = (HashStructure)object;
            URL uRL = hashStructure.getURL(PROPERTY_URL);
            int n = hashStructure.getInt(PROPERTY_LINE);
            int n2 = hashStructure.getInt(PROPERTY_ORDINAL);
            WorksheetBookmark worksheetBookmark = new WorksheetBookmark(uRL, n);
            arrayList.add((Bookmark)worksheetBookmark);
            BookmarkManager.getBookmarkManager().addBookmark((Bookmark)worksheetBookmark);
            if (0 >= n2) continue;
            BookmarkManager.getBookmarkManager().setBookmarkNumber((Bookmark)worksheetBookmark, n2);
        }
        return arrayList;
    }

    public void setPersistedBookmarks(Collection<Bookmark> collection) {
        ListStructure listStructure = ListStructure.newInstance();
        for (Bookmark bookmark : collection) {
            if (!(bookmark instanceof WorksheetBookmark)) continue;
            int n = BookmarkManager.getBookmarkManager().getBookmarkNumber(bookmark);
            HashStructure hashStructure = HashStructure.newInstance();
            hashStructure.putURL(PROPERTY_URL, ((WorksheetBookmark)bookmark).getURL());
            hashStructure.putInt(PROPERTY_LINE, ((WorksheetBookmark)bookmark).getLine());
            hashStructure.putInt(PROPERTY_ORDINAL, n);
            listStructure.add((Object)hashStructure);
        }
        this._hash.putListStructure(PERSISTED_BOOKMARKS, listStructure);
    }
}

