/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.editor;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.internal.IRaptorTaskUIListener;
import oracle.dbtools.raptor.backgroundTask.ui.IImageRegistry;
import oracle.dbtools.worksheet.Messages;

class WorksheetTaskUI
extends JPanel {
    private static final String BLANK = "BLANK";
    private static final String TIMING = "TIMING";
    private static final String PROGRESS_BAR = "PROGRESS_BAR";
    private static final String CANCEL_CMD = "CANCEL";
    private static final String PAUSE_CMD = "PAUSE";
    private RaptorTaskDescriptor m_desc;
    private String m_taskName;
    private List<IRaptorTaskUIListener> m_listeners = new CopyOnWriteArrayList<IRaptorTaskUIListener>();
    private String m_msg;
    private IRaptorTaskStatus m_status;
    private boolean m_showPause;
    private boolean m_showCancel;
    private CardLayout m_layout = new CardLayout();
    private final JProgressBar m_progress = new JProgressBar(0, 60);
    private final AbstractButton m_pause = new JToggleButton();
    private final AbstractButton m_cancel = new JButton();
    private final JLabel m_timingLabel = new JLabel();
    private L m_listener = new L();

    WorksheetTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
        this.setTaskDescriptor(raptorTaskDescriptor);
        this.setLayout(this.m_layout);
        Box box = Box.createHorizontalBox();
        this.add((Component)box, PROGRESS_BAR);
        this.m_pause.setContentAreaFilled(false);
        this.m_pause.setBorderPainted(false);
        this.m_pause.setIcon(IImageRegistry.RUN);
        this.m_pause.setSelectedIcon(IImageRegistry.PAUSE);
        this.m_pause.setActionCommand(PAUSE_CMD);
        this.m_pause.addActionListener(this.m_listener);
        box.add(this.m_pause);
        Dimension dimension = this.m_progress.getMinimumSize();
        this.m_progress.setMinimumSize(new Dimension(65, dimension.height));
        this.m_progress.setMaximumSize(new Dimension(65, dimension.height));
        this.m_progress.addMouseListener(this.m_listener);
        box.add(this.m_progress);
        this.m_cancel.setContentAreaFilled(false);
        this.m_cancel.setBorderPainted(false);
        this.m_cancel.setIcon(IImageRegistry.CANCEL);
        this.m_cancel.setActionCommand(CANCEL_CMD);
        this.m_cancel.addActionListener(this.m_listener);
        box.add(this.m_cancel);
        this.add((Component)this.m_timingLabel, TIMING);
        this.add((Component)new JPanel(), BLANK);
    }

    void setTaskDescriptor(RaptorTaskDescriptor raptorTaskDescriptor) {
        this.m_desc = raptorTaskDescriptor;
    }

    void clearPanel() {
        this.m_layout.show(this, BLANK);
    }

    @Override
    public String getName() {
        return this.m_taskName;
    }

    @Override
    public void setName(String string) {
        this.m_taskName = string;
    }

    public void addListener(IRaptorTaskUIListener iRaptorTaskUIListener) {
        this.m_listeners.add(iRaptorTaskUIListener);
    }

    public void removeListener(IRaptorTaskListener iRaptorTaskListener) {
        this.m_listeners.remove(iRaptorTaskListener);
    }

    public String getMessage() {
        return this.m_msg;
    }

    public void setMessage(String string) {
        this.m_msg = string;
    }

    public JPanel getPanel() {
        return this;
    }

    public IRaptorTaskStatus getStatus() {
        return this.m_status;
    }

    public void setStatus(IRaptorTaskStatus iRaptorTaskStatus) {
        this.m_status = iRaptorTaskStatus;
    }

    public void makeProgress(int n) {
        this.m_progress.setValue(this.m_progress.getValue() + n);
    }

    public void setProgress(int n) {
        this.m_progress.setValue(n);
    }

    public void setCancellable(boolean bl) {
        this.m_showCancel = bl;
    }

    public void setPausable(boolean bl) {
        this.m_showPause = bl;
    }

    private void setControlsEnabled(boolean bl) {
        this.m_pause.setEnabled(bl);
        this.m_cancel.setEnabled(bl);
        this.m_progress.setEnabled(bl);
    }

    private void notifyListeners(Dispatcher dispatcher) {
        for (IRaptorTaskUIListener iRaptorTaskUIListener : this.m_listeners) {
            dispatcher.dispatchTo(iRaptorTaskUIListener);
        }
    }

    public void messageChanged(RaptorTaskEvent raptorTaskEvent) {
    }

    public void progressChanged(RaptorTaskEvent raptorTaskEvent) {
        this.m_progress.setValue(this.m_desc.getProgress());
    }

    public void stateChanged(RaptorTaskEvent raptorTaskEvent) {
        switch (raptorTaskEvent.getTaskDescriptor().getStatus()) {
            case PAUSED: {
                this.m_pause.setSelected(false);
                if (!this.m_desc.isInDeterminate()) break;
                this.m_progress.setIndeterminate(false);
                this.m_progress.setValue(50);
                break;
            }
            case RUNNABLE: {
                this.m_pause.setSelected(true);
                this.setControlsEnabled(true);
                if (this.m_desc.isInDeterminate()) {
                    this.m_progress.setIndeterminate(true);
                } else {
                    this.m_progress.setIndeterminate(false);
                    this.m_progress.setValue(this.m_desc.getProgress());
                }
                this.m_cancel.setVisible(this.m_showCancel);
                this.m_pause.setVisible(this.m_showPause);
                this.m_layout.show(this, PROGRESS_BAR);
                break;
            }
            case FINISHED: {
                this.setControlsEnabled(false);
                if (raptorTaskEvent.getTaskDescriptor().isCancelled()) {
                    this.m_timingLabel.setText(Messages.getString("WorksheetTaskUI.5"));
                } else {
                    this.m_timingLabel.setText(Messages.getString("WorksheetTaskUI.6"));
                }
                this.m_layout.show(this, TIMING);
                break;
            }
            case FAILED: {
                this.setControlsEnabled(false);
                this.m_timingLabel.setText(Messages.getString("WorksheetTaskUI.7"));
                this.m_layout.show(this, TIMING);
            }
        }
    }

    public RaptorTaskDescriptor getTaskDescriptor() {
        return this.m_desc;
    }

    private class L
    extends MouseAdapter
    implements ActionListener {
        private L() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (WorksheetTaskUI.PAUSE_CMD.equals(string)) {
                WorksheetTaskUI.this.notifyListeners(new Dispatcher(){

                    @Override
                    public void dispatchTo(IRaptorTaskUIListener iRaptorTaskUIListener) {
                        iRaptorTaskUIListener.pauseClicked(WorksheetTaskUI.this.m_desc);
                    }
                });
            } else if (WorksheetTaskUI.CANCEL_CMD.equals(string)) {
                WorksheetTaskUI.this.notifyListeners(new Dispatcher(){

                    @Override
                    public void dispatchTo(IRaptorTaskUIListener iRaptorTaskUIListener) {
                        iRaptorTaskUIListener.cancelClicked(WorksheetTaskUI.this.m_desc);
                    }
                });
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            WorksheetTaskUI.this.notifyListeners(new Dispatcher(){

                @Override
                public void dispatchTo(IRaptorTaskUIListener iRaptorTaskUIListener) {
                    iRaptorTaskUIListener.taskClicked(WorksheetTaskUI.this.m_desc);
                }
            });
        }
    }

    private static interface Dispatcher {
        public void dispatchTo(IRaptorTaskUIListener var1);
    }
}

