/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.dbmsoutput;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.plaf.TabbedPaneUI;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.commands.dbmsoutput.AbstractOutputPane;
import oracle.dbtools.worksheet.commands.dbmsoutput.TabbedPaneCloseComponent;
import oracle.ide.controls.JTabbedPane2;
import oracle.ide.controls.tabbedpane.CustomTabbedPaneUI;
import oracle.javatools.editor.BasicEditorPane;

public class DbmsOwaOutputTabWindow
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTabbedPane2 m_tabPane = null;
    private Hashtable<Connection, TabInfo> m_tabHash = null;
    private AbstractOutputPane m_pane;

    public DbmsOwaOutputTabWindow(final AbstractOutputPane abstractOutputPane) {
        this.m_pane = abstractOutputPane;
        this.m_tabPane = new JTabbedPane2(3);
        this.m_tabPane.setUI((TabbedPaneUI)new CustomTabbedPaneUI());
        this.m_tabPane.setTabLayoutPolicy(1);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_tabPane, "Center");
        this.m_tabHash = new Hashtable();
        this.m_tabPane.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Connection connection = abstractOutputPane.getCurrentConnection();
                if (connection == null) {
                    return;
                }
                if (DbmsOwaOutputTabWindow.this.m_tabHash.get(connection) != null && DbmsOwaOutputTabWindow.this.m_tabHash.get((Object)connection)._gui == DbmsOwaOutputTabWindow.this.m_tabPane.getSelectedComponent()) {
                    DbmsOwaOutputTabWindow.this.m_tabPane.highlight(DbmsOwaOutputTabWindow.this.m_tabPane.getSelectedIndex(), false);
                    return;
                }
                Connection connection2 = DbmsOwaOutputTabWindow.this.getKeyForTab(DbmsOwaOutputTabWindow.this.m_tabPane.getSelectedComponent());
                if (connection2 != null) {
                    DbmsOwaOutputTabWindow.this.m_tabPane.highlight(DbmsOwaOutputTabWindow.this.m_tabPane.getSelectedIndex(), false);
                }
                abstractOutputPane.setConnection(connection2);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
    }

    public void getTabForConn(Connection connection, String string) {
        TabInfo tabInfo = this.m_tabHash.get(connection);
        if (tabInfo == null) {
            this.addTabForConn(connection, string);
        } else {
            this.m_tabPane.setSelectedComponent(tabInfo._gui);
        }
    }

    private void addTabForConn(Connection connection, String string) {
        BasicEditorPane basicEditorPane = new BasicEditorPane();
        UIUtils.addFontListener((Component)basicEditorPane);
        JScrollPane jScrollPane = new JScrollPane((Component)basicEditorPane, 20, 30);
        basicEditorPane.setEditable(false);
        this.m_tabPane.addTab(Connections.getDisplayName((String)string), null, (Component)jScrollPane, Connections.getDisplayName((String)string));
        TabInfo tabInfo = new TabInfo(string, jScrollPane, basicEditorPane, this.m_pane.getBufferSizeText(), null);
        this.m_tabHash.put(connection, tabInfo);
        this.m_tabPane.setSelectedComponent(tabInfo._gui);
        this.getCloseButton(this.m_tabPane.getSelectedIndex());
    }

    private void getCloseButton(int n) {
        this.m_tabPane.setTabComponentAt(n, (Component)new TabbedPaneCloseComponent((JTabbedPane)this.m_tabPane, this));
    }

    public TabInfo getTabInfo(Connection connection) {
        return this.m_tabHash.get(connection);
    }

    protected Connection getKeyForTab(Component component) {
        Enumeration<Connection> enumeration = this.m_tabHash.keys();
        Connection connection = null;
        while (enumeration.hasMoreElements()) {
            connection = enumeration.nextElement();
            if (this.m_tabHash.get((Object)connection)._gui != component) continue;
            break;
        }
        return connection;
    }

    protected void removeTab(Connection connection, int n) {
        if (connection == null) {
            return;
        }
        this.m_tabPane.remove(n);
        this.m_tabHash.remove(connection);
        this.m_pane.disableOutput(connection);
        if (this.m_tabHash.isEmpty()) {
            this.m_pane.setConnection(null);
            this.m_tabPane.removeAll();
            return;
        }
        if (this.m_tabPane.getTabCount() - 1 < n) {
            n = this.m_tabPane.getTabCount() - 1;
        }
        Connection connection2 = this.getKeyForTab(this.m_tabPane.getComponentAt(n));
        this.m_pane.setConnection(connection2);
        TabInfo tabInfo = this.m_tabHash.get(connection2);
        this.m_tabPane.setSelectedComponent(tabInfo._gui);
    }

    protected int getIndexOfTab(Connection connection) {
        return this.m_tabPane.indexOfComponent(this.m_tabHash.get((Object)connection)._gui);
    }

    protected void highlightTab(int n) {
        this.m_tabPane.highlight(n, true);
    }

    protected JTabbedPane2 getTabPane() {
        return this.m_tabPane;
    }

    public void remove(ConnectionEvent connectionEvent) {
        TabInfo tabInfo = this.getTabInfo(connectionEvent.getConnectionName());
        if (tabInfo == null) {
            return;
        }
        int n = this.m_tabPane.indexOfComponent(tabInfo._gui);
        this.m_tabPane.remove(n);
        this.removeHashTab(tabInfo);
        if (this.m_tabHash.isEmpty()) {
            this.m_pane.setConnection(null);
            this.m_tabPane.removeAll();
            return;
        }
        if (this.m_tabPane.getTabCount() - 1 < n) {
            n = this.m_tabPane.getTabCount() - 1;
        }
        Connection connection = this.getKeyForTab(this.m_tabPane.getComponentAt(n));
        this.m_pane.setConnection(connection);
        TabInfo tabInfo2 = this.m_tabHash.get(connection);
        this.m_tabPane.setSelectedComponent(tabInfo2._gui);
    }

    private void removeHashTab(TabInfo tabInfo) {
        Enumeration<Connection> enumeration = this.m_tabHash.keys();
        while (enumeration.hasMoreElements()) {
            Connection connection = enumeration.nextElement();
            if (this.m_tabHash.get(connection) != tabInfo) continue;
            this.m_tabHash.remove(connection);
            return;
        }
    }

    private TabInfo getTabInfo(String string) {
        Enumeration<TabInfo> enumeration = this.m_tabHash.elements();
        while (enumeration.hasMoreElements()) {
            TabInfo tabInfo = enumeration.nextElement();
            if (!tabInfo._name.equalsIgnoreCase(string)) continue;
            return tabInfo;
        }
        return null;
    }

    public static class TabInfo {
        public final Component _gui;
        public final String _name;
        public final Object _data;
        public final Object _buffer;
        public final Object _poll;

        public TabInfo(String string, Component component, Object object) {
            this._gui = component;
            this._name = string;
            this._data = object;
            this._buffer = 0;
            this._poll = 0;
        }

        public TabInfo(String string, Component component, Object object, Object object2, Object object3) {
            this._gui = component;
            this._name = string;
            this._data = object;
            this._buffer = object2;
            this._poll = object3;
        }
    }
}

