/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class NumOverlayIcon
implements Icon {
    int num;
    Icon icon;
    Icon overlay;

    public NumOverlayIcon(Icon icon, Icon icon2, int n) {
        this.icon = icon;
        this.overlay = icon2;
        this.num = n;
    }

    @Override
    public int getIconHeight() {
        return this.icon.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.icon.getIconWidth();
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Object object;
        Graphics2D graphics2D;
        int n3 = this.icon.getIconWidth();
        if (0 <= this.num) {
            n3 += 4;
        }
        BufferedImage bufferedImage = new BufferedImage(n3, 16, 2);
        bufferedImage.getGraphics().drawImage(((ImageIcon)this.icon).getImage(), n3 - this.icon.getIconWidth(), 0, n3, 16, 0, 0, n3, 16, null);
        if (0 <= this.num) {
            graphics2D = (Graphics2D)bufferedImage.getGraphics();
            object = graphics2D.getFont().deriveFont(1);
            int n4 = ((Font)object).getSize() + 4 - (this.num - 1);
            if (n4 < 5) {
                n4 = 5;
            }
            object = ((Font)object).deriveFont((float)n4);
            graphics2D.setFont((Font)object);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            String string = "" + this.num;
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n5 = fontMetrics.stringWidth(string);
            int n6 = fontMetrics.getHeight();
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fillOval(0, 0, n5 - 1, n6 - 2);
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 1.0f);
            graphics2D.setComposite(alphaComposite);
            graphics2D.setPaint(Color.red);
            graphics2D.drawString(string, 0, fontMetrics.getAscent() - 2);
        }
        if (this.overlay != null) {
            graphics2D = (Graphics2D)graphics;
            object = AlphaComposite.getInstance(3, 0.6f);
            graphics2D.setComposite((Composite)object);
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, Color.RED, this.getIconWidth(), this.getIconHeight(), Color.PINK);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillRect(0, 0, this.getIconWidth() - 1, this.getIconHeight() - 1);
        }
        new ImageIcon(bufferedImage).paintIcon(component, graphics, n, n2);
    }

    public String toString() {
        return this.icon.toString();
    }
}

