/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.TreeMap;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.commands.autotrace.AutotraceTreeModel;
import oracle.dbtools.worksheet.commands.autotrace.SerializedData;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.treetable.JTreeTable;

public class HeaderPopup
extends MouseAdapter {
    public JTreeTable tbl;
    AutotraceTreeModel mdl;
    JTableHeader hdr;
    Point mousePos = null;

    public HeaderPopup(JTreeTable jTreeTable, AutotraceTreeModel autotraceTreeModel) {
        this.tbl = jTreeTable;
        this.mdl = autotraceTreeModel;
        this.hdr = jTreeTable.getTableHeader();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.checkPopup(mouseEvent);
    }

    private void checkPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.mousePos = this.hdr.getMousePosition();
            this.getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("AutotracePanel.RemoveColumn"), OracleIcons.getIcon((String)"delete.png"));
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = HeaderPopup.this.hdr.columnAtPoint(HeaderPopup.this.mousePos);
                int n2 = HeaderPopup.this.tbl.convertColumnIndexToModel(n);
                String string = HeaderPopup.this.mdl.getColumnName(n2, false);
                TableColumn tableColumn = HeaderPopup.this.tbl.getColumnModel().getColumn(n);
                HeaderPopup.this.tbl.getColumnModel().removeColumn(tableColumn);
                HeaderPopup.this.tbl.repaint();
                oracle.dbtools.raptor.SerializedData serializedData = oracle.dbtools.raptor.SerializedData.getInstance();
                if (HeaderPopup.this.mdl.src.isExplainPlan) {
                    serializedData.explainOptions.put(string, false);
                } else {
                    serializedData.autotraceOptions.put(string, false);
                }
                serializedData.write();
            }
        });
        jMenuItem = new JMenuItem(Messages.getString("AutotracePanel.RenameColumn"));
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = HeaderPopup.this.hdr.columnAtPoint(HeaderPopup.this.mousePos);
                int n2 = HeaderPopup.this.tbl.convertColumnIndexToModel(n);
                String string = HeaderPopup.this.mdl.getColumnName(n2, false);
                String string2 = JOptionPane.showInputDialog(null, Messages.getString("AutotracePanel.NewColAlias"), Messages.getString("AutotracePanel.RenameDlgTitle") + " " + string, -1);
                if (string2 != null) {
                    TreeMap<String, String> treeMap = SerializedData.getInstance().columnNames;
                    treeMap.put(string, string2);
                    SerializedData.write();
                    HeaderPopup.this.tbl.getColumnModel().getColumn(n).setHeaderValue(string2);
                    HeaderPopup.this.tbl.getTableHeader().repaint();
                }
            }
        });
        return jPopupMenu;
    }
}

