/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands;

import java.sql.Connection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.worksheet.ActionProvider;
import oracle.dbtools.worksheet.WorksheetAction;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.WorksheetTaskWrapper;
import oracle.dbtools.worksheet.commands.CommandsResources;
import oracle.dbtools.worksheet.commands.Messages;
import oracle.dbtools.worksheet.editor.OpenWorksheetWizard;
import oracle.dbtools.worksheet.utils.WorksheetUtil;
import oracle.ide.view.View;
import oracle.ide.view.ViewAdapter;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.javatools.db.DBException;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;

public class UnsharedWorksheetActionProvider
implements ActionProvider<Connection>,
ConnectionListener {
    private static final Logger LOGGER = Logger.getLogger(UnsharedWorksheetActionProvider.class.getName());
    private static final String UNSHARED_WORKSHEET_CMD_ID = "Worksheet.UnsharedWorksheet";
    private String _text = null;

    public UnsharedWorksheetActionProvider() {
        Connections.getInstance().addConnectionListener((ConnectionListener)this);
    }

    @Override
    public boolean checkActionEnabled(String string, WorksheetContext worksheetContext) {
        String string2 = worksheetContext.getConnectionName();
        return ModelUtil.hasLength((String)string2) && !Connections.isPrivateConnection((String)string2);
    }

    @Override
    public WorksheetTaskWrapper<Connection> doAction(String string, WorksheetContext worksheetContext) {
        return this.doAction(string, worksheetContext, null, null);
    }

    public WorksheetTaskWrapper<Connection> doAction(String string, WorksheetContext worksheetContext, String string2, String string3) {
        WorksheetTaskWrapper<Connection> worksheetTaskWrapper = null;
        String string4 = worksheetContext.getConnectionName();
        if (ModelUtil.hasLength((String)string4) && !Connections.isPrivateConnection((String)string4)) {
            try {
                final Connections connections = Connections.getInstance();
                String string5 = Connections.getConnectionName((String)string4);
                final String string6 = connections.createTemporaryConnection(string4, CommandsResources.format("UNSHARED_CONNECTION_NAME", string5));
                RaptorTask<Connection> raptorTask = new RaptorTask<Connection>(Messages.getString("UnsharedWorksheetActionProvider.TaskName"), true, IRaptorTaskRunMode.MODAL_OPTIONAL){

                    protected Connection doWork() throws TaskException {
                        try {
                            return connections.getConnection(string6);
                        }
                        catch (DBException dBException) {
                            throw new TaskException((Throwable)dBException);
                        }
                    }
                };
                RaptorTaskAdapter raptorTaskAdapter = new RaptorTaskAdapter((RaptorTask)raptorTask, string2, string6, string3, connections){
                    final /* synthetic */ RaptorTask val$task;
                    final /* synthetic */ String val$setupScript;
                    final /* synthetic */ String val$qualName;
                    final /* synthetic */ String val$tabName;
                    final /* synthetic */ Connections val$conns;
                    {
                        this.val$task = raptorTask;
                        this.val$setupScript = string;
                        this.val$qualName = string2;
                        this.val$tabName = string3;
                        this.val$conns = connections;
                    }

                    public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                        this.taskFailed(raptorTaskEvent);
                    }

                    public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                        Throwable throwable = raptorTaskEvent.getThrowable();
                        if (throwable instanceof Exception) {
                            ExceptionHandler.handleException((Throwable)((Exception)throwable));
                        }
                    }

                    public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                        try {
                            Connection connection = (Connection)this.val$task.getResult();
                            if (this.val$setupScript != null) {
                                ScriptExecutor scriptExecutor = new ScriptExecutor(connection);
                                scriptExecutor.setStmt(this.val$setupScript);
                                scriptExecutor.run();
                            }
                            if (connection != null) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        View view = null;
                                        view = UnsharedWorksheetActionProvider.this.getText() == null ? OpenWorksheetWizard.openNewTempWorksheet(val$qualName) : OpenWorksheetWizard.openNewTempWorksheet(val$qualName, UnsharedWorksheetActionProvider.this.getText());
                                        if (val$tabName != null) {
                                            WorksheetUtil.setWorksheetTabName(view.getContext().getNode().getURL(), val$tabName);
                                        }
                                        if (view != null) {
                                            view.addViewListener((ViewListener)new ViewAdapter(){

                                                public void viewClosed(ViewEvent viewEvent) {
                                                    RaptorTask<Void> raptorTask = new RaptorTask<Void>(CommandsResources.format("CLOSE_CONNECTION_TASK", val$qualName)){

                                                        protected Void doWork() throws TaskException {
                                                            if (val$conns.closeConnection(val$qualName)) {
                                                                try {
                                                                    DatabaseConnections databaseConnections = val$conns.getTemporaryConnectionStore("internal");
                                                                    String string = Connections.getConnectionName((String)val$qualName);
                                                                    if (!databaseConnections.removeConnection(string)) {
                                                                        LOGGER.log(Level.WARNING, Messages.getString("UnsharedWorksheetActionProvider.1") + string);
                                                                    }
                                                                }
                                                                catch (ConnectionException connectionException) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                            return null;
                                                        }
                                                    };
                                                    RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
                                                }
                                            });
                                        }
                                    }
                                });
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            LOGGER.severe(interruptedException.getLocalizedMessage());
                        }
                        catch (ExecutionException executionException) {
                            LOGGER.severe(executionException.getLocalizedMessage());
                        }
                    }
                };
                worksheetTaskWrapper = new WorksheetTaskWrapper<Connection>(raptorTask, Collections.singletonList(raptorTaskAdapter), null, null, worksheetContext);
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        return worksheetTaskWrapper;
    }

    @Override
    public WorksheetAction getActionAt(int n) {
        return WorksheetAction.createWorksheetAction(UNSHARED_WORKSHEET_CMD_ID, WorksheetAction.ActionType.TOOLBAR_ONLY, 3, 0.1);
    }

    @Override
    public int getActionsCount() {
        return 1;
    }

    @Override
    public WorksheetResultPanel getPanelAt(int n) {
        return null;
    }

    @Override
    public int getPanelCount() {
        return 0;
    }

    public void connectionAdded(ConnectionEvent connectionEvent) {
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
    }

    public void connectionModified(ConnectionEvent connectionEvent) {
        this.resetOriginalConnection(connectionEvent);
    }

    public void connectionOpened(ConnectionEvent connectionEvent) {
    }

    public void connectionRemoved(ConnectionEvent connectionEvent) {
    }

    public void connectionRenamed(ConnectionEvent connectionEvent) {
    }

    private boolean resetOriginalConnection(ConnectionEvent connectionEvent) {
        String string = connectionEvent.getConnectionName();
        String string2 = connectionEvent.getOldName();
        if (string2 != null && string != null && !string.equals(string2)) {
            String[] stringArray;
            for (String string3 : stringArray = Connections.getInstance().getConnNames("internal")) {
                Properties properties;
                String string4;
                if (string.equals(string3) || (string4 = (properties = Connections.getInstance().getConnectionInfo(string3)).get("UnsharedWorksheetOriginalConnectionName").toString()) == null || !ModelUtil.areEqual((Object)string4, (Object)string2)) continue;
                properties.put("UnsharedWorksheetOriginalConnectionName", string);
            }
        }
        return false;
    }

    public static String getOriginalConnName(String string) {
        return Connections.getInstance().getConnectionInfo(string).get("UnsharedWorksheetOriginalConnectionName").toString();
    }

    public void setText(String string) {
        this._text = string;
    }

    public String getText() {
        return this._text;
    }
}

