/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet;

import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;

public final class WorksheetAction
implements Comparable<WorksheetAction> {
    public static final int SECTION_RUN = 0;
    public static final int SECTION_TRANSACTION = 1;
    public static final int SECTION_ANALYZE = 2;
    public static final int SECTION_MISC = 3;
    private String[] m_ids;
    private IdeAction[] m_actions;
    private int m_section;
    private double m_weight;
    private ActionType m_type;
    private String m_label;

    public static WorksheetAction createWorksheetAction(String string, ActionType actionType, int n, double d) {
        return WorksheetAction.createWorksheetAction(new String[]{string}, null, actionType, n, d);
    }

    public static WorksheetAction createWorksheetAction(String[] stringArray, String string, ActionType actionType, int n, double d) {
        return new WorksheetAction(stringArray, string, actionType, n, d);
    }

    private WorksheetAction(String[] stringArray, String string, ActionType actionType, int n, double d) {
        this.m_ids = stringArray;
        this.m_label = string;
        this.m_type = actionType;
        this.m_section = n;
        this.m_weight = d;
    }

    public String[] getIds() {
        return this.m_ids;
    }

    public IdeAction getIdeAction(String string) {
        IdeAction ideAction = null;
        if (this.m_actions == null) {
            this.m_actions = new IdeAction[this.m_ids.length];
        }
        int n = this.m_ids.length;
        for (int i = 0; i < n; ++i) {
            if (!this.m_ids[i].equals(string)) continue;
            if (this.m_actions[i] == null) {
                int n2 = Ide.findOrCreateCmdID((String)string);
                this.m_actions[i] = IdeAction.find((int)n2);
            }
            ideAction = this.m_actions[i];
            break;
        }
        return ideAction;
    }

    public String getMenuLabel() {
        return this.m_label;
    }

    public int getSection() {
        return this.m_section;
    }

    public double getWeight() {
        return this.m_weight;
    }

    public ActionType getType() {
        return this.m_type;
    }

    @Override
    public int compareTo(WorksheetAction worksheetAction) {
        int n = this.m_section - worksheetAction.m_section;
        if (n != 0) {
            return n;
        }
        if (this.m_weight > worksheetAction.m_weight) {
            return -1;
        }
        if (this.m_weight < worksheetAction.m_weight) {
            return 1;
        }
        int n2 = worksheetAction.m_ids.length - this.m_ids.length;
        if (n2 == 0) {
            int n3 = this.m_ids.length;
            for (int i = 0; i < n3 && (n2 = this.m_ids[i].compareTo(worksheetAction.m_ids[i])) == 0; ++i) {
            }
        }
        return n2;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ActionType {
        TOOLBAR_ONLY{

            @Override
            public boolean isToolbarAction() {
                return true;
            }

            @Override
            public boolean isContextMenuAction() {
                return false;
            }
        }
        ,
        CONTEXT_MENU_ONLY{

            @Override
            public boolean isToolbarAction() {
                return false;
            }

            @Override
            public boolean isContextMenuAction() {
                return true;
            }
        }
        ,
        BOTH{

            @Override
            public boolean isToolbarAction() {
                return true;
            }

            @Override
            public boolean isContextMenuAction() {
                return true;
            }
        };


        public abstract boolean isToolbarAction();

        public abstract boolean isContextMenuAction();
    }
}

