/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.viewBuilder;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.UIDefaults;
import oracle.bali.dbUI.db.DynamicRelationship;
import oracle.bali.dbUI.db.Relationship;
import oracle.bali.dbUI.viewBuilder.RelationshipLink;
import oracle.bali.dbUI.viewBuilder.ViewBuilderComponent;
import oracle.bali.dbUI.viewBuilder.ViewBuilderLinkPainter;
import oracle.bali.dbUI.viewBuilder.ViewBuilderLinkPort;
import oracle.bali.ewt.graphics.FontUtils;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.painter.PaintContext;

public class RelationshipLinkPainter
extends ViewBuilderLinkPainter {
    private static Frame _sIMAGE_CREATOR = new Frame();
    private static final String _IMAGE_PATH = "/oracle/bali/dbUI/viewBuilder/images/";
    private static Image _sEqualImage;
    private static Image _sNotEqualImage;
    private static Image _sLessImage;
    private static Image _sGreaterImage;
    private static Image _sLessEqualImage;
    private static Image _sGreaterEqualImage;
    private static Image _sOuterJoinImage;
    private static final int _START_OFFSET = 6;
    private static final int _OFFSET_MAX = 30;
    private static final int _OFFSET_INCREMENT = 6;
    private static final int _ATTACH_SIZE = 4;
    private static final int _NAME_OFFSET = 7;
    private static final float _FONT_FACTOR = 0.75f;
    private static final int _IMAGE_OFFSET = 12;
    private static final int _LINE_SIZE = 6;
    private static int _sJoinOffset;
    private Listener _listener;
    private int[] _joinOffset;
    private Vector _joinInfo;
    private Image _name;
    private int _x;
    private int _y;
    private int _width;
    private int _height;

    public RelationshipLinkPainter(RelationshipLink link) {
        super(link);
        int count = link.getPortCount();
        this._joinOffset = new int[count];
        for (int i = 0; i < count; ++i) {
            this._joinOffset[i] = _sJoinOffset;
            RelationshipLinkPainter._incrementOffset();
        }
        this._joinInfo = new Vector();
        this._listener = new Listener();
        link.addPropertyChangeListener(this._listener);
        Relationship r = link.getRelationship();
        if (r instanceof DynamicRelationship) {
            ((DynamicRelationship)r).addPropertyChangeListener(this._listener);
        }
    }

    @Override
    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        this.validate(context);
        int portCount = this.getRelationshipLink().getPortCount();
        UIDefaults defaults = context.getPaintUIDefaults();
        int state = context.getPaintState();
        boolean active = (state & 4) == 0 && this.getRelationshipLink().isActive();
        boolean enabled = (state & 1) == 0;
        boolean selected = this.getRelationshipLink().isSelected();
        boolean included = this.getRelationshipLink().isIncluded();
        Color activeColor = defaults.getColor("darkIntensity");
        Color normalColor = defaults.getColor("normalIntensity");
        Color selectedColor = defaults.getColor("textHighlight");
        Color disabledColor = defaults.getColor("textInactiveText");
        Color restart = !enabled ? disabledColor : (included & !selected ? Color.black : (selected ? selectedColor : (active ? activeColor : normalColor)));
        Image image = this._getImage();
        Image sourceImage = this._getSourceOuterJoinImage();
        Image destImage = this._getDestOuterJoinImage();
        Image name = this._getName(context);
        ImageObserver obs = context.getImageObserver();
        for (int i = 0; i < portCount; ++i) {
            g.setColor(restart);
            Info info = (Info)this._joinInfo.elementAt(i);
            g.drawLine(info.p1x, info.p1y, info.p2x, info.p2y);
            g.drawLine(info.p1x, info.p1y + 1, info.p2x, info.p2y + 1);
            g.drawLine(info.p2x, info.p2y, info.p3x, info.p3y);
            g.drawLine(info.p2x + 1, info.p2y, info.p3x + 1, info.p3y);
            g.drawLine(info.p3x, info.p3y, info.p4x, info.p4y);
            g.drawLine(info.p3x, info.p3y + 1, info.p4x, info.p4y + 1);
            if (selected) {
                g.drawLine(info.p1x, info.p1y + 2, info.p2x, info.p2y + 2);
                g.drawLine(info.p2x + 2, info.p2y, info.p3x + 2, info.p3y);
                g.drawLine(info.p3x, info.p3y + 2, info.p4x, info.p4y + 2);
            }
            if (!selected & active & !included & enabled) {
                g.setColor(Color.white);
                g.drawLine(info.p1x, info.p1y, info.p2x, info.p2y);
                g.drawLine(info.p2x, info.p2y, info.p3x, info.p3y);
                g.drawLine(info.p3x, info.p3y, info.p4x, info.p4y);
            }
            if (included & selected & enabled) {
                g.setColor(Color.black);
                g.drawLine(info.p1x, info.p1y + 1, info.p2x, info.p2y + 1);
                g.drawLine(info.p2x + 1, info.p2y, info.p3x + 1, info.p3y);
                g.drawLine(info.p3x, info.p3y + 1, info.p4x, info.p4y + 1);
            }
            if (info.left) {
                if (enabled) {
                    g.setColor(Color.black);
                } else {
                    g.setColor(disabledColor);
                }
                g.drawLine(info.parentX - 1, info.parentY - 3, info.parentX - 1, info.parentY + 4);
                g.drawLine(info.parentX - 2, info.parentY - 2, info.parentX - 2, info.parentY + 3);
                g.drawLine(info.parentX - 3, info.parentY - 1, info.parentX - 3, info.parentY + 2);
            } else {
                if (enabled) {
                    g.setColor(Color.black);
                } else {
                    g.setColor(disabledColor);
                }
                g.drawLine(info.parentX, info.parentY - 3, info.parentX, info.parentY + 4);
                g.drawLine(info.parentX + 1, info.parentY - 2, info.parentX + 1, info.parentY + 3);
                g.drawLine(info.parentX + 2, info.parentY - 1, info.parentX + 2, info.parentY + 2);
            }
            if (image != null) {
                g.drawImage(image, info.imageX, info.imageY, obs);
            }
            if (sourceImage != null) {
                g.drawImage(sourceImage, info.sourceImageX, info.sourceImageY, obs);
            }
            if (destImage != null) {
                g.drawImage(destImage, info.destImageX, info.destImageY, obs);
            }
            if (name == null) continue;
            g.drawImage(name, info.nameX, info.nameY, obs);
        }
    }

    @Override
    public boolean contains(PaintContext context, int x, int y) {
        this.validate(context);
        int portCount = this.getRelationshipLink().getPortCount();
        int halfSize = 3;
        ImageObserver obs = context.getImageObserver();
        Image image = this._getImage();
        int imageWidth = image == null ? 0 : image.getWidth(obs);
        int imageHeight = image == null ? 0 : image.getHeight(obs);
        Image name = this._getName(context);
        int nameWidth = name == null ? 0 : name.getWidth(obs);
        int nameHeight = name == null ? 0 : name.getHeight(obs);
        Image sourceImage = this._getSourceOuterJoinImage();
        int sourceWidth = sourceImage == null ? 0 : sourceImage.getWidth(obs);
        int sourceHeight = sourceImage == null ? 0 : sourceImage.getHeight(obs);
        Image destImage = this._getDestOuterJoinImage();
        int destWidth = destImage == null ? 0 : destImage.getWidth(obs);
        int destHeight = destImage == null ? 0 : destImage.getHeight(obs);
        for (int i = 0; i < portCount; ++i) {
            Info info = (Info)this._joinInfo.elementAt(i);
            if (x >= info.p1x && x <= info.p2x && y >= info.p1y - halfSize && y <= info.p1y + halfSize) {
                return true;
            }
            if (x >= info.p2x - halfSize && x <= info.p2x + halfSize && (y >= info.p2y && y <= info.p3y || y >= info.p3y && y <= info.p2y)) {
                return true;
            }
            if ((x >= info.p3x && x <= info.p4x || x >= info.p4x && x <= info.p3x) && y >= info.p3y - halfSize && y <= info.p3y + halfSize) {
                return true;
            }
            if (image != null && x >= info.imageX && x <= info.imageX + imageWidth && y >= info.imageY && y <= info.imageY + imageHeight) {
                return true;
            }
            if (name != null && x >= info.nameX && x <= info.nameX + nameWidth && y >= info.nameY && y <= info.nameY + nameHeight) {
                return true;
            }
            if (sourceImage != null && x >= info.sourceImageX && x <= info.sourceImageX + sourceWidth && y >= info.sourceImageY && y <= info.sourceImageY + sourceHeight) {
                return true;
            }
            if (destImage == null || x < info.destImageX || x > info.destImageX + destWidth || y < info.destImageY || y > info.destImageY + destHeight) continue;
            return true;
        }
        return false;
    }

    public RelationshipLink getRelationshipLink() {
        return (RelationshipLink)this.getLink();
    }

    @Override
    public void cleanup() {
        this._joinOffset = null;
        this._joinInfo.removeAllElements();
        this._joinInfo = null;
        this._name = null;
        this.getLink().removePropertyChangeListener(this._listener);
        Relationship r = this.getRelationshipLink().getRelationship();
        if (r instanceof DynamicRelationship) {
            ((DynamicRelationship)r).removePropertyChangeListener(this._listener);
        }
        super.cleanup();
    }

    @Override
    public Point getPoint(PaintContext context, Rectangle bounds) {
        Info info;
        if (bounds == null || bounds.isEmpty()) {
            return null;
        }
        Rectangle pBounds = this.getBounds(context);
        if (!bounds.intersects(pBounds)) {
            return null;
        }
        Rectangle intersect = bounds.intersection(pBounds);
        for (int i = 0; i < this._joinInfo.size(); ++i) {
            info = (Info)this._joinInfo.elementAt(i);
            if (intersect.contains(info.p1x, info.p1y)) {
                return new Point(info.p1x, info.p1y);
            }
            if (intersect.contains(info.p2x, info.p2y)) {
                return new Point(info.p2x, info.p2y);
            }
            if (intersect.contains(info.p3x, info.p3y)) {
                return new Point(info.p3x, info.p3y);
            }
            if (!intersect.contains(info.p4x, info.p4y)) continue;
            return new Point(info.p4x, info.p4y);
        }
        Rectangle lineRect = new Rectangle();
        int halfSize = 3;
        for (int i = 0; i < this._joinInfo.size(); ++i) {
            info = (Info)this._joinInfo.elementAt(i);
            lineRect.setBounds(info.p1x, info.p1y, info.p2x - info.p1x, halfSize);
            if (lineRect.intersects(intersect)) {
                return lineRect.intersection(intersect).getLocation();
            }
            lineRect.setBounds(info.p2x, Math.min(info.p2y, info.p3y), halfSize, Math.abs(info.p2y - info.p3y));
            if (lineRect.intersects(intersect)) {
                return lineRect.intersection(intersect).getLocation();
            }
            lineRect.setBounds(Math.min(info.p3x, info.p4x), info.p4y, Math.abs(info.p3x - info.p4x), halfSize);
            if (!lineRect.intersects(intersect)) continue;
            return lineRect.intersection(intersect).getLocation();
        }
        return null;
    }

    @Override
    public Dimension getMinimumSize(PaintContext context) {
        this.validate(context);
        return new Dimension(this._width, this._height);
    }

    @Override
    public Rectangle getBounds(PaintContext context) {
        this.validate(context);
        return new Rectangle(this._x, this._y, this._width, this._height);
    }

    @Override
    protected void validatePainter(PaintContext context) {
        this._joinInfo.removeAllElements();
        ImageObserver obs = context.getImageObserver();
        Image image = this._getImage();
        int imageWidth = image == null ? 0 : image.getWidth(obs);
        int imageHeight = image == null ? 0 : image.getHeight(obs);
        Image name = this._getName(context);
        int nameWidth = name == null ? 0 : name.getWidth(obs);
        int nameHeight = name == null ? 0 : name.getHeight(obs);
        Image sourceImage = this._getSourceOuterJoinImage();
        int sourceWidth = sourceImage == null ? 0 : sourceImage.getWidth(obs);
        int sourceHeight = sourceImage == null ? 0 : sourceImage.getHeight(obs);
        Image destImage = this._getDestOuterJoinImage();
        int destWidth = destImage == null ? 0 : destImage.getWidth(obs);
        int destHeight = destImage == null ? 0 : destImage.getHeight(obs);
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = 0;
        int maxY = 0;
        int portCount = this.getRelationshipLink().getPortCount();
        for (int i = 0; i < portCount; ++i) {
            Info info = new Info();
            this._joinInfo.addElement(info);
            ViewBuilderLinkPort child = this.getRelationshipLink().getSourcePort(i);
            Rectangle childBounds = child.getBounds();
            ViewBuilderComponent childComponent = child.getViewBuilderComponent();
            Rectangle childComponentBounds = childComponent.getComponentBounds();
            ViewBuilderLinkPort parent = this.getRelationshipLink().getDestinationPort(i);
            Rectangle parentBounds = parent.getBounds();
            ViewBuilderComponent parentComponent = parent.getViewBuilderComponent();
            Rectangle parentComponentBounds = parentComponent.getComponentBounds();
            int childX = childBounds.x + childComponentBounds.x;
            int childY = childBounds.y + childComponentBounds.y + childBounds.height / 2;
            int parentX = parentBounds.x + parentComponentBounds.x;
            int parentY = parentBounds.y + parentComponentBounds.y + parentBounds.height / 2;
            if (childX + childBounds.width + this._joinOffset[i] + 4 < parentX) {
                temp = (childX += childBounds.width) + this._joinOffset[i];
                info.p1x = childX;
                info.p1y = childY;
                info.p2x = temp;
                info.p2y = childY;
                info.p3x = temp;
                info.p3y = parentY;
                info.p4x = parentX;
                info.p4y = parentY;
                info.left = true;
                if (image != null) {
                    info.imageX = childX + 12;
                    info.imageY = childY - imageHeight / 2;
                }
                if (name != null) {
                    info.nameX = parentX - nameWidth - 7;
                    info.nameY = parentY - nameHeight / 2;
                }
                if (sourceImage != null) {
                    info.sourceImageX = parentX - sourceWidth - 5;
                    info.sourceImageY = parentY - sourceHeight / 2;
                }
                if (destImage != null) {
                    info.destImageX = childX + 1;
                    info.destImageY = childY - destHeight / 2;
                }
            } else if (childX < parentX) {
                temp = this._joinOffset[i] + Math.max(parentX += parentBounds.width, childX + childBounds.width);
                info.p1x = childX + childBounds.width;
                info.p1y = childY;
                info.p2x = temp;
                info.p2y = childY;
                info.p3x = temp;
                info.p3y = parentY;
                info.p4x = parentX;
                info.p4y = parentY;
                info.left = false;
                if (image != null) {
                    info.imageX = childX + childBounds.width + 12;
                    info.imageY = childY - imageHeight / 2;
                }
                if (name != null) {
                    info.nameX = parentX + 7;
                    info.nameY = parentY - nameHeight / 2;
                }
                if (sourceImage != null) {
                    info.sourceImageX = parentX + 5;
                    info.sourceImageY = parentY - sourceHeight / 2;
                }
                if (destImage != null) {
                    info.destImageX = childX + childBounds.width + 1;
                    info.destImageY = childY - destHeight / 2;
                }
            } else if (parentX + parentBounds.width + this._joinOffset[i] + 4 < childX) {
                temp = (parentX += parentBounds.width) + this._joinOffset[i];
                info.p1x = parentX;
                info.p1y = parentY;
                info.p2x = temp;
                info.p2y = parentY;
                info.p3x = temp;
                info.p3y = childY;
                info.p4x = childX;
                info.p4y = childY;
                info.left = false;
                if (image != null) {
                    info.imageX = childX - imageWidth - 12;
                    info.imageY = childY - imageHeight / 2;
                }
                if (name != null) {
                    info.nameX = parentX + 7;
                    info.nameY = parentY - nameHeight / 2;
                }
                if (sourceImage != null) {
                    info.sourceImageX = parentX + 5;
                    info.sourceImageY = parentY - sourceHeight / 2;
                }
                if (destImage != null) {
                    info.destImageX = childX - destWidth - 1;
                    info.destImageY = childY - destHeight / 2;
                }
            } else {
                temp = this._joinOffset[i] + Math.max(parentX += parentBounds.width, childX + childBounds.width);
                info.p1x = parentX;
                info.p1y = parentY;
                info.p2x = temp;
                info.p2y = parentY;
                info.p3x = temp;
                info.p3y = childY;
                info.p4x = childX + childBounds.width;
                info.p4y = childY;
                info.left = false;
                if (image != null) {
                    info.imageX = childX + childBounds.width + 12;
                    info.imageY = childY - imageHeight / 2;
                }
                if (name != null) {
                    info.nameX = parentX + 7;
                    info.nameY = parentY - nameHeight / 2;
                }
                if (sourceImage != null) {
                    info.sourceImageX = parentX + 5;
                    info.sourceImageY = parentY - sourceHeight / 2;
                }
                if (destImage != null) {
                    info.destImageX = childX + childBounds.width + 1;
                    info.destImageY = childY - destHeight / 2;
                }
            }
            info.parentX = parentX;
            info.parentY = parentY;
            minX = Math.min(minX, Math.min(info.p1x, info.p4x));
            minY = Math.min(minY, Math.min(info.p1y, info.p3y));
            maxX = Math.max(maxX, Math.max(info.p2x, info.p4x));
            maxY = Math.max(maxY, Math.max(info.p1y, info.p3y));
        }
        this._x = minX;
        this._y = minY;
        this._width = maxX - minX + 2;
        this._height = maxY - minY + 2;
    }

    private static void _incrementOffset() {
        if ((_sJoinOffset += 6) > 30) {
            _sJoinOffset = 6;
        }
    }

    private Image _createImage(int width, int height) {
        return _sIMAGE_CREATOR.createImage(width, height);
    }

    private Image _getSourceOuterJoinImage() {
        RelationshipLinkPainter._loadImages();
        return this.getRelationshipLink().isSourceOuterJoin() ? _sOuterJoinImage : null;
    }

    private Image _getDestOuterJoinImage() {
        RelationshipLinkPainter._loadImages();
        return this.getRelationshipLink().isDestinationOuterJoin() ? _sOuterJoinImage : null;
    }

    private Image _getImage() {
        int type = this.getRelationshipLink().getRelationship().getRelationshipType();
        if (type == 0) {
            return null;
        }
        Image image = null;
        RelationshipLinkPainter._loadImages();
        switch (type) {
            case 1: {
                image = _sNotEqualImage;
                break;
            }
            case 2: {
                image = _sGreaterImage;
                break;
            }
            case 3: {
                image = _sLessImage;
                break;
            }
            case 5: {
                image = _sGreaterEqualImage;
                break;
            }
            case 4: {
                image = _sLessEqualImage;
            }
        }
        return image;
    }

    private Image _getName(PaintContext context) {
        if (this.getRelationshipLink().getPortCount() == 1) {
            return null;
        }
        if (this._name == null) {
            this._name = this._createName(context);
        }
        return this._name;
    }

    private Image _createName(PaintContext context) {
        int stringHeight;
        int height;
        String name = this.getRelationshipLink().getRelationship().getDisplayName(context.getPaintLocale());
        if (name == null) {
            return null;
        }
        Font font = FontUtils.getDefaultSansSerifFont();
        int size = (int)((float)font.getSize() * 0.75f);
        font = new Font(font.getName(), font.getStyle(), size);
        FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int width = metrics.stringWidth(name) + 6;
        Image image = this._createImage(width, height = (stringHeight = metrics.getHeight()) + 4);
        if (image != null) {
            Graphics g = image.getGraphics();
            g.setFont(font);
            g.setColor(Color.white);
            g.fillRect(0, 0, width, height);
            g.setColor(Color.black);
            g.drawRect(0, 0, width - 1, height - 1);
            int y = (height - stringHeight) / 2 + metrics.getAscent();
            g.drawString(name, 2, y);
        }
        return image;
    }

    private static void _loadImages() {
        if (_sEqualImage == null) {
            Class<ViewBuilderLinkPainter> c = ViewBuilderLinkPainter.class;
            _sEqualImage = ImageUtils.getImageResource(c, (String)"/oracle/bali/dbUI/viewBuilder/images/equal.gif");
            _sNotEqualImage = ImageUtils.getImageResource(c, (String)"/oracle/bali/dbUI/viewBuilder/images/notequal.gif");
            _sLessImage = ImageUtils.getImageResource(c, (String)"/oracle/bali/dbUI/viewBuilder/images/less.gif");
            _sGreaterImage = ImageUtils.getImageResource(c, (String)"/oracle/bali/dbUI/viewBuilder/images/greater.gif");
            _sLessEqualImage = ImageUtils.getImageResource(c, (String)"/oracle/bali/dbUI/viewBuilder/images/lessequal.gif");
            _sGreaterEqualImage = ImageUtils.getImageResource(c, (String)"/oracle/bali/dbUI/viewBuilder/images/greaterequal.gif");
            _sOuterJoinImage = ImageUtils.getImageResource(c, (String)"/oracle/bali/dbUI/viewBuilder/images/outerjoin.gif");
        }
    }

    static {
        _sIMAGE_CREATOR.pack();
        _sJoinOffset = 6;
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("relationshipType".equals(name)) {
                RelationshipLinkPainter.this.invalidate();
            } else if ("sourceOuterJoin".equals(name)) {
                RelationshipLinkPainter.this.invalidate();
            } else if ("destinationOuterJoin".equals(name)) {
                RelationshipLinkPainter.this.invalidate();
            }
        }
    }

    private class Info {
        public int p1x;
        public int p1y;
        public int p2x;
        public int p2y;
        public int p3x;
        public int p3y;
        public int p4x;
        public int p4y;
        public int parentX;
        public int parentY;
        public int imageX;
        public int imageY;
        public int sourceImageX;
        public int sourceImageY;
        public int destImageX;
        public int destImageY;
        public int nameX;
        public int nameY;
        public boolean left;

        private Info() {
        }
    }
}

