/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.queryBuilder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.dbUI.columnPropertyEditor.ColumnPropertyEditor;
import oracle.bali.dbUI.columnPropertyEditor.ColumnWrapper;
import oracle.bali.dbUI.columnPropertyEditor.VisualColumn;
import oracle.bali.dbUI.columnPropertyEditor.VisualColumnFactory;
import oracle.bali.dbUI.constraint.DCBooleanExpression;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilder;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.db.DataDescriptorProvider;
import oracle.bali.dbUI.db.Database;
import oracle.bali.dbUI.db.DynamicRelationship;
import oracle.bali.dbUI.db.OuterJoin;
import oracle.bali.dbUI.db.Relationship;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.db.impl.ColumnImpl;
import oracle.bali.dbUI.laf.DBUILookAndFeel;
import oracle.bali.dbUI.resultsTable.ModelFactory;
import oracle.bali.dbUI.resultsTable.ResultsTable;
import oracle.bali.dbUI.schemaViewer.SchemaViewer;
import oracle.bali.dbUI.schemaViewer.SchemaViewerEvent;
import oracle.bali.dbUI.schemaViewer.SchemaViewerListener;
import oracle.bali.dbUI.util.sql.SQLGenerator;
import oracle.bali.dbUI.viewBuilder.VBOuterJoinListener;
import oracle.bali.dbUI.viewBuilder.VBRelationshipListener;
import oracle.bali.dbUI.viewBuilder.ViewBuilder;
import oracle.bali.dbUI.viewBuilder.ViewBuilderEvent;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.table.TableEditListener;
import oracle.bali.ewt.table.TableEvent;
import oracle.bali.ewt.table.TableMoveListener;
import oracle.bali.ewt.table.TableResizeListener;
import oracle.bali.ewt.text.WrappedText;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.bali.ewt.util.StringUtils;
import oracle.bali.share.util.IntegerUtils;

public class QueryBuilder
extends LWComponent
implements Accessible {
    public static final String PROPERTY_SELECTED_COMPONENT = "selectedComponent";
    private static final int _INDEX_VIEW_BUILDER = 0;
    private static final int _INDEX_CONSTRAINT_BUILDER = 1;
    private static final int _INDEX_COLUMN_PROPERTY_EDITOR = 2;
    private static final int _INDEX_SQL = 3;
    private static final int _INDEX_RESULTS = 4;
    private static final String _KEY_VIEWBUILDER = "VIEWBUILDER";
    private static final String _KEY_CONSTRAINTBUILDER = "CONSTRAINTBUILDER";
    private static final String _KEY_COLUMNCOMPONENT = "COLUMNCOMPONENT";
    private static final String _KEY_SQL = "SQL";
    private static final String _KEY_RESULTS = "RESULTS";
    private static final String _KEY_SCHEMA_VIEWER_NAME = "SCHEMA_VIEWER_NAME";
    private static final String _KEY_TABLE_ALIAS = "QUERYBUILDER.TABLE_ALIAS";
    private ViewBuilder _viewBuilder;
    private boolean _viewBuilderDirty;
    private ConstraintBuilder _constraintBuilder;
    private boolean _constraintBuilderDirty;
    private DDProvider _dataDescriptorProvider;
    private ColumnPropertyEditor _columnComponent;
    private boolean _columnComponentDirty;
    private boolean _needToUpdateColumnComponent;
    private boolean _needToUpdateColumnComponentValues;
    private JScrollPane _sqlScrollBox;
    private JTextArea _codeEditor;
    private SQLGenerator _generator;
    private boolean _sqlDirty;
    private String _lastSQL;
    private ResultsTable _results;
    private boolean _resultsDirty;
    private boolean _needToUpdateResults;
    private JTabbedPane _tabPanel;
    private int _lastIndex = -1;
    private SchemaViewer _schemaViewer;
    private JSplitPane _splitter;

    public QueryBuilder() {
        this(null);
    }

    public QueryBuilder(Database database) {
        this(database, null);
    }

    public QueryBuilder(Database database, ModelFactory factory) {
        UIListener listener = new UIListener();
        this._schemaViewer = this.createSchemaViewer();
        this._schemaViewer.addSchemaViewerListener(listener);
        this._viewBuilder = this.createViewBuilder();
        this._viewBuilder.addPropertyChangeListener(listener);
        this._viewBuilder.addOuterJoinListener(listener);
        this._viewBuilder.addRelationshipListener(listener);
        this._viewBuilder.setTableAliasAllowed(true);
        this._constraintBuilder = this.createConstraintBuilder();
        this._constraintBuilder.addPropertyChangeListener(listener);
        this._dataDescriptorProvider = new DDProvider();
        this._columnComponent = this.createColumnPropertyEditor();
        this._columnComponent.setColumnFactory(VisualColumnFactory.getVisualColumnFactory());
        this._columnComponent.addPropertyChangeListener(listener);
        this._columnComponent.getPropertyTable().addEditListener(listener);
        this._columnComponent.getPropertyTable().addMoveListener(listener);
        this._results = this.createResultsTable();
        this._results.getSpreadTable().addResizeListener((TableResizeListener)listener);
        this._results.getSpreadTable().addMoveListener((TableMoveListener)listener);
        this._codeEditor = new JTextArea();
        this._codeEditor.getDocument().addDocumentListener(listener);
        this._codeEditor.setEditable(false);
        this._codeEditor.setLineWrap(true);
        this._codeEditor.setWrapStyleWord(true);
        this._sqlScrollBox = new JScrollPane(this._codeEditor);
        this._tabPanel = new JTabbedPane();
        this._tabPanel.addChangeListener(listener);
        this._tabPanel.add((Component)((Object)this._viewBuilder));
        this._tabPanel.add((Component)((Object)this._constraintBuilder));
        this._tabPanel.add((Component)((Object)this._columnComponent));
        this._tabPanel.add(this._sqlScrollBox);
        this._tabPanel.add((Component)((Object)this._results));
        this._splitter = new JSplitPane();
        this._splitter.setLeftComponent((Component)((Object)this._schemaViewer));
        this._splitter.setRightComponent(this._tabPanel);
        this._splitter.setContinuousLayout(false);
        this.setLayout(new BorderLayout());
        this.add("Center", this._splitter);
        this.setDatabase(database);
        this.setModelFactory(factory);
    }

    public void enableJDKDnD() {
        this._schemaViewer.enableJDKDnD();
        this._constraintBuilder.enableJDKDnD();
    }

    public void setDatabase(Database database) {
        this._schemaViewer.setDatabase(database);
        this._viewBuilder.setTables(null);
        this._constraintBuilder.setDataConstraint(null);
        this._needToUpdateColumnComponent = true;
        this._needToUpdateResults = true;
    }

    public Database getDatabase() {
        return this._schemaViewer.getDatabase();
    }

    public ViewBuilder getViewBuilder() {
        return this._viewBuilder;
    }

    public ConstraintBuilder getConstraintBuilder() {
        return this._constraintBuilder;
    }

    public ColumnPropertyEditor getColumnPropertyEditor() {
        this._updateColumnComponent();
        return this._columnComponent;
    }

    public ResultsTable getResultsTable() {
        this._updateResultsTable();
        return this._results;
    }

    public SchemaViewer getSchemaViewer() {
        return this._schemaViewer;
    }

    public final void setModelFactory(ModelFactory factory) {
        this.getResultsTable().setModelFactory(factory);
        this._tabPanel.setEnabledAt(4, factory != null);
    }

    public Component getSelectedComponent() {
        return this._tabPanel.getSelectedComponent();
    }

    public void setSelectedComponent(Component page) {
        if (page == this._viewBuilder) {
            this._tabPanel.setSelectedIndex(0);
        } else if (page == this._constraintBuilder) {
            this._tabPanel.setSelectedIndex(1);
        } else if (page == this._columnComponent) {
            this._tabPanel.setSelectedIndex(2);
        } else if (page == this._sqlScrollBox) {
            this._tabPanel.setSelectedIndex(3);
        } else if (page == this._results && this._tabPanel.isEnabledAt(4)) {
            this._tabPanel.setSelectedIndex(4);
        }
    }

    public void setSQLGenerator(SQLGenerator generator) {
        if (generator != this._generator) {
            this._generator = generator;
            if (this.getSelectedComponent() == this._sqlScrollBox) {
                this._updateSQLComponent();
            }
        }
    }

    public SQLGenerator getSQLGenerator() {
        if (this._generator == null) {
            this._generator = SQLGenerator.getSQLGenerator();
        }
        return this._generator;
    }

    public String getSQLString() {
        Column[] columns = null;
        if (!this._viewBuilderDirty) {
            ColumnWrapper[] wrappers = this.getColumnPropertyEditor().getColumnWrappers();
            columns = this._getColumns(wrappers);
        }
        if (columns == null) {
            columns = this.getViewBuilder().getSelectedColumns();
        }
        DataConstraint dc = this.getConstraintBuilder().getDataConstraint();
        Relationship[] joins = this.getViewBuilder().getIncludedRelationships();
        OuterJoin[] outerJoins = this.getViewBuilder().getOuterJoins();
        DataConstraint filter = this._results.getFilterDataConstraint();
        if (dc == null) {
            dc = filter;
        } else if (filter != null) {
            DataConstraint[] constraints = new DataConstraint[]{dc, filter};
            dc = new DCBooleanExpression(constraints, 1);
        }
        return this.getSQLGenerator().getSQLString(columns, dc, joins, outerJoins);
    }

    public void setSQLString(String sql) throws ParseException {
        throw new ParseException(sql, 0);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._viewBuilder.setEnabled(enabled);
        this._constraintBuilder.setEnabled(enabled);
        this._columnComponent.setEnabled(enabled);
        this._codeEditor.setEnabled(enabled);
        this._sqlScrollBox.setEnabled(enabled);
        this._results.setEnabled(enabled);
        this._tabPanel.setEnabled(enabled);
        this._splitter.setEnabled(enabled);
        this._schemaViewer.setEnabled(enabled);
    }

    protected ViewBuilder createViewBuilder() {
        return new ViewBuilder();
    }

    protected ConstraintBuilder createConstraintBuilder() {
        return new ConstraintBuilder();
    }

    protected ColumnPropertyEditor createColumnPropertyEditor() {
        return new ColumnPropertyEditor();
    }

    protected ResultsTable createResultsTable() {
        return new ResultsTable();
    }

    public SchemaViewer createSchemaViewer() {
        return new SchemaViewer();
    }

    public void addNotify() {
        super.addNotify();
        this._updateLabels(LocaleUtils.getDefaultableLocale((Component)((Object)this)));
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this._updateLabels(LocaleUtils.getDefaultableLocale((Component)((Object)this)));
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleQueryBuilder();
        }
        return this.accessibleContext;
    }

    boolean updatePage(int page) {
        int oldPage = this._lastIndex;
        this._lastIndex = page;
        if (oldPage == 0) {
            if (this._viewBuilderDirty) {
                this._needToUpdateColumnComponent = true;
                this._needToUpdateResults = true;
                this._viewBuilderDirty = false;
            }
        } else if (oldPage == 1) {
            if (this._constraintBuilderDirty) {
                this._needToUpdateResults = true;
                this._constraintBuilderDirty = false;
            }
        } else if (oldPage == 2) {
            if (this._columnComponentDirty) {
                this._needToUpdateResults = true;
                this._columnComponentDirty = false;
            }
        } else if (oldPage == 3) {
            if (this._sqlDirty) {
                String text = this._codeEditor.getText();
                if (this._lastSQL == null || !this._lastSQL.equals(text)) {
                    try {
                        this.setSQLString(text);
                    }
                    catch (ParseException e) {
                        return false;
                    }
                }
                this._sqlDirty = false;
            }
        } else if (oldPage == 4 && this._resultsDirty) {
            this._needToUpdateColumnComponentValues = true;
            this._resultsDirty = false;
        }
        if (page == 0) {
            this._updateViewBuilder();
        } else if (page == 1) {
            this._updateConstraintBuilder();
        } else if (page == 2) {
            this._updateColumnComponent();
        } else if (page == 3) {
            this._updateSQLComponent();
        } else if (page == 4) {
            this._updateResultsTable();
        }
        return true;
    }

    void tableSelected(Table table) {
        int index = this._tabPanel.getSelectedIndex();
        if (index == 0) {
            this.getViewBuilder().addTable(table, true);
        }
    }

    void columnSelected(Column column) {
        int index = this._tabPanel.getSelectedIndex();
        if (index == 0) {
            this.getViewBuilder().addTable(column.getTable(), true);
            this.getViewBuilder().setColumnSelected(column, true);
        } else if (index == 1) {
            this.getConstraintBuilder().addConstraintComponent(this.getConstraintBuilder().getConstraintCompFactory().createConstraintComponent(this._dataDescriptorProvider, column, null));
        }
    }

    private void _updateLabels(Locale newLocale) {
        ResourceBundle b = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", newLocale);
        String text = b.getString(_KEY_VIEWBUILDER);
        this._tabPanel.setTitleAt(0, StringUtils.stripMnemonic((String)text));
        text = b.getString(_KEY_CONSTRAINTBUILDER);
        this._tabPanel.setTitleAt(1, StringUtils.stripMnemonic((String)text));
        text = b.getString(_KEY_COLUMNCOMPONENT);
        this._tabPanel.setTitleAt(2, StringUtils.stripMnemonic((String)text));
        text = b.getString(_KEY_SQL);
        this._tabPanel.setTitleAt(3, StringUtils.stripMnemonic((String)text));
        text = b.getString(_KEY_RESULTS);
        this._tabPanel.setTitleAt(4, StringUtils.stripMnemonic((String)text));
    }

    private void _updateViewBuilder() {
    }

    private void _updateConstraintBuilder() {
        ConstraintBuilder builder = this.getConstraintBuilder();
        DataDescriptor[] columns = this.getViewBuilder().getSelectedColumns();
        int count = columns == null ? 0 : columns.length;
        this._dataDescriptorProvider.setDescriptors(columns);
        builder.setDataDescriptorProvider(this._dataDescriptorProvider);
        if (count != 0 && builder.getLeafCount() == 0) {
            builder.addConstraintComponent(builder.getConstraintCompFactory().createConstraintComponent(this._dataDescriptorProvider, null, null));
        }
    }

    private void _updateColumnComponent() {
        if (this._needToUpdateColumnComponent) {
            this._needToUpdateColumnComponent = false;
            Column[] columns = this.getViewBuilder().getSelectedColumns();
            ColumnPropertyEditor attrib = this.getColumnPropertyEditor();
            attrib.setColumns(columns);
        }
        if (this._needToUpdateColumnComponentValues) {
            this._needToUpdateColumnComponentValues = false;
            ColumnWrapper[] wrappers = this.getResultsTable().getColumnWrappers();
            System.out.println("todo: updated the contents of the column property editor");
        }
    }

    private void _updateSQLComponent() {
        String sql = this.getSQLString();
        JTextArea c = this._codeEditor.getSize().width <= 0 ? this._viewBuilder.getCanvas().getComponent() : this._codeEditor;
        sql = WrappedText.wrapText((String)sql, (Component)c);
        this._codeEditor.setText(sql);
        this._lastSQL = sql;
    }

    private void _updateResultsTable() {
        if (this._needToUpdateResults) {
            this._needToUpdateResults = false;
            ColumnPropertyEditor attrib = this.getColumnPropertyEditor();
            ColumnWrapper[] wrappers = attrib.getColumnWrappers();
            ViewBuilder builder = this.getViewBuilder();
            Relationship[] relationships = builder.getIncludedRelationships();
            DataConstraint constraint = this.getConstraintBuilder().getDataConstraint();
            OuterJoin[] outerJoins = builder.getOuterJoins();
            if (wrappers == null) {
                Column[] columns = builder.getSelectedColumns();
                wrappers = ColumnWrapper.getColumnWrappers(columns);
            }
            this.getResultsTable().setColumnWrappers(wrappers);
            this.getResultsTable().setRelationships(relationships);
            this.getResultsTable().setDataConstraint(constraint);
            this.getResultsTable().setOuterJoins(outerJoins);
            this.getResultsTable().updateResults();
        }
    }

    private Column[] _getColumns(ColumnWrapper[] wrappers) {
        if (wrappers == null || wrappers.length == 0) {
            return null;
        }
        int count = wrappers.length;
        Column[] columns = new Column[count];
        for (int i = 0; i < count; ++i) {
            String displayName;
            Column column = wrappers[i].getColumn();
            if (wrappers[i] instanceof VisualColumn) {
                VisualColumn vColumn = (VisualColumn)wrappers[i];
                displayName = vColumn.getDisplayName();
            } else {
                Locale locale = LocaleUtils.getDefaultableLocale((Component)((Object)this));
                displayName = column.getDisplayName(locale);
            }
            columns[i] = new ColumnImpl(column.getName(), displayName, column.getDataType(), column.getTable());
        }
        return columns;
    }

    private class UIListener
    implements ChangeListener,
    PropertyChangeListener,
    TableEditListener,
    TableMoveListener,
    TableResizeListener,
    SchemaViewerListener,
    VBRelationshipListener,
    VBOuterJoinListener,
    DocumentListener {
        private UIListener() {
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            DBUILookAndFeel.getLookAndFeel().setCursor((Component)((Object)QueryBuilder.this), true);
            int index = QueryBuilder.this._tabPanel.getSelectedIndex();
            if (!QueryBuilder.this.updatePage(index)) {
                // empty if block
            }
            DBUILookAndFeel.getLookAndFeel().setCursor((Component)((Object)QueryBuilder.this), false);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("dataConstraint".equals(name)) {
                QueryBuilder.this._constraintBuilderDirty = true;
            } else if ("_VISUAL_ORDER_CHANGED".equals(name)) {
                QueryBuilder.this._columnComponentDirty = true;
            } else if ("selectedColumns".equals(name)) {
                QueryBuilder.this._viewBuilderDirty = true;
            } else if ("includedRelationships".equals(name)) {
                QueryBuilder.this._viewBuilderDirty = true;
            } else if ("relationshipType".equals(name)) {
                QueryBuilder.this._viewBuilderDirty = true;
            }
            if (QueryBuilder.this._constraintBuilderDirty || QueryBuilder.this._columnComponentDirty || QueryBuilder.this._viewBuilderDirty) {
                QueryBuilder.this._results.cleanupResults();
            }
        }

        public void cellEditing(TableEvent e) {
        }

        public void cellEdited(TableEvent e) {
            QueryBuilder.this._columnComponentDirty = true;
        }

        public void columnResizing(TableEvent e) {
        }

        public void columnResized(TableEvent e) {
            if (e.getSource() == QueryBuilder.this._results.getSpreadTable()) {
                QueryBuilder.this._resultsDirty = true;
            }
        }

        public void rowResizing(TableEvent e) {
        }

        public void rowResized(TableEvent e) {
        }

        public void columnMoving(TableEvent e) {
        }

        public void columnMoved(TableEvent e) {
            if (e.getSource() == QueryBuilder.this._results.getSpreadTable()) {
                QueryBuilder.this._resultsDirty = true;
            }
        }

        public void rowMoving(TableEvent e) {
        }

        public void rowMoved(TableEvent e) {
            if (e.getSource() == QueryBuilder.this._columnComponent.getPropertyTable()) {
                QueryBuilder.this._columnComponentDirty = true;
            }
        }

        @Override
        public void tableActivated(SchemaViewerEvent e) {
            QueryBuilder.this.tableSelected(e.getTable());
        }

        @Override
        public void columnActivated(SchemaViewerEvent e) {
            QueryBuilder.this.columnSelected(e.getColumn());
        }

        @Override
        public void relationshipAdding(ViewBuilderEvent e) {
        }

        @Override
        public void relationshipAdded(ViewBuilderEvent e) {
            if (e.getRelationship() instanceof DynamicRelationship) {
                DynamicRelationship dr = (DynamicRelationship)e.getRelationship();
                dr.addPropertyChangeListener(this);
            }
        }

        @Override
        public void relationshipRemoving(ViewBuilderEvent e) {
        }

        @Override
        public void relationshipRemoved(ViewBuilderEvent e) {
            if (e.getRelationship() instanceof DynamicRelationship) {
                DynamicRelationship dr = (DynamicRelationship)e.getRelationship();
                dr.removePropertyChangeListener(this);
            }
        }

        @Override
        public void outerJoinAdded(ViewBuilderEvent e) {
            QueryBuilder.this._viewBuilderDirty = true;
        }

        @Override
        public void outerJoinRemoved(ViewBuilderEvent e) {
            QueryBuilder.this._viewBuilderDirty = true;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            QueryBuilder.this._sqlDirty = true;
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            QueryBuilder.this._sqlDirty = true;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }

    private class DDProvider
    implements DataDescriptorProvider {
        private DataDescriptor[] _descriptors;
        private PropertyChangeSupport _support;

        private DDProvider() {
        }

        @Override
        public int getDescriptorCount() {
            return this._descriptors == null ? 0 : this._descriptors.length;
        }

        public void setDescriptors(DataDescriptor[] descriptors) {
            int oldCount = this._descriptors == null ? 0 : this._descriptors.length;
            int count = descriptors == null ? 0 : descriptors.length;
            boolean descriptorChanged = false;
            descriptorChanged = oldCount == count && descriptors != null && this._descriptors != null ? !Arrays.equals(descriptors, this._descriptors) : true;
            this._descriptors = null;
            if (count != 0) {
                this._descriptors = new DataDescriptor[count];
                System.arraycopy(descriptors, 0, this._descriptors, 0, count);
            }
            this._fireEvent(oldCount, count);
            this._fireEvent(descriptorChanged);
        }

        @Override
        public DataDescriptor getDescriptor(int index) {
            return this._descriptors[index];
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            if (this._support == null) {
                this._support = new PropertyChangeSupport(this);
            }
            this._support.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            if (this._support != null) {
                this._support.removePropertyChangeListener(listener);
            }
        }

        private void _fireEvent(int oldCount, int newCount) {
            if (this._support != null) {
                this._support.firePropertyChange("descriptorCount", IntegerUtils.getInteger((int)oldCount), IntegerUtils.getInteger((int)newCount));
            }
        }

        private void _fireEvent(boolean descriptorChanged) {
            if (this._support != null) {
                this._support.firePropertyChange("descriptorChanged", false, descriptorChanged);
            }
        }
    }

    private class AccessibleQueryBuilder
    extends JComponent.AccessibleJComponent {
        public AccessibleQueryBuilder() {
            super((JComponent)((Object)QueryBuilder.this));
            AccessibleContext ac = QueryBuilder.this._schemaViewer.getAccessibleContext();
            ac.setAccessibleParent(QueryBuilder.this);
            ResourceBundle b = ResourceBundle.getBundle("oracle.bali.dbUI.resource.AccessibleBundle", LocaleUtils.getDefaultableLocale((Component)((Object)QueryBuilder.this)));
            String name = b.getString(QueryBuilder._KEY_SCHEMA_VIEWER_NAME);
            ac.setAccessibleName(name);
            ac = QueryBuilder.this._viewBuilder.getAccessibleContext();
            ac.setAccessibleParent(QueryBuilder.this);
            ac = QueryBuilder.this._constraintBuilder.getAccessibleContext();
            ac.setAccessibleParent(QueryBuilder.this);
            ac.setAccessibleName(QueryBuilder.this._tabPanel.getTitleAt(1));
            ac = QueryBuilder.this._columnComponent.getAccessibleContext();
            ac.setAccessibleParent(QueryBuilder.this);
            ac.setAccessibleName(QueryBuilder.this._tabPanel.getTitleAt(2));
            ac = QueryBuilder.this._codeEditor.getAccessibleContext();
            ac.setAccessibleParent(QueryBuilder.this);
            ac.setAccessibleName(QueryBuilder.this._tabPanel.getTitleAt(3));
            ac = QueryBuilder.this._results.getAccessibleContext();
            ac.setAccessibleParent(QueryBuilder.this);
            ac.setAccessibleName(QueryBuilder.this._tabPanel.getTitleAt(4));
        }
    }
}

