/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.propertyTable;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.KeyEvent;
import java.beans.PropertyDescriptor;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Locale;
import javax.swing.UIManager;
import oracle.bali.dbUI.propertyTable.PTModel;
import oracle.bali.dbUI.propertyTable.PTValidateEvent;
import oracle.bali.dbUI.propertyTable.PropertyTableCustomizer;
import oracle.bali.dbUI.propertyTable.PropertyTableEvent;
import oracle.bali.dbUI.propertyTable.PropertyTableListener;
import oracle.bali.dbUI.propertyTable.SortHandler;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.RowGroupingAppearance;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.header.HeaderKeyHandler;
import oracle.bali.ewt.header.StandardHeaderKeyHandler;
import oracle.bali.ewt.model.NullOneDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.sort.Comparator;

public class PropertyTable
extends SpreadTable {
    private PTModel _model = new PTModel(this);
    private PropertyTableCustomizer _customizer;
    private NullOneDModel _rowHeaderDS = new NullOneDModel(0);
    private Object[] _objects;
    private boolean _dirty;
    private ListenerManager _listeners;

    public PropertyTable() {
        this(null);
    }

    public PropertyTable(Object[] array) {
        super.setModels((TwoDModel)this._model, (OneDModel)this._model, (OneDModel)this._rowHeaderDS);
        super.setRowHeaderWidth(30);
        Grid grid = super.getGrid();
        grid.setGridSelectionManager(GeneralGridSelectionManager.getNullGridSelectionManager());
        grid.setDrawFocusCellHighlite(true);
        grid.setAppearanceManager((AppearanceManager)new Appear());
        Header h = super.getRowHeader();
        h.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        h = super.getColumnHeader();
        h.setHeaderKeyHandler((HeaderKeyHandler)new KeySort());
        h.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        h.setItemInputHandler((HeaderItemInputHandler)new SortHandler(this, this._model));
        this.setObjects(array);
    }

    public Object[] getObjects() {
        return this._model.getObjects();
    }

    public void setObjects(Object[] array) {
        this.freezeRepaints();
        if (array == null) {
            array = new Object[]{};
        }
        int newCount = array.length;
        this._objects = new Object[newCount];
        System.arraycopy(array, 0, this._objects, 0, newCount);
        Grid grid = super.getGrid();
        this._model.setObjects(this._objects);
        int oldCount = this._rowHeaderDS.getItemCount();
        int diff = newCount - oldCount;
        if (diff > 0) {
            this._rowHeaderDS.addItems(0, diff);
        } else {
            this._rowHeaderDS.removeItems(0, -diff);
        }
        if (newCount == 0) {
            this.unfreezeRepaints();
            return;
        }
        this._dirty = true;
        this._setUI();
        this.unfreezeRepaints();
    }

    public void setCustomizer(PropertyTableCustomizer customizer) {
        this._customizer = customizer;
        this._setUI();
    }

    public PropertyTableCustomizer getCustomizer() {
        if (this._customizer == null) {
            this._customizer = PropertyTableCustomizer.getPropertyTableCustomizer();
        }
        return this._customizer;
    }

    public PropertyDescriptor getPropertyAt(int index) {
        return this._model.getDescriptor(index);
    }

    public int getPropertyIndex(PropertyDescriptor desc) {
        return this._model.getIndex(desc);
    }

    public void sort(int index, boolean ascending) {
        if (!super.isColumnVisible(index)) {
            throw new IllegalArgumentException("Can't sort a hidden property");
        }
        this._model.sort(index, ascending);
    }

    public void addPropertyTableListener(PropertyTableListener l) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)l);
    }

    public void removePropertyTableListener(PropertyTableListener l) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)l);
        }
    }

    public void addNotify() {
        super.addNotify();
        this._setUI();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    protected void processEventImpl(AWTEvent e) {
        if (e instanceof PropertyTableEvent) {
            this.processPropertyTableEvent((PropertyTableEvent)e);
        } else {
            super.processEventImpl(e);
        }
    }

    protected void processPropertyTableEvent(PropertyTableEvent e) {
        if (this._listeners == null) {
            return;
        }
        Enumeration enumer = this._listeners.getListeners();
        if (enumer == null) {
            return;
        }
        int id = e.getID();
        switch (id) {
            case 2000: {
                while (enumer.hasMoreElements()) {
                    ((PropertyTableListener)enumer.nextElement()).columnSorting(e);
                }
                break;
            }
            case 2001: {
                while (enumer.hasMoreElements()) {
                    ((PropertyTableListener)enumer.nextElement()).columnSorted(e);
                }
                break;
            }
        }
    }

    String getPropertyDisplayName(PropertyDescriptor descriptor) {
        Locale locale = LocaleUtils.getDefaultableLocale((Component)((Object)this));
        return this.getCustomizer().getDisplayName(descriptor, locale);
    }

    boolean isBoolean(int index) {
        PropertyDescriptor desc = this.getPropertyAt(index);
        Class<?> type = desc.getPropertyType();
        return type == Boolean.TYPE || type == Boolean.class;
    }

    boolean fireCancelablePropertyTableEvent(int column) {
        int id = 2000;
        PTValidateEvent e = new PTValidateEvent(this, id, column);
        this.processEvent(e);
        return e.isCancelled();
    }

    void firePropertyTableEvent(int column) {
        int id = 2001;
        PropertyTableEvent e = new PropertyTableEvent(this, id, column);
        this.processEvent(e);
    }

    private void _setUI() {
        Font font = this.getFont();
        if (!this._dirty || font == null) {
            return;
        }
        this._dirty = false;
        this.freezeRepaints();
        FontMetrics metrics = this.getFontMetrics(font);
        Grid grid = super.getGrid();
        PropertyTableCustomizer custom = this.getCustomizer();
        int columnCount = grid.getColumnCount();
        Locale locale = LocaleUtils.getDefaultableLocale((Component)((Object)this));
        for (int i = 0; i < columnCount; ++i) {
            PropertyDescriptor desc = this.getPropertyAt(i);
            boolean visible = custom.displayProperty(desc);
            super.setColumnVisible(i, visible);
            if (!visible) continue;
            Comparator comp = custom.getComparator(desc);
            this._model.setComparator(i, comp);
            Painter painter = custom.getPainter(desc);
            grid.setColumnPainter(i, painter);
            CellInputHandler handler = custom.getCellInputHandler(desc);
            grid.setColumnCellInputHandler(i, handler);
            int width = custom.getColumnWidth(desc, metrics, locale);
            super.setColumnWidth(i, width);
        }
        int index = grid.getNextVisibleRow(-1);
        super.setFirstRowOnScreen(index);
        index = grid.getNextVisibleColumn(-1);
        super.setFirstColumnOnScreen(index);
        this.unfreezeRepaints();
    }

    private class Appear
    extends RowGroupingAppearance {
        private Appearance _a1;
        private Appearance _a2;

        public Appear() {
            Color color = UIManager.getColor("normalIntensity");
            if (color != null) {
                color = ColorUtils.lighterShadeColor((Color)color);
                this.setColor(color);
            }
            this.setRows(1);
        }

        public Appearance getCellPaintingAppearance(int column, int row) {
            Appearance a = super.getCellPaintingAppearance(column, row);
            if (PropertyTable.this.isBoolean(column)) {
                if (row % 2 == 0) {
                    if (this._a1 == null) {
                        this._a1 = a.copy();
                        this._a1.setBackground(UIManager.getColor("control"));
                    }
                    a = this._a1;
                } else {
                    if (this._a2 == null) {
                        this._a2 = a.copy();
                        this._a2.setBackground(UIManager.getColor("control"));
                    }
                    a = this._a2;
                }
            }
            return a;
        }
    }

    private class KeySort
    extends StandardHeaderKeyHandler {
        private KeySort() {
        }

        public void handleKeyEvent(Header header, KeyEvent e) {
            if (!e.isConsumed() && e.getKeyCode() == 32) {
                HeaderItemInputHandler handler;
                int focusItem;
                if (e.getID() == 401 && (focusItem = header.getFocusItem()) != -1 && (handler = header.getItemInputHandler()) instanceof SortHandler) {
                    ((SortHandler)handler).sort(focusItem);
                }
                e.consume();
            }
            super.handleKeyEvent(header, e);
        }
    }
}

