/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.header;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import oracle.bali.dbUI.constraint.DCBetweenExpression;
import oracle.bali.dbUI.constraint.DCComparisonExpression;
import oracle.bali.dbUI.constraint.DCConstant;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraintComponent.ConstraintComponent;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.button.PushButton;

class CBWindow
extends JInternalFrame
implements PropertyChangeListener {
    private static final String _ACTIVATE_KEY = "ACTIVATE";
    private static final String _OK_KEY = "OK";
    private static final String _CANCEL_KEY = "CANCEL";
    private static final String _FILTER_KEY = "FILTER";
    private boolean _between = false;
    private boolean _isNull = false;
    private JCheckBox _checkBox;
    private PushButton _ok;
    private PushButton _cancel;
    private ConstraintComponent _constraintComponent;
    private String _title;

    public CBWindow(ActionListener okListener, ActionListener cancelListener) {
        this.setClosable(false);
        this.setMaximizable(false);
        this.setIconifiable(false);
        this.setResizable(false);
        this._checkBox = new JCheckBox();
        this._ok = new PushButton("");
        this._ok.setDefaultCapable(true);
        this._ok.addActionListener(okListener);
        this._cancel = new PushButton("");
        this._cancel.addActionListener(cancelListener);
        KeyStroke s = KeyStroke.getKeyStroke(10, 0);
        this.registerKeyboardAction(okListener, s, 2);
        s = KeyStroke.getKeyStroke(27, 0);
        this.registerKeyboardAction(cancelListener, s, 2);
    }

    public boolean isConstraintActive() {
        return this._checkBox.isSelected();
    }

    public void setConstraintActive(boolean active) {
        this._checkBox.setSelected(active);
    }

    public DataConstraint getDataConstraint() {
        ConstraintComponent fc = this.getConstraintComponent();
        if (fc == null) {
            return null;
        }
        return fc.getDataConstraint();
    }

    public void setConstraintComponent(ConstraintComponent fc) {
        if (this._constraintComponent != null) {
            this._constraintComponent.removePropertyChangeListener(this);
        }
        this._constraintComponent = fc;
        if (this._constraintComponent != null) {
            this._constraintComponent.addPropertyChangeListener(this);
            this._setLayout();
        }
    }

    public ConstraintComponent getConstraintComponent() {
        return this._constraintComponent;
    }

    public void setWindowTitle(String title) {
        this._title = title;
    }

    @Override
    public void requestFocus() {
        this.getConstraintComponent().getComponent().requestFocus();
    }

    @Override
    public void setLocale(Locale l) {
        super.setLocale(l);
        this._setText(this.getLocale());
    }

    private void _setText(Locale locale) {
        ResourceBundle b = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", locale);
        this._checkBox.setText(b.getString(_ACTIVATE_KEY));
        this._ok.setLabel(b.getString(_OK_KEY));
        this._cancel.setLabel(b.getString(_CANCEL_KEY));
        if (this._title != null) {
            String temp = b.getString(_FILTER_KEY) + this._title;
            this.setTitle(temp);
        }
    }

    private void _setLayout() {
        Container p = this.getContentPane();
        p.setLayout(new BorderLayout(3, 3));
        Component c = this._constraintComponent.getComponent();
        JPanel constraintPanel = new JPanel(new BorderLayout(3, 3));
        constraintPanel.add("West", c);
        constraintPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        JPanel checkPanel = new JPanel(new BorderLayout(3, 3));
        checkPanel.add("West", this._checkBox);
        DialogButtonBar bb = new DialogButtonBar();
        bb.add((Component)this._ok, DialogButtonBar.CONSTRAINT_YES);
        bb.add((Component)this._cancel, DialogButtonBar.CONSTRAINT_CANCEL);
        JPanel top = new JPanel(new BorderLayout(3, 3));
        top.add("North", constraintPanel);
        top.add("South", checkPanel);
        JPanel bottom = new JPanel(new BorderLayout(3, 3));
        bottom.add("East", (Component)bb);
        p.add("North", top);
        p.add("South", bottom);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if ("dataConstraint".equals(name)) {
            DataConstraint dc = (DataConstraint)e.getNewValue();
            boolean between = dc instanceof DCBetweenExpression;
            boolean isNull = false;
            if (dc instanceof DCComparisonExpression) {
                DCComparisonExpression ce = (DCComparisonExpression)dc;
                boolean bl = isNull = ce.getConstraint(1) == DCConstant.getNullConstant();
            }
            if (between != this._between || isNull != this._isNull) {
                this._between = between;
                this._isNull = isNull;
                Component c = this.getConstraintComponent().getComponent();
                c.validate();
                this.pack();
            }
        }
    }
}

