/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.jle;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import oracle.bali.dbUI.graph.Edge;
import oracle.bali.dbUI.graph.Node;
import oracle.bali.dbUI.graph.Port;
import oracle.bali.dbUI.graph.jle.GraphCanvas;
import oracle.bali.dbUI.graph.jle.NodeGlassPane;
import oracle.bali.dbUI.graph.jle.PortLinkPort;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.item.AccessibleLayoutItem;
import oracle.bali.jle.item.LinkItem;
import oracle.bali.jle.item.LinkPort;
import oracle.bali.jle.item.LinkPortListener;
import oracle.bali.jle.tool.BoundsTool;

class EdgeLinkItem
extends LinkItem
implements PropertyChangeListener {
    private static final String _KEY_NAME = "EDGE.NAMED_LINK";
    private static final String _KEY_NONAME = "EDGE.UNNAMED_LINK";
    private PortLinkPort _source;
    private PortLinkPort _target;
    private Edge _edge;

    public EdgeLinkItem(PortLinkPort source, PortLinkPort dest, Edge edge) {
        this.enableJLEEvents(16L);
        this._source = source;
        this._target = dest;
        this._edge = edge;
        this.putProperty(NodeGlassPane.TOOLTIP_KEY, edge.getToolTipText());
        this._edge.addPropertyChangeListener(this);
    }

    public void setItemParent(LayoutItem parent) {
        super.setItemParent(parent);
        LinkPortListener[] listeners = this._source.getLinkPortListeners();
        if (listeners == null || listeners.length == 0) {
            this._source.addLinkPortListener((LinkPortListener)this);
            this._target.addLinkPortListener((LinkPortListener)this);
        }
    }

    public Edge getEdge() {
        return this._edge;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void setPorts(LinkPort[] ports) {
        throw new IllegalArgumentException("ports must be set in constructor");
    }

    public LinkPort[] getPorts() {
        LinkPort[] ports = new LinkPort[]{this._source, this._target};
        return ports;
    }

    public int getPortCount() {
        return 2;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("toolTipText".equals(e.getPropertyName())) {
            this.putProperty(NodeGlassPane.TOOLTIP_KEY, e.getNewValue());
        }
    }

    protected LinkPort[] updatePorts(LinkPort altered) {
        this.updateBounds();
        return this.getPorts();
    }

    protected AccessibleContext createAccessibleContext() {
        return new AccessibleLink();
    }

    protected void processMouseEvent(JLEEvent e) {
        if ((e.getID() == 501 || e.getID() == 502) && GraphCanvas.__isPopupTrigger(e)) {
            if (this.hitTest(e.getX(), e.getY())) {
                JLECanvas canvas;
                if (e.getID() == 502 && (canvas = this.getCanvas()) instanceof GraphCanvas) {
                    ((GraphCanvas)canvas).__showMenuForEdge(this.getEdge(), (LayoutItem)this, e.getX(), e.getY());
                }
                e.consume();
            } else {
                JLECanvas canvas = this.getCanvas();
                if (canvas instanceof GraphCanvas) {
                    ((GraphCanvas)canvas).__redispatchMouseEvent(e, (LayoutItem)this);
                }
            }
        }
        super.processMouseEvent(e);
    }

    private class AccessibleLink
    extends AccessibleLayoutItem {
        public AccessibleLink() {
            super((LayoutItem)EdgeLinkItem.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet s = super.getAccessibleStateSet();
            s.add(AccessibleState.FOCUSABLE);
            s.add(AccessibleState.SELECTABLE);
            if (BoundsTool.isSelected((LayoutItem)EdgeLinkItem.this)) {
                s.add(AccessibleState.SELECTED);
                if (EdgeLinkItem.this.getCanvas() != null && EdgeLinkItem.this.getCanvas().getGlassComponent().hasFocus()) {
                    s.add(AccessibleState.FOCUSED);
                }
            }
            if (EdgeLinkItem.this.getCanvas() != null) {
                if (EdgeLinkItem.this.getCanvas().isShowing()) {
                    s.add(AccessibleState.SHOWING);
                }
                if (EdgeLinkItem.this.getCanvas().isVisible()) {
                    s.add(AccessibleState.VISIBLE);
                }
            }
            return s;
        }

        public String getAccessibleName() {
            String s = super.getAccessibleName();
            if (s == null || "".equals(s)) {
                s = this._getAccessibleName(EdgeLinkItem.this.getEdge());
            }
            return s;
        }

        public String getAccessibleDescription() {
            String s = super.getAccessibleDescription();
            if (s == null || "".equals(s)) {
                s = this._getAccessibleDescription(EdgeLinkItem.this.getEdge());
            }
            return s;
        }

        private String _getAccessibleName(Edge e) {
            ResourceBundle b = ResourceBundle.getBundle("oracle.bali.dbUI.resource.GraphBundle", this.getLocale());
            String toolTip = e.getToolTipText();
            String key = toolTip != null && !"".equals(toolTip) ? EdgeLinkItem._KEY_NAME : EdgeLinkItem._KEY_NONAME;
            String text = b.getString(key);
            MessageFormat form = new MessageFormat(text);
            String from = this._getName(e.getSourcePort(0));
            String to = this._getName(e.getTargetPort(0));
            if (key == EdgeLinkItem._KEY_NAME) {
                Object[] args = new Object[]{toolTip, from, to};
                return form.format(args);
            }
            Object[] args = new Object[]{from, to};
            return form.format(args);
        }

        private String _getName(Port port) {
            Object s = port.getDisplayName(this.getLocale());
            for (Node n = port.getParent(); n != null; n = n.getParent()) {
                s = n.getDisplayName(this.getLocale()) + "." + (String)s;
            }
            return s;
        }

        private String _getAccessibleDescription(Edge e) {
            return this._getAccessibleName(e);
        }
    }
}

