/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintComponent;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import oracle.bali.dbUI.constraint.DCUnaryExpression;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraint.FreeFormDataConstraint;
import oracle.bali.dbUI.constraintComponent.ConstraintComponent;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.FixedBorderPainter;
import oracle.bali.ewt.painter.PaintContext;

public class FreeFormComponent
extends LWComponent
implements ConstraintComponent,
Accessible {
    private static BorderPainter _sBorderPainter;
    private static final int _DEFAULT_COLUMNS = 40;
    private DataDescriptor _descriptor;
    private JTextComponent _field;

    public FreeFormComponent() {
        this(40, 1);
    }

    public FreeFormComponent(int columns) {
        this(columns, 1);
    }

    public FreeFormComponent(int columns, int rows) {
        this._field = rows > 1 ? new JTextArea(null, columns, rows) : new JTextField(columns);
        this._field.addFocusListener(new A());
        this.setLayout(new BorderLayout(2, 2));
        this.add("Center", this._field);
        this.setBackground(UIManager.getColor("control"));
    }

    public String getText() {
        return this._field.getText();
    }

    public void setText(String text) {
        this._field.setText(text);
        this._field.setCaretPosition(this._field.getText().length());
        this.firePropertyChangeEvent();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public DataConstraint getDataConstraint() {
        return new FreeFormDataConstraint(this._field.getText());
    }

    @Override
    public DataDescriptor getDataDescriptor() {
        return this._descriptor;
    }

    @Override
    public void initState(DataDescriptor descriptor, DataConstraint dataConstraint) {
        this._descriptor = descriptor;
        if (dataConstraint == null) {
            this._field.setText(null);
            return;
        }
        boolean not = false;
        if (dataConstraint instanceof DCUnaryExpression) {
            dataConstraint = ((DCUnaryExpression)dataConstraint).getConstraint(0);
            not = true;
        }
        if (!(dataConstraint instanceof FreeFormDataConstraint)) {
            throw new IllegalArgumentException("dataConstraint must be a FreeFormDataConstraint");
        }
        Object s = ((FreeFormDataConstraint)dataConstraint).getString();
        if (not) {
            s = ((String)s).startsWith("NOT") ? ((String)s).substring(3) : "NOT " + (String)s;
        }
        this._field.setText((String)s);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){};
        }
        return this.accessibleContext;
    }

    public void requestFocus() {
        this._field.requestFocus();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._field.setEnabled(enabled);
    }

    public void paintComponent(Graphics g) {
        Dimension size = this.getSize();
        PaintContext context = this.getPaintContext();
        g.setColor(context.getPaintBackground());
        g.fillRect(0, 0, size.width, size.height);
    }

    public BorderPainter getBorderPainter() {
        if (_sBorderPainter == null) {
            _sBorderPainter = new FixedBorderPainter(1, 0, 1, 1);
        }
        return _sBorderPainter;
    }

    void firePropertyChangeEvent() {
        this.firePropertyChange("dataConstraint", null, this.getDataConstraint());
    }

    private class A
    extends FocusAdapter {
        private A() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            FreeFormComponent.this.firePropertyChangeEvent();
        }
    }
}

