/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintComponent;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.dbUI.constraint.DCBetweenExpression;
import oracle.bali.dbUI.constraint.DCComparisonExpression;
import oracle.bali.dbUI.constraint.DCConstant;
import oracle.bali.dbUI.constraint.DCExpression;
import oracle.bali.dbUI.constraint.DCUnaryExpression;
import oracle.bali.dbUI.constraint.DCVariable;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraintComponent.BaseLayoutManager;
import oracle.bali.dbUI.constraintComponent.ConstraintComponent;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.util.LocaleUtils;

public class BaseConstraintComponent
extends LWComponent
implements ConstraintComponent,
Accessible {
    private static final int _BASE_CONDITION = 1;
    public static final int CONDITION_EQUAL_TO = 1;
    public static final int CONDITION_NOT_EQUAL_TO = 2;
    public static final int CONDITION_IS_NULL = 3;
    public static final int CONDITION_IS_NOT_NULL = 4;
    public static final int CONDITION_BETWEEN = 5;
    public static final int CONDITION_NOT_BETWEEN = 6;
    protected static final int RESERVED_ID_MAX = 100;
    private static final String _EQUAL_KEY = "EQUAL";
    private static final String _NOT_EQUAL_KEY = "NOT_EQUAL";
    private static final String _BETWEEN_KEY = "BETWEEN";
    private static final String _NOT_BETWEEN_KEY = "NOT_BETWEEN";
    private static final String _NULL_KEY = "IS_NULL";
    private static final String _NOT_NULL_KEY = "IS_NOT_NULL";
    private static final String _AND_KEY = "AND";
    private static final int _EQUAL_INDEX = 0;
    private static final int _NOT_EQUAL_INDEX = 1;
    private static final int _NULL_INDEX = 2;
    private static final int _NOT_NULL_INDEX = 3;
    private static final int _BETWEEN_INDEX = 4;
    private static final int _NOT_BETWEEN_INDEX = 5;
    private static final int _DEFAULT_COUNT = 2;
    private static final int _NULL_COUNT = 2;
    private JComboBox _choice = new Choice();
    private Component _value = this.createValueComponent();
    private int _choiceWidth;
    private int _valueWidth;
    private LWComponent _between;
    private JLabel _label;
    private Component _betweenValue;
    private boolean _allowBetween;
    private DataDescriptor _descriptor;
    private DataConstraint _oldValue;

    public BaseConstraintComponent() {
        this.setLayout(new BaseLayoutManager());
        this.add("condition", this._choice);
        this.add("value", this._value);
        this._value.validate();
    }

    public void setBetweenAllowed(boolean allowIt) {
        if (allowIt != this._allowBetween) {
            this._allowBetween = allowIt;
            if (allowIt && this._between == null) {
                this._between = new LWComponent();
                this._between.setLayout((LayoutManager)new BorderLayout(2, 0));
                this._label = new JLabel(this.getBetweenLabel());
                this._betweenValue = this.createValueComponent();
                this._between.add("Center", (Component)this._label);
                this._between.add("East", this._betweenValue);
                this.add("between", (Component)this._between);
                this._between.setVisible(this.isBetween(this.getTestCondition()));
                this._betweenValue.validate();
                this.invalidate();
            } else if (!allowIt && this._between != null) {
                this._between.setVisible(false);
                this.invalidate();
            }
            this.updateChoiceValues(LocaleUtils.getDefaultableLocale((Component)((Object)this)));
        }
    }

    public boolean isBetweenAllowed() {
        return this._allowBetween;
    }

    public void setTestCondition(int condition) {
        if (!this.isConditionValid(condition)) {
            throw new IllegalArgumentException("condition " + condition + " is invalid.");
        }
        int index = this.convertConditionToSelection(condition);
        this._choice.setSelectedIndex(index);
        this.testConditionChanged(condition);
    }

    public int getTestCondition() {
        int index = this._choice.getSelectedIndex();
        return this.convertSelectionToCondition(index);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public DataConstraint getDataConstraint() {
        return this.getDataConstraint(this.getDataDescriptor(), this.getTestCondition());
    }

    @Override
    public DataDescriptor getDataDescriptor() {
        return this._descriptor;
    }

    @Override
    public void initState(DataDescriptor descriptor, DataConstraint dataConstraint) {
        boolean not = false;
        if (dataConstraint != null && dataConstraint instanceof DCUnaryExpression) {
            dataConstraint = ((DCUnaryExpression)dataConstraint).getConstraint(0);
            not = true;
        }
        this._descriptor = descriptor;
        this._oldValue = dataConstraint;
        this.updateChoiceValues(LocaleUtils.getDefaultableLocale((Component)((Object)this)));
        this.parseConstraint(dataConstraint);
        if (not) {
            this.setTestCondition(this.getNotCondition(this.getTestCondition()));
        }
        this.updateLayout();
    }

    public void requestFocus() {
        this._choice.requestFocus();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._choice.setEnabled(enabled);
        this.getValueComponent().setEnabled(enabled);
        if (this.isBetween(this.getTestCondition())) {
            this.getBetweenValueComponent().setEnabled(enabled);
        }
    }

    public int getConditionPreferredWidth() {
        return this._choice.getPreferredSize().width;
    }

    public void setConditionWidth(int width) {
        if (this._choiceWidth != width) {
            this._choiceWidth = width;
            this.invalidate();
        }
    }

    public int getConditionWidth() {
        if (this._choiceWidth == 0) {
            this._choiceWidth = this.getConditionPreferredWidth();
        }
        return this._choiceWidth;
    }

    public int getValuePreferredWidth() {
        Component value = this.getValueComponent();
        int width = 0;
        if (value.isVisible()) {
            width = this.getValueComponent().getPreferredSize().width;
            if (this.isBetween(this.getTestCondition())) {
                width += this._between.getPreferredSize().width;
            }
        }
        return width;
    }

    public void setValueWidth(int width) {
        if (this._valueWidth != width) {
            this._valueWidth = width;
            this.invalidate();
        }
    }

    public int getValueWidth() {
        if (this._valueWidth == 0) {
            this._valueWidth = this.getValuePreferredWidth();
        }
        return this._valueWidth;
    }

    public JComboBox getConditionComponent() {
        return this._choice;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){};
        }
        return this.accessibleContext;
    }

    protected void fireDataConstraintChanged(Object oldValue, Object newValue) {
        this.firePropertyChange("dataConstraint", oldValue, newValue);
    }

    protected Component createValueComponent() {
        JTextField field = new JTextField(10);
        field.getDocument().addDocumentListener(new Dirty());
        return field;
    }

    protected boolean isBetween(int condition) {
        return condition == 5 || condition == 6;
    }

    protected boolean isNull(int condition) {
        return condition == 3 || condition == 4;
    }

    protected boolean isNullAllowed() {
        DataDescriptor d = this.getDataDescriptor();
        return d == null ? false : d.isNullAllowed();
    }

    protected boolean isConditionValid(int condition) {
        if (condition == 1 || condition == 2) {
            return true;
        }
        if (this.isNullAllowed() && (condition == 3 || condition == 4)) {
            return true;
        }
        return this.isBetweenAllowed() && (condition == 5 || condition == 6);
    }

    protected int convertConditionToSelection(int condition) {
        int selection = -1;
        switch (condition) {
            case 1: {
                selection = 0;
                break;
            }
            case 2: {
                selection = 1;
                break;
            }
            case 3: {
                selection = this.getBaseNullIndex();
                break;
            }
            case 4: {
                selection = this.getBaseNullIndex() + 1;
                break;
            }
            case 5: {
                selection = this.getBaseBetweenIndex();
                break;
            }
            case 6: {
                selection = this.getBaseBetweenIndex() + 1;
                break;
            }
        }
        return selection;
    }

    protected int convertSelectionToCondition(int selection) {
        int cond = -1;
        if (selection == -1) {
            return cond;
        }
        switch (selection) {
            case 0: {
                cond = 1;
                break;
            }
            case 1: {
                cond = 2;
            }
        }
        int nullIndex = this.getBaseNullIndex();
        int betweenIndex = this.getBaseBetweenIndex();
        if (cond == -1) {
            if (this.isNullAllowed()) {
                if (selection == nullIndex) {
                    cond = 3;
                } else if (selection == nullIndex + 1) {
                    cond = 4;
                } else if (selection == betweenIndex) {
                    cond = 5;
                } else if (selection == betweenIndex + 1) {
                    cond = 6;
                }
            } else if (selection == betweenIndex) {
                cond = 5;
            } else if (selection == betweenIndex + 1) {
                cond = 6;
            }
        }
        return cond;
    }

    protected int getBaseBetweenIndex() {
        if (this.isNullAllowed()) {
            return 4;
        }
        return 2;
    }

    protected int getBaseNullIndex() {
        return 2;
    }

    protected int getItemCount() {
        int count = 2;
        boolean isNull = this.isNullAllowed();
        boolean between = this.isBetweenAllowed();
        if (isNull) {
            count += 2;
        }
        if (between) {
            count += 2;
        }
        return count;
    }

    protected String[] getChoiceValues(Locale locale) {
        ResourceBundle b = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", locale);
        int count = this.getItemCount();
        boolean isNull = this.isNullAllowed();
        boolean between = this.isBetweenAllowed();
        String[] strings = new String[count];
        strings[0] = b.getString(_EQUAL_KEY);
        strings[1] = b.getString(_NOT_EQUAL_KEY);
        if (isNull) {
            int nullIndex = this.getBaseNullIndex();
            strings[nullIndex] = b.getString(_NULL_KEY);
            strings[nullIndex + 1] = b.getString(_NOT_NULL_KEY);
        }
        if (between) {
            int index = this.getBaseBetweenIndex();
            strings[index] = b.getString(_BETWEEN_KEY);
            strings[index + 1] = b.getString(_NOT_BETWEEN_KEY);
        }
        return strings;
    }

    protected DataConstraint getDataConstraint(DataDescriptor d, int condition) {
        if (d == null) {
            return null;
        }
        DCExpression dc = null;
        DataConstraint value = this.getValueDataConstraint(this.getValueComponent(), d, condition);
        DataConstraint item = this.getItemDataConstraint(d, condition);
        switch (condition) {
            case 1: 
            case 3: {
                int operand = 3;
                dc = new DCComparisonExpression(item, value, operand);
                break;
            }
            case 2: 
            case 4: {
                int operand = 4;
                dc = new DCComparisonExpression(item, value, operand);
                break;
            }
            case 5: 
            case 6: {
                DataConstraint bValue = this.getBetweenValueDataConstraint(this.getBetweenValueComponent(), d, condition);
                int operand = condition == 5 ? 1 : 2;
                dc = new DCBetweenExpression(item, value, bValue, operand);
                break;
            }
        }
        return dc;
    }

    protected Component getValueComponent() {
        return this._value;
    }

    protected Component getBetweenValueComponent() {
        return this._betweenValue;
    }

    protected DataConstraint getBetweenValueDataConstraint(Component c, DataDescriptor d, int condition) {
        return this.getValueDataConstraint(c, d, condition);
    }

    protected DataConstraint getValueDataConstraint(Component c, DataDescriptor d, int condition) {
        if (this.isNull(condition)) {
            return DCConstant.getNullConstant();
        }
        if (c instanceof JTextField) {
            return new DCConstant(((JTextField)c).getText());
        }
        return null;
    }

    protected DataConstraint getItemDataConstraint(DataDescriptor d, int condition) {
        return d == null ? null : new DCVariable(d);
    }

    protected void parseConstraint(DataConstraint constraint) {
        if (constraint == null) {
            this.setTestCondition(1);
            this.initValueComponent(this.getValueComponent(), null);
            return;
        }
        if (constraint instanceof DCComparisonExpression) {
            DCComparisonExpression c = (DCComparisonExpression)constraint;
            int operand = c.getOperand();
            DCConstant value = this._getValue(c);
            Object realValue = value == null ? null : value.getValue();
            this.initValueComponent(this.getValueComponent(), realValue);
            boolean isNull = value == DCConstant.getNullConstant();
            int condition = this._convertOperandToCondition(operand, isNull);
            this.setTestCondition(condition);
        } else if (constraint instanceof DCBetweenExpression) {
            if (!this.isBetweenAllowed()) {
                throw new IllegalStateException("between is not allowed");
            }
            DCBetweenExpression c = (DCBetweenExpression)constraint;
            int operand = c.getOperand();
            DataConstraint temp = c.getFirstConstraint();
            DCConstant value = temp instanceof DCConstant ? (DCConstant)temp : null;
            Object realValue = value == null ? null : value.getValue();
            this.initValueComponent(this.getValueComponent(), realValue);
            temp = c.getSecondConstraint();
            value = temp instanceof DCConstant ? (DCConstant)temp : null;
            realValue = value == null ? null : value.getValue();
            this.initBetweenValueComponent(this.getBetweenValueComponent(), realValue);
            int condition = operand == 1 ? 5 : 6;
            this.setTestCondition(condition);
        } else {
            throw new IllegalArgumentException("Illegal DataConstraint " + constraint);
        }
    }

    protected int getNotCondition(int condition) {
        switch (condition) {
            case 1: {
                condition = 2;
                break;
            }
            case 2: {
                condition = 1;
                break;
            }
            case 3: {
                condition = 4;
                break;
            }
            case 4: {
                condition = 3;
                break;
            }
            case 5: {
                condition = 6;
                break;
            }
            case 6: {
                condition = 5;
                break;
            }
        }
        return condition;
    }

    protected void initValueComponent(Component c, Object value) {
        if (c instanceof JTextField) {
            String text = value == null ? null : value.toString();
            ((JTextField)c).setText(text);
        }
    }

    protected void initBetweenValueComponent(Component c, Object value) {
        this.initValueComponent(c, value);
    }

    protected String getBetweenLabel() {
        return this._getBetweenLabel(LocaleUtils.getDefaultableLocale((Component)((Object)this)));
    }

    protected void updateChoiceValues(Locale locale) {
        int index = this._choice.getSelectedIndex();
        this._choice.removeAllItems();
        String[] strings = this.getChoiceValues(locale);
        for (int i = 0; i < strings.length; ++i) {
            this._choice.addItem(strings[i]);
        }
        if (index != -1 && index < strings.length) {
            int condition = this.convertSelectionToCondition(index);
            this.testConditionChanged(condition);
        }
    }

    protected void testConditionChanged(int condition) {
        this._valueWidth = 0;
        this.invalidate();
    }

    protected void dataConstraintChanged() {
        DataConstraint newValue = this.getDataConstraint();
        DataConstraint oldValue = this._oldValue;
        this.fireDataConstraintChanged(oldValue, newValue);
        this._oldValue = newValue;
    }

    void updateLayout() {
        int condition = this.getTestCondition();
        boolean betweenVisible = this.isBetween(condition);
        boolean invalidate = false;
        if (this._between != null && this._between.isVisible() != betweenVisible) {
            this._between.setVisible(betweenVisible);
            this._valueWidth = 0;
            invalidate = true;
        }
        boolean valueVisible = !this.isNull(condition);
        Component value = this.getValueComponent();
        if (value.isVisible() != valueVisible) {
            value.setVisible(valueVisible);
            this._valueWidth = 0;
        }
        if (invalidate) {
            this.invalidate();
        }
    }

    private String _getBetweenLabel(Locale l) {
        ResourceBundle b = ResourceBundle.getBundle("oracle.bali.dbUI.resource.DBUIBundle", l);
        return b.getString(_AND_KEY);
    }

    private int _convertOperandToCondition(int operand, boolean isNull) {
        int condition = -1;
        condition = isNull ? (operand == 3 ? 3 : 4) : (operand == 3 ? 1 : 2);
        return condition;
    }

    private DCConstant _getValue(DCComparisonExpression e) {
        DataConstraint d1 = e.getConstraint(0);
        DataConstraint d2 = e.getConstraint(1);
        if (d1 instanceof DCConstant) {
            return (DCConstant)d1;
        }
        if (d2 instanceof DCConstant) {
            return (DCConstant)d2;
        }
        return null;
    }

    private class Choice
    extends JComboBox
    implements ItemListener {
        public Choice() {
            this.setEditable(false);
            this.addItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                BaseConstraintComponent.this.updateLayout();
                BaseConstraintComponent.this.dataConstraintChanged();
                int selection = this.getSelectedIndex();
                BaseConstraintComponent.this.testConditionChanged(BaseConstraintComponent.this.convertSelectionToCondition(selection));
            }
        }
    }

    private class Dirty
    implements DocumentListener {
        private Dirty() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            BaseConstraintComponent.this.dataConstraintChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            BaseConstraintComponent.this.dataConstraintChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            BaseConstraintComponent.this.dataConstraintChanged();
        }
    }
}

