/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.constraintBuilder;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import oracle.bali.dbUI.constraint.DCUnaryExpression;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraintBuilder.CBCompArray;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilder;
import oracle.bali.dbUI.constraintBuilder.ConstraintBuilderComp;
import oracle.bali.dbUI.constraintBuilder.DCJDKDragDropSupport;
import oracle.bali.dbUI.constraintBuilder.ParentComponent;
import oracle.bali.dbUI.constraintComponent.ConstraintComponent;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.dnd.DBUIDataFlavors;
import oracle.bali.dbUI.laf.DBUILookAndFeel;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.dnd.DragGestureEvent;
import oracle.bali.ewt.dnd.DragGestureListener;
import oracle.bali.ewt.dnd.DragGestureRecognizer;
import oracle.bali.ewt.dnd.DragSource;
import oracle.bali.ewt.dnd.DragSourceDragEvent;
import oracle.bali.ewt.dnd.DragSourceDropEvent;
import oracle.bali.ewt.dnd.DragSourceEvent;
import oracle.bali.ewt.dnd.DragSourceListener;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetContext;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;
import oracle.bali.ewt.dnd.JFCSupport;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.share.datatransfer.TransferUtils;

public class DragComponent
extends ConstraintBuilderComp
implements DragSourceListener,
DropTargetListener {
    static final ImmInsets _FOCUS_INSETS = DBUILookAndFeel.getLookAndFeel().getFocusPainter(null).getInsets(null);
    protected static final int GRAB_WIDTH = 10;
    protected static final int GRAB_HEIGHT = 10;
    private ConstraintComponent _constraintComponent;
    private ParentComponent _parentComponent;
    private Component _child;
    private boolean _dropping;
    private boolean _replacing;
    private boolean _isDragging;
    private boolean _jdkDnD;
    private DragGestureRecognizer _childDragGestureRecognizer;
    private DragGestureListener _chilDragGestureListener;
    private DragGestureRecognizer _recognizer;
    private DragGestureListener _listener;
    private DCJDKDragDropSupport _dragDropSupport;

    private DragComponent() {
    }

    public DragComponent(ConstraintComponent constraintComp) {
        this._constraintComponent = constraintComp;
        this.setLayout(null);
        this._child = constraintComp.getComponent();
        this._listener = new StartDrag(false);
        this._recognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer((Component)((Object)this), 2, this._listener);
        this._setChild(this._child);
        this._addDropTarget(this);
        this.enableEvents(60L);
    }

    public DragComponent(ParentComponent parent, LWComponent child) {
        this._parentComponent = parent;
        this.setLayout(null);
        this._child = child;
        this._listener = new StartDrag(false);
        this._recognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer((Component)((Object)this), 2, this._listener);
        this._setChild((Component)child);
        this.enableEvents(48L);
    }

    @Override
    public void performNot() {
        ConstraintComponent child = this.getConstraintComponent();
        if (child != null) {
            DCUnaryExpression e = new DCUnaryExpression(child.getDataConstraint(), 1);
            child.initState(child.getDataDescriptor(), e);
        }
    }

    public ConstraintComponent getConstraintComponent() {
        return this._constraintComponent;
    }

    public void enableJDKDnD() {
        if (!this._jdkDnD) {
            this._jdkDnD = true;
            if (this._childDragGestureRecognizer != null) {
                this._childDragGestureRecognizer.setComponent(null);
                this._childDragGestureRecognizer.removeDragGestureListener(this._chilDragGestureListener);
                this._childDragGestureRecognizer = null;
            }
            if (this._recognizer != null) {
                this._recognizer.setComponent(null);
                this._recognizer.removeDragGestureListener(this._listener);
                this._recognizer = null;
            }
            if (this._constraintComponent != null) {
                this._removeDropTarget(this);
            }
            this._dragDropSupport = new DCJDKDragDropSupport(this, this._child);
        }
    }

    public ParentComponent getWrappedParentComponent() {
        return this._parentComponent;
    }

    @Override
    public DataConstraint getDataConstraint() {
        if (this.getConstraintComponent() != null) {
            return this.getConstraintComponent().getDataConstraint();
        }
        return this.getWrappedParentComponent().getDataConstraint();
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.repaint();
    }

    public void setDropping(boolean dropping) {
        if (!this._jdkDnD) {
            if (this._dropping != dropping) {
                this._dropping = dropping;
                Color c = this._dropping ? this.getConstraintBuilder().DROP_FEEDBACK_COLOR : this.getUIDefaults().getColor("control");
                this.getChild().setBackground(c);
                this.repaint();
            }
        } else {
            this._dragDropSupport.__setDropping(dropping);
        }
    }

    public boolean isDropping() {
        if (!this._jdkDnD) {
            return this._dropping;
        }
        return this._dragDropSupport.__isDropping();
    }

    public void setReplacing(boolean replacing) {
        if (!this._jdkDnD) {
            if (this._replacing != replacing) {
                this._replacing = replacing;
                Color c = this._replacing ? this.getConstraintBuilder().DROP_REPLACE_FEEDBACK_COLOR : this.getUIDefaults().getColor("control");
                this.getChild().setBackground(c);
                this.repaint();
            }
        } else {
            this._dragDropSupport.__setReplacing(replacing);
        }
    }

    public boolean isReplacing() {
        if (!this._jdkDnD) {
            return this._replacing;
        }
        return this._dragDropSupport.__isReplacing();
    }

    public boolean isFocusTraversable() {
        return this.getWrappedParentComponent() == null;
    }

    @Override
    public Component getFocusComponent() {
        return this;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Component child = this.getChild();
        child.setEnabled(enabled);
        UIDefaults defaults = this.getUIDefaults();
        if (!this.isEnabled()) {
            child.setBackground(defaults.getColor("lightIntensity"));
        } else {
            child.setBackground(defaults.getColor("control"));
        }
    }

    public void paintComponent(Graphics g) {
        ConstraintBuilder builder = this.getConstraintBuilder();
        int x = DragComponent._FOCUS_INSETS.left;
        int y = DragComponent._FOCUS_INSETS.top;
        Dimension d = this.getSize();
        PaintContext context = this.getPaintContext();
        BorderPainter painter = DBUILookAndFeel.getLookAndFeel().getRaisedBorderPainter(null);
        painter.paint(context, g, x, y, d.width - (DragComponent._FOCUS_INSETS.left + DragComponent._FOCUS_INSETS.right), d.height - (DragComponent._FOCUS_INSETS.top + DragComponent._FOCUS_INSETS.bottom));
        ImmInsets insets = painter.getInsets(context);
        x += insets.left;
        y += insets.top;
        d.width -= insets.left + insets.right + DragComponent._FOCUS_INSETS.left + DragComponent._FOCUS_INSETS.right;
        d.height -= insets.top + insets.bottom + DragComponent._FOCUS_INSETS.top + DragComponent._FOCUS_INSETS.bottom;
        Color savedColor = g.getColor();
        UIDefaults defaults = context.getPaintUIDefaults();
        if (!this.isEnabled()) {
            g.setColor(defaults.getColor("lightIntensity"));
        } else if (this.isReplacing()) {
            g.setColor(builder.DROP_REPLACE_FEEDBACK_COLOR);
        } else if (this.isDropping()) {
            g.setColor(builder.DROP_FEEDBACK_COLOR);
        } else if (this.isSelected()) {
            g.setColor(this.getSelectionColor());
        } else {
            g.setColor(defaults.getColor("control"));
        }
        g.fillRect(x, y, 10, d.height);
        int x1 = x + 5;
        int y1 = y + d.height / 2;
        Color c = Color.white;
        g.setColor(c);
        g.drawLine(x1, y1 - 2, x1, y1 - 2);
        g.setColor(Color.black);
        g.drawLine(x1 + 1, y1 - 2, x1 + 1, y1 - 2);
        g.drawLine(x1, y1 - 1, x1 + 1, y1 - 1);
        g.setColor(c);
        g.drawLine(x1, y1 + 2, x1, y1 + 2);
        g.setColor(Color.black);
        g.drawLine(x1, y1 + 3, x1 + 1, y1 + 3);
        g.drawLine(x1 + 1, y1 + 2, x1 + 1, y1 + 2);
        if (this.hasFocus()) {
            Dimension realSize = this.getSize();
            BorderPainter p = DBUILookAndFeel.getLookAndFeel().getFocusPainter(null);
            p.paint(context, g, 0, 0, realSize.width, realSize.height - 1);
        }
        if (savedColor != null) {
            g.setColor(savedColor);
        }
    }

    public Dimension getMinimumSize() {
        Component child = this.getChild();
        Dimension d = new Dimension(10, 10);
        Dimension minSize = child.getMinimumSize();
        d.width += minSize.width;
        if (minSize.height > d.height) {
            d.height = minSize.height;
        }
        BorderPainter painter = DBUILookAndFeel.getLookAndFeel().getRaisedBorderPainter(null);
        ImmInsets insets = painter.getInsets(this.getPaintContext());
        d.width += insets.left + insets.right + DragComponent._FOCUS_INSETS.left + DragComponent._FOCUS_INSETS.right;
        d.height += insets.top + insets.bottom + DragComponent._FOCUS_INSETS.top + DragComponent._FOCUS_INSETS.bottom;
        return d;
    }

    public Dimension getPreferredSize() {
        Component child = this.getChild();
        Dimension d = new Dimension(10, 10);
        Dimension prefSize = child.getPreferredSize();
        if (this.getConstraintComponent() != null) {
            int leafWidth = this.getLeafWidth();
            prefSize.width = Math.max(leafWidth, prefSize.width);
        }
        d.width += prefSize.width;
        if (prefSize.height > d.height) {
            d.height = prefSize.height;
        }
        BorderPainter painter = DBUILookAndFeel.getLookAndFeel().getRaisedBorderPainter(null);
        ImmInsets insets = painter.getInsets(this.getPaintContext());
        d.width += insets.left + insets.right + DragComponent._FOCUS_INSETS.left + DragComponent._FOCUS_INSETS.right;
        d.height += insets.top + insets.bottom + DragComponent._FOCUS_INSETS.top + DragComponent._FOCUS_INSETS.bottom;
        return d;
    }

    public static int getGroupWidth(PaintContext context) {
        Font font = context.getPaintFont();
        if (font == null) {
            return -1;
        }
        FontMetrics metrics = context.getFontMetrics(font);
        BorderPainter painter = DBUILookAndFeel.getLookAndFeel().getRaisedBorderPainter(null);
        ImmInsets insets = painter.getInsets(context);
        return 10 + insets.left + insets.right + 2 + 25 + metrics.stringWidth("NOT AND");
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void doLayout() {
        Component child = this.getChild();
        BorderPainter painter = DBUILookAndFeel.getLookAndFeel().getRaisedBorderPainter(null);
        ImmInsets insets = painter.getInsets(this.getPaintContext());
        Dimension d = this.getSize();
        int x = insets.left + 10 + DragComponent._FOCUS_INSETS.left;
        int y = insets.top + DragComponent._FOCUS_INSETS.top;
        int width = d.width - (insets.left + insets.right + 10 + DragComponent._FOCUS_INSETS.left + DragComponent._FOCUS_INSETS.right);
        int height = d.height - (insets.top + insets.bottom + DragComponent._FOCUS_INSETS.top + DragComponent._FOCUS_INSETS.bottom);
        child.setBounds(x, y, width, height);
    }

    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        this.repaint();
    }

    protected void processKeyEvent(KeyEvent e) {
        ConstraintBuilder builder = this.getConstraintBuilder();
        super.processKeyEvent(e);
        if (e.isConsumed() || builder != null && !builder.isEnabled()) {
            return;
        }
        if (e.getID() == 401 && e.getKeyCode() == 121 && (e.getModifiers() & 1) != 0) {
            this._showMenu(0, 0);
            e.consume();
        } else if (e.getID() == 401 && e.getKeyCode() == 9 && this.hasFocus()) {
            if (e.isShiftDown()) {
                ParentComponent parent = this.getParentComponent();
                if (parent.getIndex(this) == 0) {
                    parent.requestFocus();
                    e.consume();
                }
            } else {
                ParentComponent p = this.getWrappedParentComponent();
                if (p != null) {
                    p.getFocusComponent().requestFocus();
                } else {
                    this.getChild().requestFocus();
                }
                e.consume();
            }
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        int y;
        ConstraintBuilder builder = this.getConstraintBuilder();
        super.processMouseEvent(e);
        if (e.isConsumed() || builder != null && !builder.isEnabled()) {
            return;
        }
        int x = e.getX();
        if (!this.contains(x, y = e.getY())) {
            return;
        }
        boolean consume = false;
        int id = e.getID();
        if (e.isPopupTrigger()) {
            this._showMenu(x, y);
            consume = true;
        } else if (id == 501) {
            this.trySelection(e);
            consume = true;
        }
        if (consume) {
            e.consume();
        }
    }

    protected Color getSelectionColor() {
        return this.getConstraintBuilder().SELECTION_COLOR;
    }

    protected Component getChild() {
        Component child = null;
        if (this.getComponentCount() != 0) {
            child = this.getComponent(0);
        }
        return child;
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public void dragExit(DragSourceEvent dsde) {
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        this._isDragging = false;
        this.getConstraintBuilder().setDragging(this, false);
    }

    @Override
    public boolean isDragging() {
        if (!this._jdkDnD) {
            return this._isDragging;
        }
        return this._dragDropSupport.__isDragging();
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        if (this._acceptDrag(dtde)) {
            this.setReplacing(true);
        } else {
            dtde.rejectDrag();
        }
    }

    public void dragOver(DropTargetDragEvent dtde) {
        if (!this._acceptDrag(dtde)) {
            dtde.rejectDrag();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dtde) {
        this.setReplacing(false);
    }

    public void drop(DropTargetDropEvent dtde) {
        this.setReplacing(false);
        DropTargetContext context = dtde.getDropTargetContext();
        if (!this._acceptDrop(dtde)) {
            context.dropComplete(false);
            return;
        }
        dtde.acceptDrop(2);
        Transferable transfer = dtde.getTransferable();
        Object data = null;
        if (transfer.isDataFlavorSupported(DBUIDataFlavors.DATA_DESCRIPTOR_FLAVOR)) {
            DataDescriptor dd;
            try {
                data = transfer.getTransferData(DBUIDataFlavors.DATA_DESCRIPTOR_FLAVOR);
            }
            catch (IOException ioe) {
                data = null;
            }
            catch (UnsupportedFlavorException ufe) {
                data = null;
            }
            if (data instanceof DataDescriptor && (dd = (DataDescriptor)data) != null) {
                context.dropComplete(true);
                ConstraintComponent cc = this.getConstraintBuilder().createConstraintComponent(dd);
                this.getConstraintBuilder().replaceConstraintBuilderComp(cc, (ConstraintBuilderComp)this);
            }
        }
        if (data == null && transfer.isDataFlavorSupported(DBUIDataFlavors.CONSTRAINT_COMPONENT_FLAVOR)) {
            ConstraintComponent cc;
            try {
                data = transfer.getTransferData(DBUIDataFlavors.CONSTRAINT_COMPONENT_FLAVOR);
            }
            catch (IOException ioe) {
                data = null;
            }
            catch (UnsupportedFlavorException ufe) {
                data = null;
            }
            if (data instanceof ConstraintComponent && (cc = (ConstraintComponent)data) != null) {
                context.dropComplete(true);
                this.getConstraintBuilder().replaceConstraintBuilderComp(cc, (ConstraintBuilderComp)this);
            }
        }
        if (data == null && transfer.isDataFlavorSupported(CBCompArray.CB_COMP_ARRAY_FLAVOR)) {
            ConstraintBuilderComp[] array;
            try {
                data = transfer.getTransferData(CBCompArray.CB_COMP_ARRAY_FLAVOR);
            }
            catch (IOException ioe) {
                data = null;
            }
            catch (UnsupportedFlavorException ufe) {
                data = null;
            }
            if (data instanceof CBCompArray && (array = ((CBCompArray)data).getData()) != null) {
                context.dropComplete(true);
                for (int i = 0; i < array.length; ++i) {
                    if (array[i] != this) continue;
                    return;
                }
                this.getConstraintBuilder().replaceConstraintBuilderComp(array, (ConstraintBuilderComp)this);
            }
        }
    }

    @Override
    protected int getAccessActionCount() {
        return 5;
    }

    @Override
    protected String getAccessActionDescription(int i) {
        switch (i) {
            case 0: {
                return this.getTranslatedAccessibleString("TOGGLE_SELECT");
            }
            case 1: {
                return this.getTranslatedAccessibleString("PERFORM_NOT");
            }
            case 2: {
                return this.getTranslatedAccessibleString("CREATE_AND");
            }
            case 3: {
                return this.getTranslatedAccessibleString("CREATE_OR");
            }
            case 4: {
                return this.getTranslatedAccessibleString("DELETE");
            }
        }
        return null;
    }

    @Override
    protected boolean doAccessAction(int i) {
        switch (i) {
            case 0: {
                boolean selected;
                boolean bl = selected = !this.isSelected();
                if (selected) {
                    this.getConstraintBuilder().addToSelection(this, false);
                } else {
                    this.getConstraintBuilder().removeFromSelection(this, false);
                }
                return true;
            }
            case 1: {
                this.performNot();
                return true;
            }
            case 2: {
                this.getConstraintBuilder().setSelection(this);
                this.getConstraintBuilder().performCreateAndOr(true, false);
                return true;
            }
            case 3: {
                this.getConstraintBuilder().setSelection(this);
                this.getConstraintBuilder().performCreateAndOr(false, false);
                return true;
            }
            case 4: {
                this.getConstraintBuilder().setSelection(this);
                this.getConstraintBuilder().deleteSelectedComponents();
                return true;
            }
        }
        return false;
    }

    void tryDrag(DragGestureEvent e, boolean isChild) {
        ConstraintBuilderComp dragComp = this._getCBComponent();
        ConstraintBuilder builder = this.getConstraintBuilder();
        if (builder.canDrag(dragComp) && !this._isDragging) {
            if (!dragComp.isSelected()) {
                builder.setSelection(dragComp);
                builder.paintImmediateInterior();
            }
            Point offset = e.getDragOrigin();
            offset.x = 5;
            offset.y = -offset.y;
            if (dragComp instanceof ParentComponent) {
                offset.y -= this.getLocation().y;
                if (isChild) {
                    offset.y -= this.getChild().getLocation().y;
                }
            }
            this._isDragging = true;
            e.startDrag(DragSource.DefaultMoveDrop, builder.getDragImage(), offset, builder.getDragTransferable(), (DragSourceListener)this);
            builder.setDragging(this, this._isDragging);
        }
    }

    void trySelection(MouseEvent e) {
        ConstraintBuilderComp comp = this._getCBComponent();
        ConstraintBuilder builder = this.getConstraintBuilder();
        if (e.isShiftDown()) {
            builder.addToSelection(comp);
        } else if (e.isControlDown()) {
            builder.toggleSelection(comp);
        } else if (!builder.isSelected(comp)) {
            builder.setSelection(comp);
        }
        comp.requestDBUIFocus(false);
    }

    void childMouseEvent(MouseEvent e) {
        ConstraintBuilder builder = this.getConstraintBuilder();
        if (e.isConsumed() || !builder.isEnabled()) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        Component comp = this.getChild();
        if (!comp.contains(x, y)) {
            return;
        }
        boolean consume = false;
        if (e.isPopupTrigger()) {
            Point p = comp.getLocation();
            this._showMenu(x += p.x, y += p.y);
            consume = true;
        } else if (e.getID() == 501) {
            this.trySelection(e);
            consume = true;
        }
        if (consume) {
            e.consume();
        }
    }

    int getBorderWidth() {
        int width = 10;
        BorderPainter painter = DBUILookAndFeel.getLookAndFeel().getRaisedBorderPainter(null);
        ImmInsets insets = painter.getInsets(this.getPaintContext());
        return width += insets.left + insets.right;
    }

    private boolean _acceptDrag(DropTargetDragEvent dtde) {
        if (!this.isEnabled()) {
            return false;
        }
        for (ParentComponent parent = this.getParentComponent(); parent != null; parent = parent.getParentComponent()) {
            if (!parent.isDragging()) continue;
            return false;
        }
        DataFlavor[] flavors = dtde.getCurrentDataFlavors();
        if (flavors == null) {
            return false;
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (TransferUtils.supportsDataFlavor((DataFlavor)flavors[i], (DataFlavor)DBUIDataFlavors.DATA_DESCRIPTOR_FLAVOR)) {
                return true;
            }
            if (TransferUtils.supportsDataFlavor((DataFlavor)flavors[i], (DataFlavor)DBUIDataFlavors.CONSTRAINT_COMPONENT_FLAVOR)) {
                return true;
            }
            if (!CBCompArray.CB_COMP_ARRAY_FLAVOR.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }

    private boolean _acceptDrop(DropTargetDropEvent e) {
        if (!this.isEnabled()) {
            return false;
        }
        for (ParentComponent parent = this.getParentComponent(); parent != null; parent = parent.getParentComponent()) {
            if (!parent.isDragging()) continue;
            return false;
        }
        return true;
    }

    private void _showMenu(int x, int y) {
        ConstraintBuilderComp comp = this._getCBComponent();
        if (comp instanceof ParentComponent) {
            Point offset = this.getLocation();
            x += offset.x;
            y += offset.y;
        }
        this.getConstraintBuilder().showMenu(comp, x, y);
    }

    private void _setChild(Component child) {
        this.add(child);
        this._chilDragGestureListener = new StartDrag(true);
        this._childDragGestureRecognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(child, 2, this._chilDragGestureListener);
        child.addMouseListener(new Mouser());
        if (this.getWrappedParentComponent() == null) {
            ChildSelect listener = new ChildSelect();
            if (child instanceof Container) {
                this._addMouseListener((Container)child, listener);
            }
        }
    }

    private ConstraintBuilderComp _getCBComponent() {
        if (this.getConstraintComponent() != null) {
            return this;
        }
        return this.getWrappedParentComponent();
    }

    private void _addMouseListener(Container parent, MouseListener l) {
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component child = parent.getComponent(i);
            child.addMouseListener(l);
            if (!(child instanceof Container)) continue;
            this._addMouseListener((Container)child, l);
        }
    }

    private void _addDropTarget(LWComponent comp) {
        if (JFCSupport.getEWTDropTarget((JComponent)comp) != null) {
            return;
        }
        DropTarget dummy = new DropTarget((Component)comp, (DropTargetListener)this);
        int count = comp.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component child = comp.getComponent(i);
            if (!(child instanceof LWComponent)) continue;
            this._addDropTarget((LWComponent)child);
        }
    }

    private void _removeDropTarget(LWComponent comp) {
        DropTarget target = JFCSupport.getEWTDropTarget((JComponent)comp);
        if (target != null) {
            target.setComponent(null);
            target.removeDropTargetListener((DropTargetListener)this);
        }
        JFCSupport.setEWTDropTarget((JComponent)comp, null);
        int count = comp.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = comp.getComponent(i);
            if (!(c instanceof LWComponent)) continue;
            this._removeDropTarget((LWComponent)c);
        }
    }

    private class StartDrag
    implements DragGestureListener {
        private boolean _isChild;

        public StartDrag(boolean child) {
            this._isChild = child;
        }

        public void dragGestureRecognized(DragGestureEvent e) {
            DragComponent.this.tryDrag(e, this._isChild);
        }
    }

    private class Mouser
    extends MouseAdapter {
        private Mouser() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            DragComponent.this.childMouseEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            DragComponent.this.childMouseEvent(e);
        }
    }

    private class ChildSelect
    extends MouseAdapter {
        private ChildSelect() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ConstraintBuilder builder = DragComponent.this.getConstraintBuilder();
            if (!e.isConsumed() && builder.isEnabled()) {
                builder.setSelection(DragComponent.this);
            }
        }
    }
}

