/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.postgresql;

import java.util.ArrayList;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.convert.AbstractConverter;
import oracle.dbtools.migration.convert.ConvertException;
import oracle.dbtools.migration.convert.ConvertResult;
import oracle.dbtools.migration.convert.ConvertResultImpl;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.convert.ObjectTranslationList;
import oracle.dbtools.migration.translation.api.ITranslator;
import oracle.dbtools.migration.workbench.postgresql.BlackMessages;

public class PostgreSQLConverter
extends AbstractConverter {
    private static final String CRLF = "\r\n";
    private static ArrayList<DBObjectId> s_listOfSchema = new ArrayList();
    private static String s_functionName = "getTokenizer";

    public ITranslator getPlaformTranslator() {
        return null;
    }

    public String getDefaultValueMappingXML() {
        return "/oracle/dbtools/migration/workbench/plugin/postgresql/PostgreSQLDefaultValuesMappingRules.xml";
    }

    public ConvertResult convertObject(PersistableObject persistableObject, String string, PersistenceManager persistenceManager) throws ConvertException {
        if (string.equals("ENUM")) {
            return this.transformEnum((MdColumn)persistableObject, persistenceManager);
        }
        if (string.equals("SET")) {
            return this.transformSet((MdColumn)persistableObject, persistenceManager);
        }
        return null;
    }

    public String[] getPropertyKeyList() {
        String[] stringArray = new String[]{"ENUM", "SET"};
        return stringArray;
    }

    protected ConvertResult transformEnum(MdColumn mdColumn, PersistenceManager persistenceManager) throws ConvertException {
        AdditionalProperty additionalProperty2;
        String string;
        Object object;
        try {
            object = MdTable.retrieveExistingInstance((PersistenceManager)persistenceManager, (DBObjectId)mdColumn.getTableId());
            string = object.getTableName();
        }
        catch (NoSuchObjectException noSuchObjectException) {
            throw new ConvertException((Exception)((Object)noSuchObjectException));
        }
        catch (PersistenceException persistenceException) {
            throw new ConvertException((Exception)((Object)persistenceException));
        }
        object = new ArrayList();
        for (AdditionalProperty additionalProperty2 : mdColumn.getAdditionalProperties()) {
            if (!additionalProperty2.getKey().equals("ENUM")) continue;
            ((ArrayList)object).add(additionalProperty2.getValue());
        }
        if (((ArrayList)object).size() == 0) {
            throw new ConvertException(BlackMessages.getString("PostgreSQLConverter.8"));
        }
        String[] stringArray = ((ArrayList)object).toArray(new String[((ArrayList)object).size()]);
        String string2 = ConvertUtils.generateName((String)(string + "_" + mdColumn.getColumnName() + "_ETRG"));
        String string3 = this.createTriggerText(string, mdColumn.getColumnName(), PersistenceUtility.isColumnNullable((MdColumn)mdColumn), stringArray, string2);
        additionalProperty2 = new MdTrigger(mdColumn.getTableId(), "T", "OracleSQL");
        additionalProperty2.setNativeSql(string3);
        additionalProperty2.setTriggerName(string2);
        additionalProperty2.setTriggerTiming("BEFORE");
        additionalProperty2.setTriggerOperation("INSERT OR UPDATE");
        ConvertResultImpl convertResultImpl = new ConvertResultImpl((PersistableObject)mdColumn);
        convertResultImpl.addNewDerivedObject((PersistableObject)additionalProperty2);
        return convertResultImpl;
    }

    protected ConvertResult transformSet(MdColumn mdColumn, PersistenceManager persistenceManager) throws ConvertException {
        String string;
        Object object2;
        String string2;
        MdTable mdTable;
        try {
            mdTable = MdTable.retrieveExistingInstance((PersistenceManager)persistenceManager, (DBObjectId)mdColumn.getTableId());
            string2 = mdTable.getTableName();
        }
        catch (NoSuchObjectException noSuchObjectException) {
            throw new ConvertException((Exception)((Object)noSuchObjectException));
        }
        catch (PersistenceException persistenceException) {
            throw new ConvertException((Exception)((Object)persistenceException));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object2 : mdColumn.getAdditionalProperties()) {
            if (!object2.getKey().equals("SET")) continue;
            arrayList.add(object2.getValue());
        }
        if (arrayList.size() == 0) {
            throw new ConvertException(BlackMessages.getString("PostgreSQLConverter.14"));
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        String string3 = ConvertUtils.generateName((String)(string2 + "_" + mdColumn.getColumnName() + "_STRG"));
        DBObjectId dBObjectId = mdTable.getSchemaId();
        object2 = this.createSetTriggerText(string2, mdColumn.getColumnName(), PersistenceUtility.isColumnNullable((MdColumn)mdColumn), stringArray, string3);
        ConvertResultImpl convertResultImpl = new ConvertResultImpl((PersistableObject)mdColumn);
        convertResultImpl.setMaintainOrder(true);
        boolean bl = false;
        if (s_listOfSchema.contains(dBObjectId)) {
            bl = true;
        }
        if (!bl) {
            string = this.createSetFunctionText();
            MdStoredProgram mdStoredProgram = new MdStoredProgram(dBObjectId, "OracleSQL");
            mdStoredProgram.setProgramtype("FUNCTION");
            mdStoredProgram.setNativeSql(string);
            mdStoredProgram.setName(s_functionName);
            convertResultImpl.addNewDerivedObject((PersistableObject)mdStoredProgram);
            s_listOfSchema.add(dBObjectId);
        }
        string = new MdTrigger(mdColumn.getTableId(), "T", "OracleSQL");
        string.setNativeSql((String)object2);
        string.setTriggerName(string3);
        string.setTriggerTiming("BEFORE");
        string.setTriggerOperation("INSERT OR UPDATE");
        convertResultImpl.addNewDerivedObject((PersistableObject)string);
        return convertResultImpl;
    }

    private String createSetFunctionText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE OR REPLACE FUNCTION " + s_functionName + "(");
        stringBuffer.append(CRLF);
        stringBuffer.append("the_list  varchar2,");
        stringBuffer.append(CRLF);
        stringBuffer.append("the_index number,");
        stringBuffer.append(CRLF);
        stringBuffer.append("delim     varchar2 := ','");
        stringBuffer.append(CRLF);
        stringBuffer.append(")");
        stringBuffer.append(CRLF);
        stringBuffer.append("return    varchar2");
        stringBuffer.append(CRLF);
        stringBuffer.append("is");
        stringBuffer.append(CRLF);
        stringBuffer.append("start_pos number;");
        stringBuffer.append(CRLF);
        stringBuffer.append("end_pos   number;");
        stringBuffer.append(CRLF);
        stringBuffer.append("begin");
        stringBuffer.append(CRLF);
        stringBuffer.append(" if the_index = 1 then");
        stringBuffer.append(CRLF);
        stringBuffer.append("start_pos := 1;");
        stringBuffer.append(CRLF);
        stringBuffer.append("else");
        stringBuffer.append(CRLF);
        stringBuffer.append("start_pos := instr(the_list,delim,1,the_index - 1);");
        stringBuffer.append(CRLF);
        stringBuffer.append("if start_pos = 0 then");
        stringBuffer.append(CRLF);
        stringBuffer.append("return null;");
        stringBuffer.append(CRLF);
        stringBuffer.append("else");
        stringBuffer.append(CRLF);
        stringBuffer.append("start_pos := start_pos + length(delim);");
        stringBuffer.append(CRLF);
        stringBuffer.append("end if;");
        stringBuffer.append(CRLF);
        stringBuffer.append("end if;");
        stringBuffer.append(CRLF);
        stringBuffer.append("end_pos := instr(the_list,delim,start_pos,1);");
        stringBuffer.append(CRLF);
        stringBuffer.append("if end_pos = 0 then");
        stringBuffer.append(CRLF);
        stringBuffer.append("return substr(the_list,start_pos);");
        stringBuffer.append(CRLF);
        stringBuffer.append("else");
        stringBuffer.append(CRLF);
        stringBuffer.append("return substr(the_list,start_pos,end_pos - start_pos);");
        stringBuffer.append(CRLF);
        stringBuffer.append("end if;");
        stringBuffer.append(CRLF);
        stringBuffer.append("end " + s_functionName + ";");
        return stringBuffer.toString();
    }

    private String createSetTriggerText(String string, String string2, boolean bl, String[] stringArray, String string3) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE OR REPLACE TRIGGER " + string3);
        stringBuffer.append(CRLF);
        stringBuffer.append("BEFORE INSERT OR UPDATE ON " + string);
        stringBuffer.append(CRLF);
        stringBuffer.append("FOR EACH ROW");
        stringBuffer.append(CRLF);
        stringBuffer.append("DECLARE");
        stringBuffer.append(CRLF);
        stringBuffer.append("  input varchar2(500);");
        stringBuffer.append(CRLF);
        stringBuffer.append("  val varchar2(50);");
        stringBuffer.append(CRLF);
        stringBuffer.append("  cnt number := 1;");
        stringBuffer.append(CRLF);
        stringBuffer.append("  num number := 0;");
        stringBuffer.append(CRLF);
        stringBuffer.append("  str VARCHAR2(50);");
        stringBuffer.append(CRLF);
        stringBuffer.append("  returnStr varchar2(500);");
        stringBuffer.append(CRLF);
        stringBuffer.append("  setValue number :=0;");
        stringBuffer.append(CRLF);
        stringBuffer.append("  type array_value is table of number index by varchar2(40);");
        stringBuffer.append(CRLF);
        stringBuffer.append("  value_array array_value;");
        stringBuffer.append(CRLF);
        stringBuffer.append("  type array_order is table of varchar2(40) index by BINARY_INTEGER;");
        stringBuffer.append(CRLF);
        stringBuffer.append("  order_array array_order;");
        stringBuffer.append(CRLF);
        stringBuffer.append("BEGIN");
        stringBuffer.append(CRLF);
        for (n = 0; n < stringArray.length; ++n) {
            stringBuffer.append("value_array('" + stringArray[n] + "') := 0;");
            stringBuffer.append(CRLF);
        }
        for (n = 0; n < stringArray.length; ++n) {
            stringBuffer.append("order_array(" + n + ") :='" + stringArray[n] + "';");
            stringBuffer.append(CRLF);
        }
        stringBuffer.append(CRLF);
        stringBuffer.append("input := TRIM(:new." + string2 + ");");
        stringBuffer.append(CRLF);
        stringBuffer.append("LOOP");
        stringBuffer.append(CRLF);
        stringBuffer.append("  val := " + s_functionName + "(input,cnt);");
        stringBuffer.append(CRLF);
        stringBuffer.append("  cnt := cnt + 1;");
        stringBuffer.append(CRLF);
        stringBuffer.append("  if val is not null then ");
        stringBuffer.append(CRLF);
        stringBuffer.append("     if value_array.exists(val) then");
        stringBuffer.append(CRLF);
        stringBuffer.append("        value_array(val) := 1;");
        stringBuffer.append(CRLF);
        stringBuffer.append("     end if;");
        stringBuffer.append(CRLF);
        stringBuffer.append("  else");
        stringBuffer.append(CRLF);
        stringBuffer.append("     exit;");
        stringBuffer.append(CRLF);
        stringBuffer.append("  end if;");
        stringBuffer.append(CRLF);
        stringBuffer.append("end loop;");
        stringBuffer.append(CRLF);
        stringBuffer.append("num := order_array.FIRST;");
        stringBuffer.append(CRLF);
        stringBuffer.append("LOOP");
        stringBuffer.append(CRLF);
        stringBuffer.append("  EXIT WHEN NOT order_array.EXISTS(num);");
        stringBuffer.append(CRLF);
        stringBuffer.append("  str := order_array(num);");
        stringBuffer.append(CRLF);
        stringBuffer.append("  setValue := value_array(str);");
        stringBuffer.append(CRLF);
        stringBuffer.append("  if (setValue = 1) then");
        stringBuffer.append(CRLF);
        stringBuffer.append("    if returnStr is null then");
        stringBuffer.append(CRLF);
        stringBuffer.append("      returnStr := str;");
        stringBuffer.append(CRLF);
        stringBuffer.append("    else");
        stringBuffer.append(CRLF);
        stringBuffer.append("      returnStr := returnStr || ',' || str;");
        stringBuffer.append(CRLF);
        stringBuffer.append("    end if;");
        stringBuffer.append(CRLF);
        stringBuffer.append("  end if;");
        stringBuffer.append(CRLF);
        stringBuffer.append("  num := order_array.next(num);");
        stringBuffer.append(CRLF);
        stringBuffer.append("END LOOP;");
        stringBuffer.append(CRLF);
        stringBuffer.append(CRLF);
        stringBuffer.append("returnStr := substr(returnStr,0,length(returnStr));");
        stringBuffer.append(CRLF);
        stringBuffer.append("if returnStr is not null then");
        stringBuffer.append(CRLF);
        stringBuffer.append("  :new." + string2 + " := returnStr;");
        stringBuffer.append(CRLF);
        stringBuffer.append("else");
        stringBuffer.append(CRLF);
        stringBuffer.append("  :new." + string2 + " := ' ';");
        stringBuffer.append(CRLF);
        stringBuffer.append("END IF;");
        stringBuffer.append(CRLF);
        stringBuffer.append("END;");
        stringBuffer.append(CRLF);
        return stringBuffer.toString();
    }

    private String createTriggerText(String string, String string2, boolean bl, String[] stringArray, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE OR REPLACE TRIGGER " + string3);
        stringBuffer.append(CRLF);
        stringBuffer.append("BEFORE INSERT OR UPDATE ON " + string);
        stringBuffer.append(CRLF);
        stringBuffer.append("FOR EACH ROW");
        stringBuffer.append(CRLF);
        stringBuffer.append("DECLARE");
        stringBuffer.append(CRLF);
        stringBuffer.append("  v_val " + string + "." + string2 + "%TYPE;");
        stringBuffer.append(CRLF);
        stringBuffer.append("  v_test " + string + "." + string2 + "%TYPE;");
        stringBuffer.append(CRLF);
        stringBuffer.append("BEGIN");
        stringBuffer.append(CRLF);
        if (bl) {
            stringBuffer.append("  v_val := null;");
        } else if (stringArray[0].trim().length() == 0) {
            stringBuffer.append("  v_val := ' ';");
        } else {
            stringBuffer.append("  v_val := '" + stringArray[0] + "';");
        }
        stringBuffer.append(CRLF);
        stringBuffer.append("  v_test := TRIM(:new." + string2 + ");");
        stringBuffer.append(CRLF);
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == 0) {
                stringBuffer.append("  if");
            } else {
                stringBuffer.append("  elsif");
            }
            stringBuffer.append(" v_test = '" + (i + 1) + "' OR v_test = '" + stringArray[i] + "' THEN ");
            stringBuffer.append(CRLF);
            if (!bl && stringArray[i].trim().length() == 0) {
                stringBuffer.append("  v_val := ' ';");
            } else {
                stringBuffer.append("  v_val := '" + stringArray[i].trim() + "';");
            }
            stringBuffer.append(CRLF);
        }
        stringBuffer.append("  end if;");
        stringBuffer.append("  :new." + string2 + " := v_val;");
        stringBuffer.append(CRLF);
        stringBuffer.append("END;");
        return stringBuffer.toString();
    }

    public String getEmulationPkgName() {
        return "mysql";
    }

    public ObjectTranslationList getSupportedTranslationObjects() {
        return null;
    }
}

