/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.io.IOException;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import oracle.security.crypto.core.DSAKeyPairGenerator;
import oracle.security.crypto.core.DSAParams;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.jce.provider.SRRandomBitsSource;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public final class DSAAlgorithmParameterGeneratorSpi
extends AlgorithmParameterGeneratorSpi {
    private int size;
    private SecureRandom random;
    private boolean initialized = false;

    @Override
    protected void engineInit(int size, SecureRandom random) {
        this.size = size;
        this.random = random;
        this.initialized = true;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec getParamsSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("Invalid parameter");
    }

    @Override
    protected AlgorithmParameters engineGenerateParameters() {
        if (!this.initialized) {
            throw new IllegalStateException("The Generator is not initialized");
        }
        RandomBitsSource rbs = this.random == null ? RandomBitsSource.getDefault() : new SRRandomBitsSource(this.random);
        DSAParams p = DSAKeyPairGenerator.generateParameters((int)this.size, (RandomBitsSource)rbs);
        try {
            AlgorithmParameters algParam = AlgorithmParameters.getInstance("DSA");
            algParam.init(Utils.toBytes((Streamable)p));
            return algParam;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }
}

