/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.security.InvalidParameterException;
import java.security.SecureRandom;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SymmetricKeyGenerator;
import oracle.security.crypto.jce.provider.PhaosKeyGeneratorSpi;
import oracle.security.crypto.jce.provider.SRRandomBitsSource;

public final class DESedeKeyGeneratorSpi
extends PhaosKeyGeneratorSpi {
    public DESedeKeyGeneratorSpi() throws AlgorithmIdentifierException {
        super(SymmetricKeyGenerator.getInstance((AlgorithmIdentifier)AlgID.DES_EDE3_CBC), "DESede");
    }

    @Override
    public void engineInit(int keysize, SecureRandom random) {
        Object object = this.random = random == null ? RandomBitsSource.getDefault() : new SRRandomBitsSource(random);
        if (keysize != 112 && keysize != 168) {
            throw new InvalidParameterException("Wrong DESede keysize: must be equal to 112 or 168");
        }
        keysize = 192;
        this.length = keysize / 8;
        this.initialized = true;
    }
}

