/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.jce.provider;

import java.security.InvalidParameterException;
import java.security.SecureRandom;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SymmetricKeyGenerator;
import oracle.security.crypto.jce.provider.PhaosKeyGeneratorSpi;
import oracle.security.crypto.jce.provider.SRRandomBitsSource;

public final class DESKeyGeneratorSpi
extends PhaosKeyGeneratorSpi {
    public DESKeyGeneratorSpi() throws AlgorithmIdentifierException {
        super(SymmetricKeyGenerator.getInstance((AlgorithmIdentifier)AlgID.desCBC), "DES");
    }

    @Override
    public void engineInit(int keysize, SecureRandom random) {
        Object object = this.random = random == null ? RandomBitsSource.getDefault() : new SRRandomBitsSource(random);
        if (keysize != 56) {
            throw new InvalidParameterException("Wrong DES keysize: must be equal to 56");
        }
        keysize = 64;
        this.length = keysize / 8;
        this.initialized = true;
    }
}

