/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui.quickmigrate;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;

public class RepositorySelector
extends DefaultTraversablePanel {
    private JComboBox m_cmbRepo = new JComboBox();
    private static final String HTMLCONTENT = "text/html";
    private JTextPane m_txtRepoDesc = new JTextPane();
    private String m_repositoryName;
    private JCheckBox m_checkKeepRepo = new JCheckBox();
    private JTextArea m_lblRepo = new JTextArea();
    private boolean m_repoExists = true;
    private TraversableContext m_dataContext;
    private String defaultRepository = null;

    public RepositorySelector() {
        this.setLayout(new GridBagLayout());
        this.m_cmbRepo.setRenderer(new comboRenderer());
        Font font = this.m_cmbRepo.getFont();
        String string = MigrationUtils.fontToCSSString(font);
        this.add(this.m_txtRepoDesc, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.m_cmbRepo, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.m_lblRepo, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.m_checkKeepRepo, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        JLabel jLabel = new JLabel();
        jLabel.setVisible(true);
        this.add(jLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.populateRepositoryField(string);
    }

    private String getRepoName() {
        if (this.m_repositoryName == null) {
            return (String)this.m_cmbRepo.getSelectedItem();
        }
        return this.m_repositoryName;
    }

    private void populateRepositoryField(String string) {
        String string2;
        String[] stringArray = this.getConfiguredRepositories();
        if (stringArray == null || stringArray.length == 0) {
            this.m_repoExists = false;
            string2 = MigrationAddinArb.getString("QUICKMIGRATE_NO_REPO");
            this.m_cmbRepo.setVisible(false);
            this.m_checkKeepRepo.setText(MigrationAddinArb.getString("QUICKMIGRATE_OPTION_CLEANUP"));
            this.m_checkKeepRepo.setHorizontalAlignment(2);
            this.m_checkKeepRepo.setVerticalAlignment(1);
            this.m_checkKeepRepo.setVerticalTextPosition(1);
            this.m_checkKeepRepo.setVisible(true);
        } else if (stringArray.length == 1) {
            String string3 = Connections.getDisplayName((String)stringArray[0]);
            string2 = MigrationAddinArb.format("QUICKMIGRATE_SINGLE_REPO", string3);
            this.m_cmbRepo.setVisible(false);
            this.m_checkKeepRepo.setVisible(false);
            this.m_repositoryName = stringArray[0];
        } else {
            this.m_cmbRepo.removeAllItems();
            for (String string4 : stringArray) {
                this.m_cmbRepo.addItem(string4);
            }
            if (this.defaultRepository != null) {
                this.m_repositoryName = this.defaultRepository;
                this.m_cmbRepo.setSelectedItem(this.defaultRepository);
            }
            string2 = MigrationAddinArb.getString("QUICKMIGRATE_MULTIPLE_REPO");
            this.m_checkKeepRepo.setVisible(false);
        }
        this.m_lblRepo.setText(string2);
        this.m_lblRepo.setVisible(true);
        this.m_lblRepo.setEditable(false);
        this.m_txtRepoDesc.setContentType(HTMLCONTENT);
        this.m_txtRepoDesc.setText(MigrationAddinArb.format("QUICKMIGRATE_REPO_DESC", string));
        this.m_txtRepoDesc.setOpaque(false);
        this.m_txtRepoDesc.setEditable(false);
        this.m_txtRepoDesc.setRequestFocusEnabled(false);
        this.m_txtRepoDesc.setFocusable(false);
        this.m_txtRepoDesc.setSize(10, 10);
    }

    private String[] getConfiguredRepositories() {
        ArrayList<String> arrayList = new ArrayList<String>();
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        String[] stringArray = migrationConfig.getRepositories();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        this.defaultRepository = migrationConfig.getDefaultRepository();
        String[] stringArray2 = Connections.getInstance().getConnNames();
        block0: for (String string : stringArray) {
            for (String string2 : stringArray2) {
                if (!string2.equalsIgnoreCase(string) || !Connections.getInstance().isOracle(string2)) continue;
                arrayList.add(string2);
                continue block0;
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_dataContext = traversableContext;
        String string = (String)traversableContext.get("REPOSITORY_CONNECTION");
        if (string != null) {
            this.m_repositoryName = string;
        }
        if (this.m_repositoryName != null) {
            this.m_cmbRepo.setSelectedItem(this.m_repositoryName);
        } else if (this.m_cmbRepo.getSelectedObjects().length > 0) {
            this.m_cmbRepo.setSelectedIndex(0);
            this.m_repositoryName = (String)this.m_cmbRepo.getSelectedItem();
        }
        this.setWizardButtons();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        this.m_repositoryName = (String)this.m_cmbRepo.getSelectedItem();
        if (!this.m_repoExists) {
            this.m_repositoryName = (String)traversableContext.get("TARGET_CONNECTION");
        }
        traversableContext.put("REPOSITORY_CONNECTION", (Object)this.m_repositoryName);
        try {
            traversableContext.put("REPOSITORY_CONNECTION_OBJ", (Object)Connections.getInstance().getConnection(this.m_repositoryName));
            traversableContext.put("REPOSITORY_KEEP", (Object)(this.m_checkKeepRepo.isVisible() ? (this.m_checkKeepRepo.isSelected() ? "True" : "False") : "True"));
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    private void setWizardButtons() {
        this.m_dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    private class comboRenderer
    extends DefaultListCellRenderer {
        private comboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            return super.getListCellRendererComponent((JList<?>)jList, Connections.getDisplayName((String)((String)object)), n, bl, bl2);
        }
    }
}

