/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui.quickmigrate;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdProject;
import oracle.dbtools.migration.workbench.core.preferences.DataMovePreferencesPane;
import oracle.dbtools.migration.workbench.core.preferences.MigrationPreferences;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.MigrationWizardFinisher;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizard;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizardArb;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryCategory;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryItem;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryProvider;
import oracle.dbtools.raptor.controls.ConnectionPanelUI;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.model.Element;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.HyperlinkButton;

public class MoveDataPageMigration
extends DefaultTraversablePanel
implements CommitListener,
SummaryProvider {
    static final String ONLINEPANEL = "Online Capture";
    static final String OFFLINEPANEL = "Offline Capture";
    private final JRadioButton _rbtnOnlineCapture = new JRadioButton("", true);
    private final JRadioButton _rbtnOfflineCapture = new JRadioButton("");
    private final JPanel _topPanel = new JPanel();
    private final CardLayout _cl = new CardLayout();
    private final JCheckBox _chkTruncData = new JCheckBox();
    private final OnlineDMOptions _onlinePanel = new OnlineDMOptions();
    private final OfflineDMOptions _offlinePanel = new OfflineDMOptions();
    private final HyperlinkButton _prefDlgActivate = new HyperlinkButton(QMWizardArb.getString("AdvanceOptions").trim());
    private boolean _pageLocked = false;
    private ConnectionPanelUI _connectPanel;
    private ConnectionPanelUI _connectPanel2;

    MoveDataPageMigration() {
        ResourceUtils.resButton((AbstractButton)this._chkTruncData, (String)QMWizardArb.getString("TruncData"));
        ResourceUtils.resButton((AbstractButton)this._rbtnOnlineCapture, (String)QMWizardArb.getString("OnlineCapture"));
        ResourceUtils.resButton((AbstractButton)this._rbtnOfflineCapture, (String)QMWizardArb.getString("OfflineCapture"));
        this.putClientProperty("pagetitle", QMWizard.MVDAT_PAGE_ID);
        QMWizard.ContextHelper.addSummaryProvider(QMWizard.MVDAT_PAGE_ID, this);
        this.initGUI();
    }

    public void onEntry(TraversableContext traversableContext) {
        String string = ((String)traversableContext.get("OUTPUT_DIR")).trim() + File.separator + ((String)traversableContext.get("PROJECT_NAME")).trim() + File.separator + QMWizardArb.getString("DataMove").trim() + File.separator + new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
        this._offlinePanel._lblOffDataScriptDirVal.setText(string);
        this.initPageState(traversableContext);
        if (this._pageLocked) {
            traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            this.validateAndAbsorbPage(traversableContext);
        }
        if (!this._pageLocked) {
            if (traversableContext.getDirection() == 2) {
                QMWizard.ContextHelper.removeCommitPage(QMWizardArb.getString("STEP9"));
            } else if (traversableContext.getDirection() == 1) {
                QMWizard.ContextHelper.addCommitPage(QMWizardArb.getString("STEP9"));
            }
        }
    }

    @Override
    public SummaryItem getSummary(SummaryCategory summaryCategory) {
        SummaryCategory summaryCategory2 = null;
        SummaryItem summaryItem = null;
        if (summaryCategory != null) {
            summaryCategory2 = summaryCategory;
            if (this._rbtnOnlineCapture.isSelected()) {
                summaryItem = new SummaryItem(QMWizardArb.getString("DMGenMode"), StringUtils.stripMnemonic((String)QMWizardArb.getString("OnlineCapture")));
                summaryCategory2.addChild(summaryItem);
                summaryItem = new SummaryItem(QMWizardArb.getString("TargetConnection"), Connections.getDisplayName((String)this._connectPanel.getConnectionName()));
                summaryCategory2.addChild(summaryItem);
            }
            if (this._rbtnOfflineCapture.isSelected()) {
                summaryItem = new SummaryItem(QMWizardArb.getString("DMGenMode"), StringUtils.stripMnemonic((String)QMWizardArb.getString("OfflineCapture")));
                summaryCategory2.addChild(summaryItem);
                summaryItem = new SummaryItem(QMWizardArb.getString("GenDir2"), this._offlinePanel._lblOffDataScriptDirVal.getText());
                summaryCategory2.addChild(summaryItem);
            }
            if (this._chkTruncData.isSelected()) {
                summaryItem = new SummaryItem(StringUtils.stripMnemonic((String)QMWizardArb.getString("TruncData")), QMWizardArb.getString("Yes"));
                summaryCategory2.addChild(summaryItem);
            } else {
                summaryItem = new SummaryItem(StringUtils.stripMnemonic((String)QMWizardArb.getString("TruncData")), QMWizardArb.getString("No"));
                summaryCategory2.addChild(summaryItem);
            }
        }
        return summaryCategory2;
    }

    public void checkCommit(ApplyEvent applyEvent) throws TraversalException {
    }

    public void commit(ApplyEvent applyEvent) throws TraversalException {
        TraversableContext traversableContext = applyEvent.getTraversableContext();
        String string = (String)this.getClientProperty("pagetitle");
        if (QMWizard.ContextHelper.isActiveCommitPage(string)) {
            Element element;
            MdConnection mdConnection;
            Properties properties = new Properties();
            MigrationWizardFinisher migrationWizardFinisher = null;
            if (this._rbtnOnlineCapture.isSelected()) {
                properties.put("DM_MODE", "Online");
                properties.put("DM_SRCCONN", this._connectPanel2.getConnectionName());
                properties.put("DM_TGTCONN", this._connectPanel.getConnectionName());
            } else if (this._rbtnOfflineCapture.isSelected()) {
                properties.put("DM_MODE", "Offline");
                properties.put("DM_SCRIPTDIR", this._offlinePanel._lblOffDataScriptDirVal.getText().trim());
            }
            MdConnection mdConnection2 = QMWizard.ContextHelper.getCapturedConnectionObject();
            if (mdConnection2 != null) {
                properties.put("CONV_CATPCONN", mdConnection2);
            }
            properties.put("DM_TRUNC_ENABLED", (Object)this._chkTruncData.isSelected());
            MdProject mdProject = QMWizard.ContextHelper.getProject();
            if (mdProject != null) {
                properties.put("PARAM_PROJ", mdProject);
            }
            if ((mdConnection = QMWizard.ContextHelper.getConvertedConnectionObject()) != null) {
                properties.put("CONV_CONVCONN", mdConnection);
            }
            if ((element = QMWizard.ContextHelper.getContextElement()) != null) {
                properties.put("CTX_ELEMENT", element);
            }
            migrationWizardFinisher = QMWizard.ContextHelper.getWizardFinisher();
            migrationWizardFinisher.setParamAndFinish(properties, 128);
        }
    }

    public void rollback(ApplyEvent applyEvent) {
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    private void initGUI() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        ModeActionListener modeActionListener = new ModeActionListener();
        jPanel2.setLayout(new FlowLayout(0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._rbtnOnlineCapture);
        buttonGroup.add(this._rbtnOfflineCapture);
        this._rbtnOnlineCapture.addActionListener(modeActionListener);
        this._rbtnOfflineCapture.addActionListener(modeActionListener);
        jPanel2.add(this._rbtnOnlineCapture);
        jPanel2.add(this._rbtnOfflineCapture);
        jPanel2.setBorder(BorderFactory.createTitledBorder(QMWizardArb.getString("Mode")));
        this._topPanel.setLayout(this._cl);
        this._topPanel.add((Component)((Object)this._onlinePanel), ONLINEPANEL);
        this._topPanel.add((Component)((Object)this._offlinePanel), OFFLINEPANEL);
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(10, 0, 0, 0), 0, 0));
        jPanel3.add((Component)this._topPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(10, 0, 0, 0), 0, 0));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)this._prefDlgActivate, "East");
        jPanel3.add((Component)this._chkTruncData, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 11, 2, new Insets(10, 0, 0, 0), 0, 0));
        jPanel3.add((Component)new JLabel(), new GridBagConstraints(0, 3, 0, 0, 1.0, 1.0, 11, 1, new Insets(10, 0, 0, 0), 0, 0));
        this._prefDlgActivate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IdeSettings ideSettings = Ide.getSettings();
                String[] stringArray = new String[]{MigrationPreferences.TITLE, DataMovePreferencesPane.TITLE};
                ideSettings.showDialog((Frame)Ide.getMainWindow(), stringArray);
            }
        });
        this.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel3, "North");
        jPanel.add((Component)jPanel4, "South");
        this.add(jPanel, "Center");
    }

    private void initPageState(TraversableContext traversableContext) {
        boolean bl;
        boolean bl2 = traversableContext.get("GEN_MODE_ONLINE") != null ? (Boolean)traversableContext.get("GEN_MODE_ONLINE") : false;
        boolean bl3 = bl = traversableContext.get("GEN_MODE_ONLINE") != null ? (Boolean)traversableContext.get("GEN_MODE_OFFLINE") : false;
        if (bl2) {
            String string;
            this._rbtnOnlineCapture.doClick();
            String string2 = (String)traversableContext.get("TARGET_CONN");
            String string3 = (String)traversableContext.get("SOURCE_CONN");
            if (this._connectPanel != null) {
                this._connectPanel.resetConnections();
            }
            if (this._connectPanel2 != null) {
                this._connectPanel2.resetConnections();
            }
            if (string3 != null && string3.trim().length() > 0) {
                string = string3.trim();
                this._connectPanel2.setConnectionName(string);
            }
            if (string2 != null && string2.trim().length() > 0) {
                string = string2.trim();
                this._connectPanel.setConnectionName(string);
            }
        } else if (bl) {
            this._rbtnOfflineCapture.doClick();
        } else if (this._pageLocked) {
            this.add(new JLabel(QMWizardArb.getString("NoInfomationAvailable")), "Center");
            this.revalidate();
        }
    }

    private void lockPage(boolean bl) {
        this._pageLocked = true;
    }

    private void validateAndAbsorbPage(TraversableContext traversableContext) throws TraversalException {
        String string = null;
        if (this._rbtnOnlineCapture.isSelected()) {
            String string2 = string = this._connectPanel != null ? this._connectPanel.getConnectionName() : null;
            if (string != null && string.trim().length() > 0) {
                traversableContext.put("TARGET_CONN", (Object)string.trim());
                try {
                    Connections.getInstance().getConnection(string);
                }
                catch (Exception exception) {
                    throw new TraversalException(QMWizardArb.getString("InvalidTgtConnection"));
                }
            } else {
                throw new TraversalException(QMWizardArb.getString("InvalidTgtConnection"));
            }
            String string3 = this._connectPanel2.getConnectionName();
            if (string3 != null && string3.trim().length() > 0) {
                traversableContext.put("SOURCE_DM_CONN", (Object)string3.trim());
                try {
                    Connections.getInstance().getConnection(string3);
                }
                catch (Exception exception) {
                    throw new TraversalException(QMWizardArb.getString("InvalidSrcConnection"));
                }
            } else {
                throw new TraversalException(QMWizardArb.getString("InvalidTgtConnection"));
            }
            traversableContext.put("DATMV_MODE_ONLINE", (Object)true);
            traversableContext.put("DATMV_MODE_OFFLINE", (Object)false);
        } else if (this._rbtnOfflineCapture.isSelected()) {
            traversableContext.put("DATMV_MODE_OFFLINE", (Object)true);
            traversableContext.put("DATMV_MODE_ONLINE", (Object)false);
        } else {
            QMWizard.ContextHelper.clearScriptGenMode();
        }
        if (this._chkTruncData.isSelected()) {
            traversableContext.put("TRUNC_TARGET_OBJECTS", (Object)true);
        } else {
            traversableContext.put("TRUNC_TARGET_OBJECTS", (Object)false);
        }
    }

    private class OnlineDMOptions
    extends DefaultTraversablePanel {
        private final MultiLineLabel _lblOverview = new MultiLineLabel(QMWizardArb.getString("MoveDataOnlineOverview"));

        OnlineDMOptions() {
            this.setLayout(new GridBagLayout());
            MoveDataPageMigration.this._connectPanel = new ConnectionPanelUI(true, false);
            MoveDataPageMigration.this._connectPanel.setConnectionLabel(QMWizardArb.getString("MoveTarget").trim());
            MoveDataPageMigration.this._connectPanel.setConnectionPrompt("");
            String[] stringArray = this.getThirdPartyConnectionSubtypes();
            MoveDataPageMigration.this._connectPanel2 = new ConnectionPanelUI(stringArray, false);
            MoveDataPageMigration.this._connectPanel2.setConnectionLabel(QMWizardArb.getString("MoveSource").trim());
            MoveDataPageMigration.this._connectPanel2.setConnectionPrompt("");
            this.add(new JLabel(QMWizardArb.getString("MoveDataOnlineOverview")), new GridBagConstraints(0, 0, 0, 1, 0.0, 1.0, 11, 1, new Insets(10, 0, 0, 0), 0, 0));
            this.add((Component)MoveDataPageMigration.this._connectPanel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(10, 0, 10, 0), 0, 0));
            this.add((Component)MoveDataPageMigration.this._connectPanel, new GridBagConstraints(2, 1, 0, 1, 1.0, 0.0, 11, 1, new Insets(10, 10, 10, 0), 0, 0));
        }

        private String[] getThirdPartyConnectionSubtypes() {
            String[] stringArray = Connections.getInstance().getConnNames();
            Properties properties = null;
            String string = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] stringArray2 = null;
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    properties = Connections.getInstance().getConnectionInfo(string2);
                    string = properties.getProperty("subtype");
                    if ("oraJDBC".equals(string) || "TimesTen".equals(string) || "ODBCBridge".equals(string) || "ACCESS".equals(string) || "SDPostgreSQL".equals(string) || "MONGODB".equals(string) || "Hive".equals(string)) continue;
                    arrayList.add(string);
                }
            }
            stringArray2 = new String[arrayList.size()];
            return arrayList.toArray(stringArray2);
        }
    }

    private class OfflineDMOptions
    extends DefaultTraversablePanel {
        private final MultiLineLabel _lblOverview2 = new MultiLineLabel(QMWizardArb.getString("MoveDataOfflineOverview"));
        private final JLabel _lblOffDataScriptDir = new JLabel(QMWizardArb.getString("OfflineDSD"));
        private final JLabel _lblOffDataScriptDirVal = new JLabel();

        OfflineDMOptions() {
            this.setLayout(new GridBagLayout());
            this.add((Component)this._lblOverview2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 10, 0), 0, 0));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.add((Component)this._lblOffDataScriptDir, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 10, 0), 0, 0));
            jPanel.add((Component)this._lblOffDataScriptDirVal, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 10, 10, 0), 0, 0));
            jPanel.add((Component)new JLabel(), new GridBagConstraints(2, 0, 0, 1, 1.0, 0.0, 11, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.add(jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 10, 0), 0, 0));
        }
    }

    private class ModeActionListener
    implements ActionListener {
        private ModeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == MoveDataPageMigration.this._rbtnOnlineCapture) {
                MoveDataPageMigration.this._cl.show(MoveDataPageMigration.this._topPanel, MoveDataPageMigration.ONLINEPANEL);
            } else {
                MoveDataPageMigration.this._cl.show(MoveDataPageMigration.this._topPanel, MoveDataPageMigration.OFFLINEPANEL);
            }
        }
    }
}

