/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.ui.AbstractMigrationProgressRunnable;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.util.ModelUtil;

public class MigrationProgressBar
implements ActionListener,
Runnable {
    private Component _parent;
    private Object _belowInformation;
    private JProgressBar _progressBar;
    private boolean _useBusyBar;
    private JEWTDialog _statusDialog;
    private String _dialogTitle;
    private int _completionStatus;
    private Timer _labelTimer;
    private Timer _completionTimer;
    private boolean _userCancelled;
    private Runnable _runnable;
    private long _current = 0L;
    private long _lastPause = 0L;
    private boolean _done = false;
    private boolean _isExitClicked = false;
    private Component _topComponent;
    private Component _belowComponent;
    private JPanel _statusPanel;
    private boolean _isDismissed;
    private JCheckBox _exitCheckBox;
    private JButton _dismissButton;
    private JButton _cancelButton;
    private Object _aboveInformation;
    private static int s_topComponentWidth;
    private int m_topComponentHeight = 0;
    private int m_belowComponentHeight = 0;
    private int m_progressBarPanelHeight = 25;
    private int m_buttonPanelHeight = 55;
    private static int s_panelHeight;

    public MigrationProgressBar(Component component, String string, Runnable runnable, boolean bl) {
        this._parent = component;
        this._dialogTitle = string;
        this._runnable = runnable;
        this._useBusyBar = bl;
        s_topComponentWidth = 370;
        s_panelHeight = 0;
    }

    public void setRunnable(Runnable runnable) {
        this._runnable = runnable;
    }

    public void setGUI(Component component, Component component2) {
        this._belowComponent = component2;
        this._topComponent = component;
        if (this._topComponent != null) {
            s_topComponentWidth = component.getPreferredSize().width;
            this.m_topComponentHeight = component.getPreferredSize().height;
        }
        if (component2 != null) {
            this.m_belowComponentHeight = component2.getPreferredSize().height;
        }
    }

    public void start() {
        this.start(0, 100);
    }

    public void start(int n, int n2) {
        this._statusPanel = new JPanel(new FlowLayout());
        this.setPreferredSizeOfPanel(this._statusPanel);
        if (this._topComponent != null) {
            this._statusPanel.add(this._topComponent);
        }
        JPanel jPanel = new JPanel(new FlowLayout());
        this._statusPanel.add(jPanel);
        jPanel.setPreferredSize(new Dimension(s_topComponentWidth, this.m_progressBarPanelHeight));
        this._progressBar = new JProgressBar(n, n2);
        jPanel.add(this._progressBar);
        this._progressBar.setPreferredSize(new Dimension(s_topComponentWidth, 15));
        if (this._belowComponent != null) {
            this._statusPanel.add(this._belowComponent);
        }
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowWeights = new double[]{0.1, 0.1};
        gridBagLayout.rowHeights = new int[]{7, 7};
        gridBagLayout.columnWeights = new double[]{0.1, 0.1, 0.1};
        gridBagLayout.columnWidths = new int[]{7, 7, 7};
        jPanel2.setLayout(gridBagLayout);
        jPanel2.setPreferredSize(new Dimension(s_topComponentWidth, this.m_buttonPanelHeight));
        this._exitCheckBox = new JCheckBox();
        jPanel2.add((Component)this._exitCheckBox, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        gridBagLayout2.rowWeights = new double[]{0.1};
        gridBagLayout2.rowHeights = new int[]{7};
        gridBagLayout2.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
        gridBagLayout2.columnWidths = new int[]{7, 7, 7, 7};
        this._exitCheckBox.setLayout(gridBagLayout2);
        this._exitCheckBox.setText(MigrationAddinArb.getString("MigrationProgressBar_AUTOCLOSE_LABEL"));
        this._dismissButton = new JButton();
        BorderLayout borderLayout = new BorderLayout();
        this._dismissButton.setLayout(borderLayout);
        this._dismissButton.setEnabled(false);
        jPanel2.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add((Component)this._dismissButton, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._dismissButton.setText(MigrationAddinArb.getString("MigrationProgressBar_DISMISSBUTTON_LABEL"));
        this._cancelButton = new JButton();
        jPanel2.add((Component)this._cancelButton, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._cancelButton.setText(MigrationAddinArb.getString("MigrationProgressBar_CANCELBUTTON_LABEL"));
        this._statusPanel.add(jPanel2);
        this.addListenersToButtons();
        if (!this._useBusyBar) {
            this._progressBar.setValue(0);
        }
        if (this._useBusyBar) {
            this._progressBar.setIndeterminate(true);
        } else {
            this._progressBar.setIndeterminate(false);
        }
        ((AbstractMigrationProgressRunnable)this._runnable).updateAbovePanel(this._aboveInformation);
        ((AbstractMigrationProgressRunnable)this._runnable).updateBelowPanel(this._belowInformation);
        this._labelTimer = new Timer(1, this);
        this._labelTimer.setRepeats(true);
        this._completionTimer = new Timer(1, this);
        this._completionTimer.setRepeats(false);
        this._userCancelled = false;
        try {
            this._statusDialog = ProgressDialog.createDialog(this._parent, this._dialogTitle, this._topComponent, this._belowComponent);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        if (this._statusDialog == null) {
            return;
        }
        this._statusDialog.add((Component)this._statusPanel);
        final Thread thread = new Thread((Runnable)this, "ProgressBarThread");
        thread.setPriority(5);
        this._statusDialog.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                thread.start();
                windowEvent.getWindow().removeWindowListener(this);
            }
        });
        boolean bl = this._statusDialog.runDialog();
        this._userCancelled = !bl;
        this.setDoneStatus();
        if (this._statusDialog != null) {
            this._statusDialog.dispose();
            this._statusDialog = null;
        }
    }

    private void setPreferredSizeOfPanel(JPanel jPanel) {
        s_panelHeight = this.m_topComponentHeight + this.m_progressBarPanelHeight + this.m_belowComponentHeight + this.m_buttonPanelHeight;
        if (this._topComponent == null) {
            this._statusPanel.setPreferredSize(new Dimension(s_topComponentWidth + 20, s_panelHeight));
        } else if (this._topComponent != null && this._belowComponent == null) {
            this._statusPanel.setPreferredSize(new Dimension(s_topComponentWidth + 70, s_panelHeight));
        } else {
            this._statusPanel.setPreferredSize(new Dimension(s_topComponentWidth + 70, s_panelHeight));
        }
    }

    private void addListenersToButtons() {
        this._dismissButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MigrationProgressBar.this._isDismissed = true;
                MigrationProgressBar.this.setDoneStatus();
                MigrationProgressBar.this._statusDialog.dispose();
                MigrationProgressBar.this._statusDialog = null;
            }
        });
        this._cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MigrationProgressBar.this._userCancelled = true;
                MigrationProgressBar.this.setDoneStatus();
                ((AbstractMigrationProgressRunnable)MigrationProgressBar.this._runnable).doCancel();
            }
        });
        this._exitCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MigrationProgressBar.this._isExitClicked = !MigrationProgressBar.this._isExitClicked;
            }
        });
    }

    public void updateProgress(int n, Object object, Object object2) {
        if (this._userCancelled) {
            return;
        }
        if (this._progressBar == null) {
            return;
        }
        this._completionStatus = n;
        if (!this._useBusyBar) {
            if (SwingUtilities.isEventDispatchThread()) {
                this._progressBar.setValue(this._completionStatus);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MigrationProgressBar.this._progressBar.setValue(MigrationProgressBar.this._completionStatus);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        }
        if (object != null) {
            this._aboveInformation = object;
            ((AbstractMigrationProgressRunnable)this._runnable).updateAbovePanel(this._aboveInformation);
        }
        if (object2 != null) {
            this._belowInformation = object2;
            ((AbstractMigrationProgressRunnable)this._runnable).updateBelowPanel(this._belowInformation);
        }
        this._labelTimer.start();
    }

    public int getCompletionStatus() {
        return this._completionStatus;
    }

    public void updateProgress(String string, String string2) {
        if (this._userCancelled) {
            if (this._aboveInformation != null) {
                ((AbstractMigrationProgressRunnable)this._runnable).updateAbovePanel(this._aboveInformation);
            }
            if (ModelUtil.hasLength((String)string2)) {
                this._belowInformation = string2;
            }
            this._labelTimer.start();
        }
    }

    public boolean hasUserCancelled() {
        if (this._userCancelled) {
            this.setDoneStatus();
        }
        return this._userCancelled;
    }

    public void sleepForUIToRepaint() {
        if (this._lastPause == 0L) {
            this._current = this._lastPause = System.currentTimeMillis();
        } else {
            this._current = System.currentTimeMillis();
            long l = this._current - this._lastPause;
            if (l > 1000L) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this._lastPause = this._current;
            }
        }
    }

    public synchronized void waitUntilDone() {
        while (!this._done) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.notifyAll();
    }

    public synchronized void setDoneStatus() {
        this._done = true;
        this.notifyAll();
        this.end();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._labelTimer) {
            if (this._belowInformation != null) {
                ((AbstractMigrationProgressRunnable)this._runnable).updateBelowPanel(this._belowInformation);
            }
        } else if (object == this._completionTimer) {
            if (this._statusDialog != null && this._statusDialog.isVisible()) {
                this._statusDialog.hide();
            }
            if (this._labelTimer != null) {
                this._labelTimer.stop();
                this._labelTimer.removeActionListener(this);
                this._labelTimer = null;
            }
            this._completionTimer.stop();
            this._completionTimer.removeActionListener(this);
            this._completionTimer = null;
        }
    }

    @Override
    public void run() {
        if (this._userCancelled) {
            return;
        }
        this._runnable.run();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    MigrationProgressBar.this._cancelButton.setEnabled(false);
                    MigrationProgressBar.this._dismissButton.setEnabled(true);
                    MigrationProgressBar.this._progressBar.setIndeterminate(false);
                    MigrationProgressBar.this._progressBar.setValue(100);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void end() {
        if (this._completionTimer != null) {
            this._completionTimer.start();
        }
    }

    public JDialog getStatusDialog() {
        return this._statusDialog;
    }

    public boolean isExitClicked() {
        return this._isExitClicked;
    }

    public void setExitOnDone(boolean bl) {
        if (bl != this._exitCheckBox.isSelected()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        MigrationProgressBar.this._exitCheckBox.doClick();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    public Component getBelowComponent() {
        return this._belowComponent;
    }

    public Component getTopComponent() {
        return this._topComponent;
    }

    public JProgressBar getProgressBar() {
        return this._progressBar;
    }

    public boolean isDismissed() {
        return this._isDismissed;
    }

    public JButton getCancelButton() {
        return this._cancelButton;
    }

    public JButton getDismissButton() {
        return this._dismissButton;
    }

    public void setSize(Dimension dimension) {
        this._statusPanel.setPreferredSize(dimension);
    }

    private static final class ProgressDialog
    extends JEWTDialog {
        private static final long serialVersionUID = 1L;

        static ProgressDialog createDialog(Component component, String string, Component component2, Component component3) {
            ProgressDialog progressDialog = null;
            Dialog dialog = DialogUtil.getAncestorDialog((Component)component);
            if (dialog != null) {
                progressDialog = new ProgressDialog(dialog, string, component2, component3);
            } else {
                Frame frame = DialogUtil.getAncestorFrame((Component)component);
                if (frame != null) {
                    progressDialog = new ProgressDialog(frame, string, component2, component3);
                }
            }
            return progressDialog;
        }

        private ProgressDialog(Dialog dialog, String string, Component component, Component component2) {
            super(dialog, string, 0);
            this.setLayout(this, component, component2);
        }

        private ProgressDialog(Frame frame, String string, Component component, Component component2) {
            super(frame, string, 0);
            this.setLayout(this, component, component2);
        }

        private void setLayout(ProgressDialog progressDialog, Component component, Component component2) {
            if (component == null) {
                progressDialog.setPreferredSize(s_topComponentWidth + 50, s_panelHeight + 70);
            } else if (component != null && component2 == null) {
                progressDialog.setPreferredSize(s_topComponentWidth + 50, s_panelHeight + 70);
            } else {
                progressDialog.setPreferredSize(s_topComponentWidth + 50, s_panelHeight + 70);
            }
        }

        protected void dismissDialog(boolean bl) {
            if (this.getDefaultCloseOperation() != 0) {
                super.dismissDialog(bl);
            }
        }

        public void dispose() {
            super.dispose();
        }

        public void removeNotify() {
            super.removeNotify();
        }
    }
}

