/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.ui.EventStatusModel;
import oracle.dbtools.migration.workbench.core.ui.FullMigrationPreRequisiteChecker;
import oracle.dbtools.migration.workbench.core.ui.PreReqListener;
import oracle.dbtools.migration.workbench.core.ui.SimpleTablePanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.db.DatabaseConnectionEditor;

public class FullMigrationChoiceDialog
extends JEWTDialog {
    private static final String HTMLCONTENT = "text/html";
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JTextPane m_txtSourceDescription = new JTextPane();
    private JComboBox m_cmbSourceConnection = new JComboBox();
    private JComboBox m_cmbTarget = new JComboBox();
    private JLabel m_lblSourceConnection = new JLabel();
    private JButton m_btnAddSource = new JButton();
    private JSeparator m_jSeparator1 = new JSeparator();
    private JTextPane m_txtRepoDesc = new JTextPane();
    private JComboBox m_cmbRepo = new JComboBox();
    private JSeparator m_jSeparator2 = new JSeparator();
    private JTextPane m_txtTargetDesc = new JTextPane();
    private JButton m_btnAddTarget = new JButton();
    private JSeparator jSeparator3 = new JSeparator();
    private JButton m_btnTest = new JButton();
    private JTextPane m_txtTestDesc = new JTextPane();
    private PreReqResultsPanel m_testResultsPanel = new PreReqResultsPanel();
    private JTextArea m_lblRepo = new JTextArea();
    private JCheckBox m_checkKeepRepo = new JCheckBox();
    private FullMigrationPreRequisiteChecker m_checker = null;
    private JLabel m_lblMigrationType = new JLabel();
    private JComboBox m_cmbMigrationType = new JComboBox();
    private String m_sourceConnectionName;
    private String m_targetConnectionName;
    private String m_repositoryName;
    private boolean m_sourceIsPreSelected = false;

    public FullMigrationChoiceDialog(Frame frame, String string) {
        super(frame);
        this.setButtonMask(7);
        this.setOKButtonEnabled(false);
        this.setOKButtonText(MigrationAddinArb.getString("QUICKMIGRATE_BUTTON_MIGRATE"));
        this.setOKButtonMnemonic(StringUtils.getMnemonicKeyCode((String)"MNEM_QUICKMIGRATE_BUTTON_MIGRATE"));
        this.setTitle(MigrationAddinArb.getString("QUICKMIGRATE_DIALOG_TITLE"));
        this.setResizable(true);
        this.setModal(true);
        this.setCancelButtonMnemonic(StringUtils.getMnemonicKeyCode((String)"MNEM_QUICKMIGRATE_BUTTON_CANCEL"));
        if (string != null) {
            this.m_sourceConnectionName = string;
            this.m_sourceIsPreSelected = true;
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit() throws Exception {
        JComponent jComponent;
        JPanel jPanel = new JPanel();
        this.m_lblRepo.setWrapStyleWord(true);
        this.m_lblRepo.setLineWrap(true);
        this.m_lblRepo.setEditable(false);
        this.m_lblRepo.setOpaque(false);
        this.m_lblRepo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Font font = this.m_btnAddSource.getFont();
        String string = MigrationUtils.fontToCSSString(font);
        jPanel.setLayout(this.gridBagLayout1);
        this.m_txtSourceDescription.setContentType(HTMLCONTENT);
        this.m_txtSourceDescription.setText(MigrationAddinArb.format("QUICKMIGRATE_SOURCE_DESC", string));
        this.m_txtSourceDescription.setEditable(false);
        this.m_txtSourceDescription.setOpaque(false);
        this.m_txtSourceDescription.setRequestFocusEnabled(false);
        this.m_txtSourceDescription.setFocusable(false);
        Dimension dimension = new Dimension(72, 22);
        this.m_btnAddSource.setMinimumSize(dimension);
        this.m_btnAddSource.setMaximumSize(dimension);
        this.m_btnAddSource.setPreferredSize(dimension);
        this.m_btnAddSource.setMnemonic(StringUtils.getMnemonicKeyCode((String)"MNEM_QUICKMIGRATE_BUTTON_ADD_SOURCE"));
        this.m_btnAddTarget.setMinimumSize(dimension);
        this.m_btnAddTarget.setMaximumSize(dimension);
        this.m_btnAddTarget.setPreferredSize(dimension);
        this.m_btnAddTarget.setMnemonic(StringUtils.getMnemonicKeyCode((String)"MNEM_QUICKMIGRATE_BUTTON_ADD_TARGET"));
        this.m_btnTest.setMinimumSize(dimension);
        this.m_btnTest.setMaximumSize(dimension);
        this.m_btnTest.setPreferredSize(dimension);
        this.m_btnTest.setMnemonic(StringUtils.getMnemonicKeyCode((String)"MNEM_QUICKMIGRATE_BUTTON_VERIFY"));
        this.m_lblMigrationType.setText(MigrationAddinArb.getString("FULLMIGRATION_MIGRATIONTYPE"));
        this.m_cmbMigrationType.addItem(MigrationAddinArb.getString("FULLMIGRATION_MTYPE_TABLE"));
        this.m_cmbMigrationType.addItem(MigrationAddinArb.getString("FULLMIGRATION_MTYPE_TABLEANDDATA"));
        this.m_cmbMigrationType.addItem(MigrationAddinArb.getString("FULLMIGRATION_MTYPE_EVERYTHING"));
        this.m_cmbRepo.setRenderer(new DBConnComboRenderer());
        this.m_cmbSourceConnection.setRenderer(new DBConnComboRenderer());
        this.m_cmbTarget.setRenderer(new DBConnComboRenderer());
        jPanel.add((Component)this.m_txtSourceDescription, new GridBagConstraints(0, 0, 1, 1, 3.0, 0.0, 18, 1, new Insets(0, 5, 0, 5), 0, 0));
        if (this.m_sourceIsPreSelected) {
            jComponent = this.m_lblSourceConnection;
            this.m_lblSourceConnection.setText(Connections.getDisplayName((String)this.m_sourceConnectionName));
        } else {
            jComponent = this.m_cmbSourceConnection;
            this.m_cmbSourceConnection.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FullMigrationChoiceDialog.this.sourceConnectionSelectionChange();
                }
            });
        }
        jPanel.add((Component)jComponent, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        if (!this.m_sourceIsPreSelected) {
            jPanel.add((Component)this.m_btnAddSource, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        jPanel.add((Component)this.m_jSeparator1, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.m_txtTargetDesc, new GridBagConstraints(0, 2, 1, 1, 3.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.m_cmbTarget, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.m_btnAddTarget, new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.m_jSeparator2, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.m_txtRepoDesc, new GridBagConstraints(0, 4, 1, 2, 3.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.m_cmbRepo, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.m_lblRepo, new GridBagConstraints(1, 4, 3, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), -200, 0));
        this.m_checkKeepRepo.setVisible(false);
        jPanel.add((Component)this.m_checkKeepRepo, new GridBagConstraints(1, 5, 2, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.jSeparator3, new GridBagConstraints(0, 6, 3, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.m_btnTest, new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.m_txtTestDesc, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.m_testResultsPanel.getPanel(), new GridBagConstraints(0, 8, 4, 1, 0.0, 0.0, 11, 2, new Insets(10, 20, 10, 20), 0, 73));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        jPanel2.add(this.m_lblMigrationType);
        jPanel2.add(this.m_cmbMigrationType);
        jPanel.add((Component)jPanel2, new GridBagConstraints(2, 9, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_btnAddSource.setText(MigrationAddinArb.getString("QUICKMIGRATE_BUTTON_ADD_SOURCE"));
        this.m_btnAddSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FullMigrationChoiceDialog.this.newSourceOrTarget();
            }
        });
        this.m_txtTargetDesc.setContentType(HTMLCONTENT);
        this.m_txtTargetDesc.setText(MigrationAddinArb.format("QUICKMIGRATE_TARGET_DESC", string));
        this.m_txtTargetDesc.setEditable(false);
        this.m_txtTargetDesc.setOpaque(false);
        this.m_txtTargetDesc.setRequestFocusEnabled(false);
        this.m_txtTargetDesc.setFocusable(false);
        this.m_btnAddTarget.setText(MigrationAddinArb.getString("QUICKMIGRATE_BUTTON_ADD_TARGET"));
        this.m_btnAddTarget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FullMigrationChoiceDialog.this.newSourceOrTarget();
            }
        });
        this.m_btnTest.setText(MigrationAddinArb.getString("QUICKMIGRATE_BUTTON_VERIFY"));
        this.m_btnTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FullMigrationChoiceDialog.this.performTest();
            }
        });
        this.m_txtTestDesc.setContentType(HTMLCONTENT);
        this.m_txtTestDesc.setText(MigrationAddinArb.format("QUICKMIGRATE_VERIFY_DESC", string));
        this.m_txtTestDesc.setEditable(false);
        this.m_txtTestDesc.setOpaque(false);
        this.m_txtTestDesc.setRequestFocusEnabled(false);
        this.m_txtTestDesc.setFocusable(false);
        this.populatecConnectionCombos(false);
        this.populateRepositoryField(string);
        this.setButtonStates();
        this.m_cmbTarget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FullMigrationChoiceDialog.this.targetConnectionSelectionChange();
            }
        });
        this.setContent(jPanel);
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_quickmigrate_html");
        this.pack();
        this.setResizable(false);
    }

    private void populatecConnectionCombos(boolean bl) {
        String[] stringArray;
        String string = null;
        String string2 = null;
        if (bl) {
            if (!this.m_sourceIsPreSelected) {
                string = (String)this.m_cmbSourceConnection.getSelectedItem();
            }
            string2 = (String)this.m_cmbTarget.getSelectedItem();
        }
        this.m_cmbSourceConnection.removeAllItems();
        this.m_cmbTarget.removeAllItems();
        Connections connections = Connections.getInstance();
        for (String string3 : stringArray = connections.getConnNames()) {
            if (connections.isOracle(string3)) {
                this.m_cmbTarget.addItem(string3);
                continue;
            }
            this.m_cmbSourceConnection.addItem(string3);
        }
        if (bl) {
            if (string != null && !this.m_sourceIsPreSelected) {
                this.m_cmbSourceConnection.setSelectedItem(string);
            }
            if (string2 != null) {
                this.m_cmbTarget.setSelectedItem(string2);
            }
        }
        if (!this.m_sourceIsPreSelected) {
            this.sourceConnectionSelectionChange();
        }
        this.targetConnectionSelectionChange();
    }

    private void populateRepositoryField(String string) {
        String string2;
        String[] stringArray = this.getConfiguredRepositories();
        if (stringArray == null || stringArray.length == 0) {
            string2 = MigrationAddinArb.getString("QUICKMIGRATE_NO_REPO");
            this.m_cmbRepo.setVisible(false);
            this.m_checkKeepRepo.setText(MigrationAddinArb.getString("QUICKMIGRATE_OPTION_CLEANUP"));
            this.m_checkKeepRepo.setHorizontalAlignment(2);
            this.m_checkKeepRepo.setVerticalAlignment(1);
            this.m_checkKeepRepo.setVerticalTextPosition(1);
            this.m_checkKeepRepo.setVisible(true);
        } else if (stringArray.length == 1) {
            String string3 = Connections.getDisplayName((String)stringArray[0]);
            string2 = MigrationAddinArb.format("QUICKMIGRATE_SINGLE_REPO", string3);
            this.m_cmbRepo.setVisible(false);
            this.m_checkKeepRepo.setVisible(false);
            this.m_repositoryName = stringArray[0];
        } else {
            this.m_cmbRepo.removeAllItems();
            for (String string3 : stringArray) {
                this.m_cmbRepo.addItem(string3);
            }
            String string4 = MigrationAddin.getMigrationConfig().getDefaultRepository();
            this.m_cmbRepo.setSelectedItem(string4);
            string2 = MigrationAddinArb.getString("QUICKMIGRATE_MULTIPLE_REPO");
            this.m_checkKeepRepo.setVisible(false);
        }
        this.m_lblRepo.setText(string2);
        this.m_lblRepo.setVisible(true);
        this.m_txtRepoDesc.setContentType(HTMLCONTENT);
        this.m_txtRepoDesc.setText(MigrationAddinArb.format("QUICKMIGRATE_REPO_DESC", string));
        this.m_txtRepoDesc.setOpaque(false);
        this.m_txtRepoDesc.setEditable(false);
        this.m_txtRepoDesc.setRequestFocusEnabled(false);
        this.m_txtRepoDesc.setFocusable(false);
    }

    private String[] getConfiguredRepositories() {
        ArrayList<String> arrayList = new ArrayList<String>();
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        String[] stringArray = migrationConfig.getRepositories();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        String[] stringArray2 = Connections.getInstance().getConnNames();
        block0: for (String string : stringArray) {
            for (String string2 : stringArray2) {
                if (!string2.equalsIgnoreCase(string) || !Connections.getInstance().isOracle(string2)) continue;
                arrayList.add(string2);
                continue block0;
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void newSourceOrTarget() {
        DatabaseConnectionEditor.editConnection((String)"IdeConnections", null);
        this.populatecConnectionCombos(true);
    }

    private void setButtonStates() {
        if ((this.m_cmbSourceConnection.getSelectedIndex() != -1 || this.m_sourceIsPreSelected) && this.m_cmbTarget.getSelectedIndex() != -1) {
            this.m_btnTest.setEnabled(true);
        } else {
            this.m_btnTest.setEnabled(false);
        }
    }

    private String getRepoName() {
        if (this.m_repositoryName == null) {
            return (String)this.m_cmbRepo.getSelectedItem();
        }
        return this.m_repositoryName;
    }

    protected void performTest() {
        this.setOKButtonEnabled(false);
        if (this.m_checker != null) {
            this.m_checker.allDone();
        }
        this.m_checker = new FullMigrationPreRequisiteChecker(this.m_sourceConnectionName, this.m_targetConnectionName, this.getRepoName());
        this.m_testResultsPanel.reset();
        this.m_checker.addListener(this.m_testResultsPanel);
        int n = this.m_checker.runTests();
        if (n == 2) {
            StringBuffer stringBuffer = new StringBuffer(MigrationAddinArb.getString("QM_MULTI_WARN"));
            stringBuffer.append("\n");
            stringBuffer.append(this.m_checker.getPrivWarning());
            MessageDialog.information((Component)((Object)this), (Object)stringBuffer.toString(), (String)MigrationAddinArb.getString("QM_MULTI_WARN_TITLE"), (String)"help_migrate_privileges");
        }
        this.setOKButtonEnabled(n != 1);
    }

    private void resetTest() {
        this.m_btnTest.setEnabled(true);
        this.setOKButtonEnabled(false);
    }

    private void sourceConnectionSelectionChange() {
        String string = (String)this.m_cmbSourceConnection.getSelectedItem();
        if (FullMigrationChoiceDialog.stringsDiffer(string, this.m_sourceConnectionName)) {
            this.resetTest();
            this.m_sourceConnectionName = string;
        }
    }

    private void targetConnectionSelectionChange() {
        String string = (String)this.m_cmbTarget.getSelectedItem();
        if (FullMigrationChoiceDialog.stringsDiffer(string, this.m_targetConnectionName)) {
            this.resetTest();
            this.m_targetConnectionName = string;
        }
    }

    private static boolean stringsDiffer(String string, String string2) {
        if (string == null) {
            return string2 != null;
        }
        if (string2 == null) {
            return true;
        }
        return !string.equals(string2);
    }

    public MigrationPlugin getPlugin() {
        if (this.m_checker == null) {
            return null;
        }
        return this.m_checker.getPlugin();
    }

    public Connection getSourceConnection() {
        if (this.m_checker == null) {
            return null;
        }
        return this.m_checker.getSourceConnection();
    }

    public Connection getTargetConnection() {
        if (this.m_checker == null) {
            return null;
        }
        return this.m_checker.getTargetConnection();
    }

    public String getSourceConnectionName() {
        if (this.m_checker == null) {
            return null;
        }
        return this.m_checker.getSrcConnName();
    }

    public String getTargetConnectionName() {
        if (this.m_checker == null) {
            return null;
        }
        return this.m_checker.getTrgConnName();
    }

    public boolean getCleanupRepoFlag() {
        if (this.m_checkKeepRepo.isVisible()) {
            return !this.m_checkKeepRepo.isSelected();
        }
        return false;
    }

    public String getMigrationType() {
        return (String)this.m_cmbMigrationType.getSelectedItem();
    }

    public void resetChecker() {
        if (this.m_checker != null) {
            this.m_checker.allDone();
        }
    }

    private static class PreReqResultsPanel
    implements PreReqListener {
        private EventStatusModel m_model = new EventStatusModel(new String[]{MigrationAddinArb.getString("QUICKMIGRATE_PREREQ_CHECK_HEADING_TESTNAME"), MigrationAddinArb.getString("QUICKMIGRATE_PREREQ_CHECK_HEADING_STATUS"), MigrationAddinArb.getString("QUICKMIGRATE_PREREQ_CHECK_HEADING_INFORMATION")});
        private SimpleTablePanel m_eventPanel = new SimpleTablePanel(600, null, this.m_model);

        public SimpleTablePanel getPanel() {
            return this.m_eventPanel;
        }

        @Override
        public void testCompleted(String string, boolean bl, String string2) {
            String[] stringArray = new String[]{string, bl ? MigrationAddinArb.getString("QUICKMIGRATE_PREREQ_TEST_SUCCESS") : MigrationAddinArb.getString("QUICKMIGRATE_PREREQ_TEST_FAIL"), string2};
            this.m_eventPanel.updateProgress(stringArray);
        }

        @Override
        public void testStarted(String string, String string2) {
            String[] stringArray = new String[]{string, MigrationAddinArb.getString("QUICKMIGRATE_PREREQ_TEST_STARTED"), string2};
            this.m_eventPanel.updateProgress(stringArray);
        }

        public void reset() {
            this.m_model.clear();
        }
    }

    private class DBConnComboRenderer
    extends DefaultListCellRenderer {
        private DBConnComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object == null ? "" : Connections.getDisplayName((String)((String)object));
            return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
        }
    }

    public static enum MIGRATIONTYPE {
        TABLE,
        TABLEANDDATA,
        EVERYTHING;

    }
}

