/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.ui.MdConnectionRenderer;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;

public class DataMoveSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1010952975618088521L;
    private JComboBox m_convertedModelcomboBox;
    private JComboBox m_targetConnectionComboBox;
    private JComboBox m_sourceComboBox;
    private JCheckBox m_checkUseQualifiedNames;
    private String m_oracle;
    private String m_nonoracle;
    private MdConnection m_captured;
    private MdConnection m_converted;

    public DataMoveSelectionPanel(MdConnection mdConnection) {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setText(MigrationAddinArb.getString("DMSP_SOURCE_CONNECTION_LABEL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 13;
        this.add((Component)jLabel, gridBagConstraints);
        this.m_sourceComboBox = new JComboBox<String>(this.getNonOracleConnections());
        this.m_sourceComboBox.setRenderer(new comboRenderer());
        this.m_sourceComboBox.setToolTipText(MigrationAddinArb.getString("DMSP_SOURCE_COMBO_TOOLTIP"));
        this.m_sourceComboBox.setActionCommand("m_sourceComboBoxChanged");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.m_sourceComboBox, gridBagConstraints2);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(MigrationAddinArb.getString("DMSP_TARGET_CONNECTION_LABEL"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridx = 0;
        this.add((Component)jLabel2, gridBagConstraints3);
        this.m_targetConnectionComboBox = new JComboBox<String>(this.getOracleConnections());
        this.m_targetConnectionComboBox.setRenderer(new comboRenderer());
        this.m_targetConnectionComboBox.setToolTipText(MigrationAddinArb.getString("DMSP_TARGET_COMBO_TOOLTIP"));
        this.m_targetConnectionComboBox.setActionCommand("m_targetConnectionComboBoxChanged");
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.gridx = 1;
        this.add((Component)this.m_targetConnectionComboBox, gridBagConstraints4);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(MigrationAddinArb.getString("DMSP_CONVERTED_CONNECTION_LABEL"));
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.anchor = 13;
        gridBagConstraints5.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints5.gridy = 2;
        gridBagConstraints5.gridx = 0;
        if (mdConnection == null) {
            this.add((Component)jLabel3, gridBagConstraints5);
        }
        this.m_convertedModelcomboBox = new JComboBox<MigrationConnectionNode>(ConvertedDatabases.getInstance().getMigrationConnectionNodes());
        this.m_convertedModelcomboBox.setRenderer(new MdConnectionRenderer());
        this.m_convertedModelcomboBox.setToolTipText(MigrationAddinArb.getString("DMSP_CONVERTED_COMBO_TOOLTIP"));
        this.m_convertedModelcomboBox.setActionCommand("m_convertedComboBoxChanged");
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.gridy = 2;
        gridBagConstraints6.gridx = 1;
        if (mdConnection == null) {
            this.add((Component)this.m_convertedModelcomboBox, gridBagConstraints6);
            if (this.m_convertedModelcomboBox.getSelectedItem() != null) {
                this.m_converted = ((MigrationConnectionNode)this.m_convertedModelcomboBox.getSelectedItem()).getMdConnection();
            }
        } else {
            this.m_converted = mdConnection;
        }
        this.m_checkUseQualifiedNames = new JCheckBox();
        this.m_checkUseQualifiedNames.setSelected(true);
        this.m_checkUseQualifiedNames.setText(MigrationAddinArb.getString("DMSP_CHECK_QUALIFED"));
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints7.fill = 2;
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 3;
        gridBagConstraints7.gridwidth = 3;
        this.add((Component)this.m_checkUseQualifiedNames, gridBagConstraints7);
        this.m_targetConnectionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataMoveSelectionPanel.this.m_oracle = ((JComboBox)actionEvent.getSource()).getSelectedItem().toString();
            }
        });
        this.m_convertedModelcomboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataMoveSelectionPanel.this.m_converted = ((MigrationConnectionNode)((JComboBox)actionEvent.getSource()).getSelectedItem()).getMdConnection();
            }
        });
        this.m_sourceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataMoveSelectionPanel.this.m_nonoracle = ((JComboBox)actionEvent.getSource()).getSelectedItem().toString();
            }
        });
        if (this.m_targetConnectionComboBox.getSelectedItem() != null) {
            this.m_oracle = this.m_targetConnectionComboBox.getSelectedItem().toString();
        }
        if (this.m_sourceComboBox.getSelectedItem() != null) {
            this.m_nonoracle = this.m_sourceComboBox.getSelectedItem().toString();
        }
    }

    private String[] getOracleConnections() {
        Connections connections = Connections.getInstance();
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = connections.getConnNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!connections.isOracle(string)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] getNonOracleConnections() {
        Connections connections = Connections.getInstance();
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = connections.getConnNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (connections.isOracle(string) || connections.getConnectionType(string).equals("Access")) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Connection getTargetConnection() throws DBException {
        return Connections.getInstance().getConnection(this.m_oracle);
    }

    public Connection getSourceConnection() throws DBException {
        return Connections.getInstance().getConnection(this.m_nonoracle);
    }

    public String getSourceConnectionName() {
        return this.m_nonoracle;
    }

    public String getTargetConnectionName() {
        return this.m_oracle;
    }

    public MdConnection getCapturedConnection() {
        return this.m_captured;
    }

    public MdConnection getConvertedConnection() {
        return this.m_converted;
    }

    public boolean getUseQualifiedNames() {
        return this.m_checkUseQualifiedNames.isSelected();
    }

    private class comboRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 6863349475776521119L;

        private comboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = "";
            if (object != null) {
                string = Connections.getDisplayName((String)((String)object));
            }
            return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
        }
    }
}

