/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdProject;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.navigator.CapturedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.AbstractLoadChildrenTask;
import oracle.dbtools.migration.workbench.core.navigator.nodes.ApplicationsFolderNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.DefaultContainerCustomNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.IPersistableObjectNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectsFolderNode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;

public class MigrationProjectNode
extends DefaultContainerCustomNode
implements IPersistableObjectNode {
    protected static final Logger LOGGER = Logger.getLogger(MigrationProjectNode.class.getName());
    protected PersistenceUtility m_utility;
    private String m_label;
    protected HashSet<String> m_names;
    private MdProject m_project;

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public MigrationProjectNode(String string, MdProject mdProject) {
        this.m_project = mdProject;
        this.m_names = new HashSet();
        this.setShortLabel(string);
        String string2 = this.m_project.getKey().toString();
        this.setURL(URLFactory.newURL((String)"sqldev.migration", (String)(MigrationAddin.getRepositoryConnectionName() + "/" + string2)));
        this.getAttributes().set(ElementAttributes.DELETEABLE | ElementAttributes.RENAMEABLE);
    }

    public String getShortLabel() {
        return this.m_label;
    }

    public void setShortLabel(String string) {
        this.m_label = string;
    }

    public void rename(String string) {
        this.setShortLabel(string);
        UpdateMessage.fireObjectRenamed((Subject)this);
    }

    public MdProject getMdProject() {
        return this.m_project;
    }

    public PersistenceUtility getUtility() {
        return this.m_utility;
    }

    public CloseableIterator getMdConnectionsIterator() throws PersistenceException {
        return this.getUtility().getCapturedConnectionsForProjectId(this.getMdProject().getKey());
    }

    protected MigrationConnectionNode createMdConnectionNode(String string, String string2, MdConnection mdConnection) {
        if (null == mdConnection.getType()) {
            return new CapturedConnectionNode(string, string2, mdConnection);
        }
        return new ConvertedConnectionNode(string, string2, mdConnection);
    }

    @Override
    public PersistenceManager getPersistenceManager() {
        return MigrationAddin.getPersistenceManager();
    }

    protected MigrationConnectionNode addChild(MdConnection mdConnection, String string) {
        Object object2;
        for (Object object2 : this._children) {
            MigrationConnectionNode migrationConnectionNode;
            if (!(object2 instanceof MigrationConnectionNode) || (migrationConnectionNode = (MigrationConnectionNode)object2).getMdConnection().getKey().getId() != mdConnection.getKey().getId()) continue;
            this.reload();
            return null;
        }
        String string2 = this.findUniqueName(mdConnection.getName());
        object2 = this.createMdConnectionNode(string2, string, mdConnection);
        ((MigrationConnectionNode)object2).getDict().put("MDPROJECT", this.getMdProject());
        ((MigrationConnectionNode)object2).setParentElement((Element)this);
        this._children.add(object2);
        return object2;
    }

    private void reload() {
        IconOverlayCache iconOverlayCache = IconOverlayCache.getInstance();
        iconOverlayCache.clearOverlays("MigrationNodeInfoType");
        iconOverlayCache.fireOverlaysChanged();
        UpdateMessage.fireObjectReloaded((Subject)this);
        try {
            this.close();
            this.open();
        }
        catch (IOException iOException) {
            MigrationProjectNode.log(iOException);
        }
    }

    protected String findUniqueName(String string) {
        Object object = string;
        int n = 2;
        while (this.m_names.contains(object)) {
            object = string + "(" + n++ + ")";
        }
        this.m_names.add((String)object);
        return object;
    }

    public Icon getIcon() {
        return MigrationProjectsFolderNode.getProjectIcon();
    }

    @Override
    protected void queueBackgroundLoadChildrenTask() {
        this.m_utility = PersistenceUtility.getInstance(this.getPersistenceManager());
        final String string = MigrationAddin.getRepositoryConnectionName();
        AbstractLoadChildrenTask abstractLoadChildrenTask = new AbstractLoadChildrenTask((Element)this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<Element> doWork() {
                ArrayList<Element> arrayList = new ArrayList<Element>();
                try (CloseableIterator closeableIterator = null;){
                    Object object;
                    MigrationProjectNode.this.m_names.clear();
                    closeableIterator = MigrationProjectNode.this.getMdConnectionsIterator();
                    while (closeableIterator.hasNext()) {
                        object = (MdConnection)closeableIterator.next();
                        MigrationConnectionNode migrationConnectionNode = MigrationProjectNode.this.addChild((MdConnection)object, string);
                        if (migrationConnectionNode == null) continue;
                        arrayList.add((Element)migrationConnectionNode);
                    }
                    object = MigrationProjectNode.this.getApplicationsFolderNode(MigrationProjectNode.this.getMdProject().getKey());
                    ((DefaultContainerCustomNode)object).setParentElement((Element)MigrationProjectNode.this);
                    if (((ApplicationsFolderNode)object).hasChildren()) {
                        arrayList.add((Element)object);
                    }
                }
                return arrayList;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)abstractLoadChildrenTask);
    }

    @Override
    public String getObjectName() {
        return "MD_PROJECTS";
    }

    @Override
    public String getObjectType() {
        return "MIGRATION_PROJECT";
    }

    @Override
    public HashMap<String, Object> getDict() {
        if (null == this._dict) {
            super.getDict();
            this._dict.put("IDPROJECT", this.getMdProject().getKey().toString());
        }
        return this._dict;
    }

    @Override
    public PersistableObject getPersistableObject() {
        return this.getMdProject();
    }

    private ApplicationsFolderNode getApplicationsFolderNode(DBObjectId dBObjectId) {
        return new ApplicationsFolderNode(dBObjectId);
    }
}

