/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.net.URL;
import oracle.dbtools.migration.workbench.core.navigator.AbstractMigrationNavigatorManager;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CapturedNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectsFolderNode;
import oracle.dbtools.raptor.controls.grid.IDrillLink;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.db.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.impl.ViewableElement;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.oviewer.base.NavSelectionListener;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;

public class MigrationDrillLink
implements IDrillLink {
    String _logtext;
    String _projectid;
    String _projectname;
    String _connid;
    String _connname;
    String _catalogid;
    String _catalogname;
    String _schemaid;
    String _schemaname;
    String _objid;
    String _objname;
    String _type;
    String _conn;
    int _line = 1;
    int _column = 1;

    public void setArgs(String[] stringArray) {
        if (stringArray.length == 14) {
            this._logtext = stringArray[0];
            this.processLineAndColumn(this._logtext);
            this._projectid = stringArray[1];
            this._projectname = stringArray[2];
            this._connid = stringArray[3];
            this._connname = stringArray[4];
            this._catalogid = stringArray[5];
            this._catalogname = stringArray[6];
            this._schemaid = stringArray[7];
            this._schemaname = stringArray[8];
            this._objid = stringArray[9];
            this._objname = stringArray[10];
            this._type = stringArray[11];
        } else {
            this._projectid = stringArray[0];
            this._projectname = stringArray[1];
            this._connid = stringArray[2];
            this._connname = stringArray[3];
            this._catalogid = stringArray[4];
            this._catalogname = stringArray[5];
            this._schemaid = stringArray[6];
            this._schemaname = stringArray[7];
            this._objid = stringArray[8];
            this._objname = stringArray[9];
            this._type = stringArray[10];
        }
    }

    private void processLineAndColumn(String string) {
        int n = string.lastIndexOf(" line ");
        int n2 = string.lastIndexOf(" column ");
        if (n != -1 && n2 != -1) {
            try {
                String string2 = string.substring(n + 6, n2).trim();
                String string3 = string.substring(n2 + 8).trim();
                string2 = string2.replaceAll(",", "");
                string3 = string3.replaceAll(",", "");
                this._line = Integer.parseInt(string2);
                this._column = Integer.parseInt(string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void performDrill() {
        String string = this._type;
        if (this._type.startsWith("MD_STORED")) {
            string = "MD_PROCEDURE";
        } else if (this._type.endsWith("S")) {
            string = string.substring(0, this._type.length() - 1);
        }
        URL uRL = DBURLFormatHelper.getURL((String)"sqldev.migration", (String)this._conn, (String)this._catalogname, (String)(this._schemaid + "_" + this._schemaname), (String)string);
        URL uRL2 = DBURLFormatHelper.getURL((URL)uRL, (String)(this._objid + "_" + this._objname));
        Node node = null;
        try {
            node = NodeFactory.findOrCreate(CapturedNode.class, (URL)uRL2);
            NodeFactory.uncache((URL)uRL2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this._type.equals("MD_TABLES")) {
            ObjectFactory objectFactory = AbstractMigrationNavigatorManager.getRegistry().getFactory(this._connname, MigrationProjectsFolderNode.getInstance().getPersistenceManager().getConn());
            DBObjectInstance dBObjectInstance = objectFactory.createNodeInstance("MD_TABLE");
            dBObjectInstance.setProperty("TABLE_NAME", (Object)(this._objid + "_" + this._objname));
            dBObjectInstance.setProperty("IDTABLE", (Object)this._objid);
            dBObjectInstance.setProperty("NAME", (Object)this._objname);
            dBObjectInstance.setProperty("CATALOG", null);
            dBObjectInstance.setProperty("SCHEMA", (Object)this._schemaname);
            dBObjectInstance.setProperty("TABLE_ID", (Object)this._objid);
            dBObjectInstance.setProperty("TABLE_REF", (Object)(this._objid + "_" + this._objname));
            dBObjectInstance.setProperty("ConnectionType", (Object)"MIGREPO");
            dBObjectInstance.setProperty("SCHEMA_ID", (Object)this._schemaid);
            if (node instanceof CapturedNode) {
                ((CapturedNode)node).setNodeInstance(dBObjectInstance);
            } else if (node instanceof ObjectNode) {
                ((ObjectNode)node).setNodeInstance(dBObjectInstance);
            }
            NavSelectionListener.getInstance().open(node);
        } else if (this._type.equals("MD_INDEXES")) {
            ObjectFactory objectFactory = AbstractMigrationNavigatorManager.getRegistry().getFactory(this._connname, MigrationProjectsFolderNode.getInstance().getPersistenceManager().getConn());
            DBObjectInstance dBObjectInstance = objectFactory.createNodeInstance("MD_INDEX");
            dBObjectInstance.setProperty("INDEX_NAME", (Object)this._objname);
            dBObjectInstance.setProperty("IDINDEX", (Object)this._objid);
            dBObjectInstance.setProperty("NAME", (Object)(this._objid + "_" + this._objname + " (NA)"));
            dBObjectInstance.setProperty("SCHEMA", (Object)(this._schemaid + "_" + this._schemaname));
            dBObjectInstance.setProperty("INDEX_REF", (Object)(this._objid + "_" + this._objname + " (NA)"));
            dBObjectInstance.setProperty("ConnectionType", (Object)"MIGREPO");
            dBObjectInstance.setProperty("IDSCHEMA", (Object)this._schemaid);
            dBObjectInstance.setProperty("INDEX_TYPE", (Object)"NON_UNIQUE");
            if (node instanceof CapturedNode) {
                ((CapturedNode)node).setNodeInstance(dBObjectInstance);
            } else if (node instanceof ObjectNode) {
                ((ObjectNode)node).setNodeInstance(dBObjectInstance);
            }
            NavSelectionListener.getInstance().open(node);
        } else {
            NavSelectionListener.getInstance().open((ViewableElement)((DatabaseNode)node), this._line, this._column, null);
        }
    }

    public void setConnName(String string) {
        this._conn = string;
    }
}

