/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.offline.streams;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.datamove.offline.streams.MdColumnComparator;
import oracle.dbtools.migration.datamove.offline.streams.OfflineDMSAbstract;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;

public abstract class Offline3rdPartyDMSAbstract
extends OfflineDMSAbstract {
    private String BASEFILE_NAME = "_{0}.{1}";

    public Offline3rdPartyDMSAbstract(String string, String string2) {
        super(string, string2);
    }

    @Override
    public String getBaseFileName() {
        return this.m_plugin.getPlatformName().replaceAll("\\s", "") + this.BASEFILE_NAME;
    }

    @Override
    public void startSchema(String string, String string2) {
        if (this.m_plugin.doIReturnUnloadScripts()) {
            super.startSchema(string, string2);
        }
        this.println(this.schemaWriterNix, this.m_plugin.getDataHeaderCommand(false), false);
        this.println(this.schemaWriterWindows, this.m_plugin.getDataHeaderCommand(true), true);
    }

    @Override
    public void start(MdConnection mdConnection, PersistenceManager persistenceManager) {
        if (this.m_plugin == null) {
            try {
                this.m_plugin = MigrationUtils.getPluginForConnection(mdConnection);
            }
            catch (MigrationPluginException migrationPluginException) {
                migrationPluginException.printStackTrace();
            }
        }
        if (this.m_plugin.doIReturnUnloadScripts()) {
            super.start(mdConnection, persistenceManager);
        }
    }

    @Override
    public void startTable(String string) {
        String string2 = this.getSchemaDir() + File.separator + this.getGenType();
        Offline3rdPartyDMSAbstract.setWriteDir(string2);
        MdColumn[] mdColumnArray = this.m_descriptor.getSourceColumns();
        Arrays.sort(mdColumnArray, new MdColumnComparator());
        String string3 = this.m_plugin.createDataFileName(this.m_descriptor.getTargetTableName(true), this.m_descriptor.getSourceTableName());
        this.println(this.schemaWriterNix, this.m_plugin.getDataExportCommmand(this.m_descriptor.getSourceTableName(), mdColumnArray, string3, false), false);
        this.println(this.schemaWriterWindows, this.m_plugin.getDataExportCommmand(this.m_descriptor.getSourceTableName(), mdColumnArray, string3, true), true);
    }

    @Override
    public void endTable() {
        if (this.m_plugin.doIReturnUnloadScripts()) {
            super.endTable();
        }
    }

    @Override
    public void startDatabase(String string, String string2) {
        if (this.m_plugin.doIReturnUnloadScripts()) {
            super.startDatabase(string, string2);
        }
    }

    @Override
    public void endDatabase() {
        if (this.m_plugin.doIReturnUnloadScripts()) {
            super.endDatabase();
        }
    }

    @Override
    public void endSchema() {
        if (this.m_plugin.doIReturnUnloadScripts()) {
            super.endSchema();
        }
    }

    @Override
    public void finished() {
        if (this.m_plugin.doIReturnUnloadScripts()) {
            super.finished();
        }
    }

    @Override
    public abstract String getExtension();

    @Override
    public abstract String getFileName();

    public abstract String getDataFileName(String var1, String var2);

    public abstract String getRowDelimiter();

    public abstract String getFieldTerminator();

    public abstract ArrayList<String> getColumnList();
}

