/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.command_line;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.dbtools.migration.command_line.CMDLineError;
import oracle.dbtools.migration.command_line.CMDOut;
import oracle.dbtools.migration.command_line.CMDUtil;
import oracle.dbtools.migration.command_line.MigrationCmd;
import oracle.dbtools.migration.command_line.MigrationCmdRunner;
import oracle.dbtools.migration.command_line.MigrationDetails;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.convert.DataTypeConversionMap;
import oracle.dbtools.migration.convert.SupportedDataTypesMap;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.logging.MigrationFileHandler;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.preferences.ConfigurationData;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.ui.FullMigrateTask;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.Messages;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizard;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public class QMCmd
extends MigrationCmd {
    public static final String CMDNAME = "qm";
    private QMDetails m_qmDetails = null;

    public QMCmd(MigrationDetails migrationDetails, CMDOut cMDOut, boolean bl) {
        super(CMDNAME, migrationDetails, cMDOut, bl);
        this.m_qmDetails = new QMDetails(migrationDetails);
        Logger logger = Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
        try {
            logger.addHandler(new MigrationFileHandler(this.m_qmDetails.getOutputPath()));
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    protected void executeImpl() throws CMDLineError {
        int n = 126;
        Thread.currentThread().setContextClassLoader(QMCmd.class.getClassLoader());
        MigrationCmdRunner.setupSQLDeveloper();
        Properties properties = this.getProperties();
        FullMigrateTask fullMigrateTask = new FullMigrateTask(n, properties);
        try {
            Boolean bl = (Boolean)fullMigrateTask.call();
            System.out.println("sucess:" + bl.toString());
        }
        catch (Exception exception) {
            MigrationLogUtil.logThrowable(exception.getLocalizedMessage(), Messages.getString("QMSummary.13"), (Throwable)exception);
        }
    }

    private Properties getProperties() {
        Properties properties = new Properties();
        properties.put("PROJ_NAME", this.getQMDetails().getProjectName());
        properties.put("CAPT_ENCODING", this.getQMDetails().getEncoding());
        if (this.getQMDetails().getCaptureMode() == "Online") {
            properties.put("CAPT_SRCCONN", this.getQMDetails().getSourceConnIdentifier());
        }
        properties.put("GEN_DROP_ENABLED", this.getQMDetails().isGenDropEnabled());
        properties.put("PROJ_DESC", this.getQMDetails().getProjectDesc());
        properties.put("CAPT_MODE", this.getQMDetails().getCaptureMode());
        properties.put("GEN_TGTCONN", this.getQMDetails().getTargetConnIdentifier());
        properties.put("REPO_CONN", this.getQMDetails().getRepoConnIdentifier());
        properties.put("GEN_SCRIPTDIR", this.getQMDetails().getScriptDir());
        properties.put("REPO_TRUNC", this.getQMDetails().isRepoTrunc());
        properties.put("GEN_MODE", this.getQMDetails().getGenMode());
        if (this.getQMDetails().getOCPPath() != null) {
            properties.put("CAPT_OCPPATH", this.getQMDetails().getOCPPath());
        }
        properties.put("PROJ_OUTDIR", this.getQMDetails().getOutputPath());
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("ALL_OBJECTS");
        properties.put("PARAM_TRNSL_SELOBJGROUPS", Collections.unmodifiableCollection(arrayList));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.addAll(this.getQMDetails().getDatabaseList());
        properties.put("CAPT_DBLIST", Collections.unmodifiableCollection(arrayList2));
        MigrationPlugin migrationPlugin = null;
        try {
            Object object;
            if (this.getQMDetails().getCaptureMode() == "Online") {
                object = Connections.getInstance().getConnection(this.getQMDetails().getSourceConnIdentifier());
                migrationPlugin = MigrationAddin.getPluginForConnection((Connection)object);
            } else {
                migrationPlugin = FullMigrateTask.getOffinePlugin(properties.getProperty("CAPT_OCPPATH"));
            }
            object = migrationPlugin.getSupportedDataTypesMap();
            DataTypeConversionMap dataTypeConversionMap = ConvertUtils.getDefaultMapFromSupportedMap((SupportedDataTypesMap)object);
            properties.put("CONV_DTMAP", dataTypeConversionMap);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return properties;
    }

    private QMDetails getQMDetails() {
        return this.m_qmDetails;
    }

    private class QMDetails {
        MigrationDetails m_migrationDetails = null;
        String m_targetconnName = null;
        String m_sourceconnName = null;
        String m_output = null;
        String m_projectName = null;
        String m_encoding = null;
        Boolean m_isDropGen = false;
        String m_desc = null;
        String m_repoConnName = null;
        String m_scriptDir = null;
        Boolean m_repoTrunc = false;
        String m_genMode = null;
        String m_ocpPath = null;
        ArrayList<String> m_dbList = null;
        public static final String ONLINEGEN = "ONLINEGEN";
        public static final String OFFLINEGEN = "OFFLINEGEN";

        QMDetails(MigrationDetails migrationDetails) {
            Object object3;
            Object object2;
            this.m_migrationDetails = migrationDetails;
            String string = migrationDetails.get("conn");
            if (string != null) {
                object2 = string.split(",");
                for (Object object3 : object2) {
                    if (((String)object3).toLowerCase().startsWith("source")) {
                        this.m_sourceconnName = object3;
                        continue;
                    }
                    if (!((String)object3).toLowerCase().startsWith("target")) continue;
                    this.m_targetconnName = object3;
                }
            }
            this.m_output = this.m_migrationDetails.get("output");
            this.m_projectName = this.m_migrationDetails.get("project");
            object2 = this.m_migrationDetails.get("dropgen");
            this.m_isDropGen = object2 != null && ((String)object2).equalsIgnoreCase("true") ? Boolean.valueOf(true) : Boolean.valueOf(false);
            this.m_desc = this.m_migrationDetails.get("desc");
            String string2 = this.m_migrationDetails.get("repotrunc");
            this.m_repoTrunc = string2 != null && ((String)object2).equalsIgnoreCase("true") ? Boolean.valueOf(true) : Boolean.valueOf(false);
            this.m_genMode = this.m_migrationDetails.get("genmode");
            if (this.m_migrationDetails.get("dblist") != null) {
                this.m_dbList = new ArrayList<String>(Arrays.asList(this.m_migrationDetails.get("dblist").split(",")));
            }
            this.m_ocpPath = this.m_migrationDetails.get("ocp");
            Preferences preferences = Preferences.getPreferences();
            MigrationConfig migrationConfig = MigrationConfig.getInstance((PropertyStorage)preferences);
            migrationConfig.setTarget12c(this.m_migrationDetails.is12c());
            if (this.m_migrationDetails.isGenerationSingleFile()) {
                migrationConfig.setFileOutputOption(2);
            }
            object3 = ConfigurationData.getInstance((PropertyStorage)preferences);
            ((ConfigurationData)((Object)object3)).setAll12c(this.m_migrationDetails.is12c());
        }

        public ArrayList<String> getDatabaseList() {
            if (this.m_dbList == null) {
                MigrationPlugin migrationPlugin = null;
                try {
                    migrationPlugin = FullMigrateTask.getOffinePlugin(this.getOCPPath());
                    String string = migrationPlugin.getPlatformName();
                    this.m_dbList = new ArrayList<String>(QMWizard.ContextHelper.getAvailableDBListOffline(string, this.getOCPPath()));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return this.m_dbList;
        }

        public String getOutputPath() {
            return this.m_output;
        }

        public String getOCPPath() {
            return this.m_ocpPath;
        }

        public String getGenMode() {
            if (this.m_genMode != null) {
                return this.m_genMode;
            }
            if (this.getTargetConnName() == null) {
                return ONLINEGEN;
            }
            return OFFLINEGEN;
        }

        public Boolean isRepoTrunc() {
            return this.m_repoTrunc;
        }

        public String getScriptDir() {
            if (this.m_scriptDir != null) {
                return this.m_scriptDir;
            }
            return this.getOutputPath() + File.separator + this.getProjectName() + File.separator + this.getDateTimeStr();
        }

        public String getRepoConnIdentifier() {
            if (this.getRepoConnName() != null) {
                return CMDUtil.getQualifiedName(this.getRepoConnName());
            }
            return MigrationAddin.getRepositoryConnectionName();
        }

        private String getRepoConnName() {
            return this.m_repoConnName;
        }

        public String getTargetConnIdentifier() {
            return CMDUtil.getQualifiedName(this.getTargetConnName());
        }

        public String getSourceConnIdentifier() {
            return CMDUtil.getQualifiedName(this.getSourceConnName());
        }

        public String getCaptureMode() {
            if (this.getOCPPath() != null) {
                return "Offline";
            }
            return "Online";
        }

        public Object getProjectDesc() {
            if (this.m_desc != null) {
                return this.m_desc;
            }
            return "";
        }

        public Boolean isGenDropEnabled() {
            return this.m_isDropGen;
        }

        public String getEncoding() {
            if (this.m_encoding != null) {
                return this.m_encoding;
            }
            return "Cp1252";
        }

        public String getProjectName() {
            if (this.m_projectName != null) {
                return this.m_projectName;
            }
            return this.getDateTimeStr();
        }

        private String getDateTimeStr() {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd_MM_yyyy_HH_mm_ss");
            Date date = new Date();
            return "project_" + simpleDateFormat.format(date);
        }

        public String getTargetConnName() {
            return this.m_targetconnName;
        }

        public String getSourceConnName() {
            return this.m_sourceconnName;
        }
    }
}

