/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.command_line;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import oracle.dbtools.migration.capture.ListCapturedModelsCmd;
import oracle.dbtools.migration.command_line.CMDOut;
import oracle.dbtools.migration.command_line.MigrationCmdHelp;
import oracle.dbtools.migration.command_line.MigrationCmdRegistry;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;

public class MigrationDetails {
    private RaptorTaskDescriptor m_descriptor = null;
    private final HashMap<String, String> m_properties = new HashMap();
    private String[] m_actionNames = null;
    static final String KEYMARKER = "-";
    static final String KEYVALUESEP = "=";
    protected CMDOut cmdout = null;
    private LinkedHashMap<String, Boolean> actionMap = null;

    public MigrationDetails() {
    }

    public MigrationDetails(String[] stringArray) {
        try {
            this.processArgs(stringArray);
        }
        catch (Exception exception) {
            this.usage(exception.getLocalizedMessage());
        }
    }

    public void setDescriptor(RaptorTaskDescriptor raptorTaskDescriptor) {
        this.m_descriptor = raptorTaskDescriptor;
    }

    public RaptorTaskDescriptor getDescriptor() {
        return this.m_descriptor;
    }

    private void processArgs(String[] stringArray) {
        if (stringArray != null) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = this.getKey(stringArray[i]);
                String string2 = this.getValue(stringArray[i]);
                this.m_properties.put(string.toLowerCase(), string2);
            }
        }
    }

    private void resetMap() {
        this.actionMap = new LinkedHashMap();
        this.actionMap.put("driver", false);
        this.actionMap.put("guide", false);
        this.actionMap.put("info", false);
        this.actionMap.put("mkconn", false);
        this.actionMap.put("init", false);
        this.actionMap.put("lscaptured", false);
        this.actionMap.put("lsconverted", false);
        this.actionMap.put("lsconn", false);
        this.actionMap.put("delcaptured", false);
        this.actionMap.put("delconverted", false);
        this.actionMap.put("delconn", false);
        this.actionMap.put("qm", false);
        this.actionMap.put("capture", false);
        this.actionMap.put("idmap", false);
        this.actionMap.put("convert", false);
        this.actionMap.put("generate", false);
        this.actionMap.put("runsql", false);
        this.actionMap.put("datamove", false);
        this.actionMap.put("scan", false);
        this.actionMap.put("translate", false);
    }

    public String[] getAllActionNames() {
        String[] stringArray = null;
        if (this.m_actionNames == null || this.m_actionNames.length == 0) {
            String string = this.m_properties.get("actions");
            if (string == null || string.equals("")) {
                String string2 = string = this.m_properties.get("help") != null ? this.m_properties.get("help") : this.m_properties.get("h");
            }
            if (string != null && string.trim().length() > 0) {
                stringArray = string.split(",");
                this.m_actionNames = this.sortInExecutionOrder(stringArray);
            }
        }
        return this.m_actionNames;
    }

    public boolean isActionSpecified(String string) {
        for (String string2 : this.getAllActionNames()) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public void put(String string, String string2) {
        this.m_properties.put(string.toLowerCase(), string2);
    }

    public String get(String string) {
        return this.m_properties.get(string.toLowerCase());
    }

    public boolean contains(String string) {
        return this.m_properties.containsKey(string);
    }

    public void setCurrentCaptureModel(String string) {
        this.m_properties.put("capturedmodel", string);
    }

    public String getCurrentCapturedModel() {
        return this.m_properties.get("capturedmodel");
    }

    public void setCurrentConvertedModel(String string) {
        this.m_properties.put("convertedmodel", string);
    }

    public String getCurrentConvertedModel() {
        return this.m_properties.get("convertedmodel");
    }

    public void setCurrentProject(String string) {
        this.m_properties.put("project", string);
    }

    public String getCurrentProject() {
        return this.m_properties.get("project");
    }

    public Long getLastCapturedModelId() {
        ListCapturedModelsCmd listCapturedModelsCmd = null;
        try {
            listCapturedModelsCmd = (ListCapturedModelsCmd)MigrationCmdRegistry.getMigrationCmd("lscaptured", this, this.getOut(), true);
            listCapturedModelsCmd.execute();
            return listCapturedModelsCmd.getLatestCapturedModel();
        }
        catch (Exception exception) {
            this.getOut().printError(exception.getLocalizedMessage());
            return null;
        }
    }

    public int getCapturedModelCount() {
        ListCapturedModelsCmd listCapturedModelsCmd = null;
        int n = 0;
        try {
            listCapturedModelsCmd = (ListCapturedModelsCmd)MigrationCmdRegistry.getMigrationCmd("lscaptured", this, this.getOut(), true);
            listCapturedModelsCmd.execute();
            n = listCapturedModelsCmd.getModelCount();
        }
        catch (Exception exception) {
            this.getOut().printError(exception.getLocalizedMessage());
        }
        return n;
    }

    void printRegisteredActions() {
        Object object = "";
        this.resetMap();
        Iterator<String> iterator = this.actionMap.keySet().iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String string = iterator.next();
            arrayList.add(string);
        }
        Collections.sort(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i == arrayList.size() - 1) {
                object = (String)object + " and ";
                object = (String)object + (String)arrayList.get(i);
                continue;
            }
            object = (String)object + (String)arrayList.get(i);
            if (i == arrayList.size() - 2) continue;
            object = (String)object + ", ";
        }
        this.getOut().printError((String)object);
    }

    private String getKey(String string) {
        int n = string.indexOf(KEYMARKER);
        int n2 = string.indexOf(KEYVALUESEP);
        if (n == -1) {
            this.usage("Missing \"-\" marker");
        } else {
            string = n2 == -1 ? string.substring(n + 1) : string.substring(n + 1, n2);
        }
        return string;
    }

    private String getValue(String string) {
        int n = string.indexOf(KEYVALUESEP);
        if (n == -1) {
            return null;
        }
        return string.substring(n + 1);
    }

    private String[] sortInExecutionOrder(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        String[] stringArray2 = null;
        this.resetMap();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            string2 = stringArray[i].toLowerCase();
            if (this.actionMap.get(string2) == null || this.actionMap.get(string2).booleanValue()) continue;
            this.actionMap.put(string2, true);
        }
        for (String string2 : this.actionMap.keySet()) {
            if (!this.actionMap.get(string2).booleanValue()) continue;
            arrayList.add(string2);
        }
        stringArray2 = new String[arrayList.size()];
        return arrayList.toArray(stringArray2);
    }

    private void usage(String string) {
        System.out.println(string);
        MigrationCmdHelp.usage("help", this.getOut());
    }

    public String[] getConnList() {
        return this.m_properties.get("conn").split(",");
    }

    public CMDOut getOut() {
        if (this.cmdout == null && this.isOutputSpecified()) {
            PrintStream printStream = null;
            PrintStream printStream2 = null;
            try {
                String string = this.getOutputDir() + File.separator + "log";
                String string2 = string + File.separator + "log.txt";
                String string3 = string + File.separator + "error.txt";
                if (this.createDir(string)) {
                    FileOutputStream fileOutputStream = new FileOutputStream(string2, true);
                    printStream = new PrintStream(fileOutputStream);
                    FileOutputStream fileOutputStream2 = new FileOutputStream(string3, true);
                    printStream2 = new PrintStream(fileOutputStream2);
                    if (printStream != null && printStream2 != null) {
                        PrintStream[] printStreamArray = new PrintStream[]{System.out, printStream};
                        PrintStream[] printStreamArray2 = new PrintStream[]{System.err, printStream2};
                        boolean[] blArray = new boolean[]{this.isSilent(), false};
                        this.cmdout = new CMDOut(blArray, printStreamArray, printStreamArray2);
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("Error:problem creating logs:" + exception.getLocalizedMessage());
            }
        }
        if (this.cmdout == null) {
            this.cmdout = new CMDOut(false, System.out, System.err);
        }
        return this.cmdout;
    }

    private boolean createDir(String string) {
        boolean bl = false;
        File file = new File(string);
        bl = !file.exists() ? new File(string).mkdirs() : true;
        return bl;
    }

    private boolean isSilent() {
        return this.contains("silent");
    }

    protected String getOutputDir() {
        return this.get("output");
    }

    protected String getPrefs() {
        return this.get("prefs");
    }

    protected boolean is12c() {
        return this.getPrefs() != null && this.getPrefs().toLowerCase().indexOf("12c:true") != -1;
    }

    protected boolean isGenerationSingleFile() {
        return this.getPrefs() != null && this.getPrefs().toLowerCase().indexOf("fpo:true") != -1;
    }

    private boolean isOutputSpecified() {
        return this.get("output") != null;
    }

    public boolean isValid() {
        return this.getAllActionNames() != null;
    }

    public String getConnDetails() {
        return this.get("connDetails");
    }

    public void setGenerationScript(String string) {
        this.m_properties.put("sql", string);
    }
}

